/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.thesportsdb;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.tinymediamanager.core.FeatureNotEnabledException;
import org.tinymediamanager.scraper.MediaProviderInfo;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.interfaces.IMediaProvider;
import org.tinymediamanager.scraper.thesportsdb.TheSportsDbController;
import org.tinymediamanager.scraper.tmdb.entities.Configuration;

public abstract class TheSportsDbMetadataProvider
implements IMediaProvider {
    private final MediaProviderInfo providerInfo = this.createMediaProviderInfo();
    protected TheSportsDbController api;
    protected Configuration configuration;
    protected String artworkBaseUrl;

    TheSportsDbMetadataProvider() {
    }

    protected abstract String getSubId();

    protected MediaProviderInfo createMediaProviderInfo() {
        MediaProviderInfo info = new MediaProviderInfo("tsdb", this.getSubId(), "thesportsdb.com", "<html><h3>The Sports Database (TSDb)</h3><br />An open, crowd-sourced sports database of artwork and metadata<br /><br />Available languages: multiple</html>", TheSportsDbMetadataProvider.class.getResource("/org/tinymediamanager/scraper/thesportsdb.svg"), 50);
        info.getConfig().addText("apiKey", "", true);
        info.getConfig().load();
        return info;
    }

    @Override
    public MediaProviderInfo getProviderInfo() {
        return this.providerInfo;
    }

    protected abstract Logger getLogger();

    protected synchronized void initAPI() throws ScrapeException {
        String userApiKey;
        if (this.api != null) {
            userApiKey = this.providerInfo.getUserApiKey();
            if (StringUtils.isNotBlank((CharSequence)userApiKey) && !userApiKey.equals(this.api.getApiKey())) {
                this.api = null;
            } else if (StringUtils.isBlank((CharSequence)userApiKey) && !this.getApiKey().equals(this.api.getApiKey())) {
                this.api = null;
            }
        }
        if (this.api == null) {
            if (!this.isActive()) {
                throw new ScrapeException(new FeatureNotEnabledException(this));
            }
            try {
                userApiKey = this.providerInfo.getUserApiKey();
                this.api = new TheSportsDbController(StringUtils.isNotBlank((CharSequence)userApiKey) ? userApiKey : this.getApiKey());
            }
            catch (Exception e) {
                this.getLogger().error("could not initialize the API: {}", (Object)e.getMessage());
                this.api = null;
                throw new ScrapeException(e);
            }
        }
    }

    @Override
    public boolean isActive() {
        return this.isFeatureEnabled() && this.isApiKeyAvailable(this.providerInfo.getUserApiKey());
    }
}

