/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.subdl;

import java.io.IOException;
import okhttp3.ResponseBody;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.tinymediamanager.core.FeatureNotEnabledException;
import org.tinymediamanager.scraper.MediaProviderInfo;
import org.tinymediamanager.scraper.exceptions.HttpException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.interfaces.IMediaProvider;
import org.tinymediamanager.scraper.subdl.SubdlController;
import org.tinymediamanager.scraper.subdl.model.SubdlModel;
import retrofit2.Response;

abstract class SubdlSubtitleProvider
implements IMediaProvider {
    public static final String ID = "subdl";
    public static final String API_KEY = "apiKey";
    protected static final String BASE_URL_DL = "https://dl.subdl.com";
    protected SubdlController controller = null;
    protected final MediaProviderInfo providerInfo = this.createMediaProviderInfo();

    protected abstract String getSubId();

    protected abstract Logger getLogger();

    SubdlSubtitleProvider() {
    }

    protected MediaProviderInfo createMediaProviderInfo() {
        MediaProviderInfo info = new MediaProviderInfo(ID, this.getSubId(), "Subdl", "<html><h3>Subdl.com</h3><br />A subtitle scraper for Subdl.com</html>", SubdlSubtitleProvider.class.getResource("/org/tinymediamanager/scraper/subdl.png"));
        info.getConfig().addText(API_KEY, "", true);
        info.getConfig().load();
        return info;
    }

    @Override
    public boolean isActive() {
        return this.isFeatureEnabled() && StringUtils.isNotBlank((CharSequence)this.getUserApiKey()) && this.isApiKeyAvailable(null);
    }

    protected void initAPI() throws ScrapeException {
        if (this.controller == null) {
            if (!this.isActive()) {
                throw new ScrapeException(new FeatureNotEnabledException(this));
            }
            this.controller = new SubdlController(this.getApiKey());
            this.controller.setUserApiKey(this.getUserApiKey());
        }
    }

    @Nullable
    protected SubdlModel processResponse(Response<SubdlModel> response) throws IOException {
        if (!response.isSuccessful()) {
            String message = response.message();
            try (ResponseBody body = response.errorBody();){
                message = body.string();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new HttpException(response.code(), message);
        }
        SubdlModel searchResult = (SubdlModel)response.body();
        return searchResult;
    }

    protected String getUserApiKey() {
        return this.providerInfo.getConfig().getValue(API_KEY);
    }
}

