/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.http;

import java.io.IOException;
import java.util.HashMap;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TmmHttpHeaderLoggerInterceptor
implements Interceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(TmmHttpHeaderLoggerInterceptor.class);

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Response response;
        Headers headersResponse;
        Request request = chain.request();
        Headers headersRequest = request.headers();
        if (headersRequest.size() > 0) {
            HashMap headers = new HashMap(headersRequest.toMultimap());
            headers.remove("authorization");
            headers.remove("cookie");
            headers.remove("user-agent");
            headers.remove("x-api-key");
            headers.remove("api-key");
            headers.remove("referer");
            LOGGER.trace("-> Headers: {}", headers);
        }
        if ((headersResponse = (response = chain.proceed(request)).headers()).size() > 0) {
            HashMap headers = new HashMap(headersResponse.toMultimap());
            headers.remove("set-cookie");
            LOGGER.trace("<- Headers: {}", headers);
        }
        return response;
    }
}

