/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.library.bluray.playlist;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.tinymediamanager.library.bluray.playlist.ClipInfo;
import org.tinymediamanager.library.bluray.playlist.StringIOHelper;
import org.tinymediamanager.library.bluray.playlist.UnsignedIntHelper;

public class SubPlayItem {
    private int id;
    private ClipInfo[] subClipEntries;
    private int spConnectionCondition;
    private boolean isMultiClipEntries;
    private long subPlayItemInTime;
    private long subPlayItemOutTime;
    private int syncPlayItemId;
    private long syncStartPtsOfPlayItem;

    public SubPlayItem() {
    }

    public SubPlayItem(int n) {
        this.id = n;
    }

    public void readObject(DataInputStream dataInputStream) throws IOException {
        ArrayList<ClipInfo> arrayList = new ArrayList<ClipInfo>();
        byte[] byArray = new byte[4];
        byte[] byArray2 = new byte[4];
        byte[] byArray3 = new byte[4];
        dataInputStream.skipBytes(2);
        String string = StringIOHelper.readISO646String(dataInputStream, 5);
        String string2 = StringIOHelper.readISO646String(dataInputStream, 4);
        dataInputStream.skipBytes(3);
        byte by = dataInputStream.readByte();
        this.setSpConnectionCondition((by & 0x1E) >> 1);
        this.setIsMultiClipEntries((by & 1) != 0);
        byte by2 = dataInputStream.readByte();
        dataInputStream.readFully(byArray);
        this.setSubPlayItemInTime(UnsignedIntHelper.convertToLong(byArray));
        dataInputStream.readFully(byArray2);
        this.setSubPlayItemOutTime(UnsignedIntHelper.convertToLong(byArray2));
        this.setSyncPlayItemId(dataInputStream.readUnsignedShort());
        dataInputStream.readFully(byArray3);
        this.setSyncStartPtsOfPlayItem(UnsignedIntHelper.convertToLong(byArray3));
        ClipInfo clipInfo = new ClipInfo(0, string, string2, by2);
        arrayList.add(clipInfo);
        if (this.getIsMultiClipEntries()) {
            int n = dataInputStream.readByte();
            dataInputStream.skipBytes(1);
            for (int i = 1; i < n; ++i) {
                string = StringIOHelper.readISO646String(dataInputStream, 5);
                string2 = StringIOHelper.readISO646String(dataInputStream, 4);
                by2 = dataInputStream.readByte();
                clipInfo = new ClipInfo(i, string, string2, by2);
                arrayList.add(clipInfo);
            }
        }
        ClipInfo[] clipInfoArray = arrayList.toArray(new ClipInfo[arrayList.size()]);
        this.setSubClipEntries(clipInfoArray);
    }

    public void writeObject(DataOutputStream dataOutputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream2 = new DataOutputStream(byteArrayOutputStream);
        ClipInfo[] clipInfoArray = this.getSubClipEntries();
        dataOutputStream2.write(StringIOHelper.getISO646Bytes(clipInfoArray[0].getClipName()));
        dataOutputStream2.write(StringIOHelper.getISO646Bytes("M2TS"));
        dataOutputStream2.write(new byte[3]);
        int n = this.getSpConnectionCondition() << 1;
        dataOutputStream2.writeByte(n |= this.getIsMultiClipEntries() ? 1 : 0);
        dataOutputStream2.writeByte(clipInfoArray[0].getStcId());
        dataOutputStream2.write(UnsignedIntHelper.convertToBytes(this.getSubPlayItemInTime()));
        dataOutputStream2.write(UnsignedIntHelper.convertToBytes(this.getSubPlayItemOutTime()));
        dataOutputStream2.writeShort(this.getSyncPlayItemId());
        dataOutputStream2.write(UnsignedIntHelper.convertToBytes(this.getSyncStartPtsOfPlayItem()));
        if (this.getIsMultiClipEntries()) {
            dataOutputStream2.writeByte(clipInfoArray.length);
            dataOutputStream2.writeByte(0);
            for (int i = 1; i < clipInfoArray.length; ++i) {
                dataOutputStream2.write(StringIOHelper.getISO646Bytes(clipInfoArray[i].getClipName()));
                dataOutputStream2.write(StringIOHelper.getISO646Bytes("M2TS"));
                dataOutputStream2.writeByte(clipInfoArray[i].getStcId());
            }
        }
        dataOutputStream2.flush();
        dataOutputStream2.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        dataOutputStream.writeShort(byArray.length);
        dataOutputStream.write(byArray);
    }

    @XmlAttribute
    public int getId() {
        return this.id;
    }

    public void setId(int n) {
        this.id = n;
    }

    @XmlElement(name="SubClipInfo")
    public ClipInfo[] getSubClipEntries() {
        return this.subClipEntries;
    }

    public void setSubClipEntries(ClipInfo[] clipInfoArray) {
        for (int i = 0; i < clipInfoArray.length; ++i) {
            if (i == clipInfoArray[i].getId()) continue;
            throw new IllegalArgumentException("id does not match the array order");
        }
        this.subClipEntries = clipInfoArray;
    }

    public int getSpConnectionCondition() {
        return this.spConnectionCondition;
    }

    public void setSpConnectionCondition(int n) {
        if (n != 1 && n != 5 && n != 6) {
            throw new IllegalArgumentException("sp_connection_condition should be either 1, 5 or 6 " + n);
        }
        this.spConnectionCondition = n;
    }

    public boolean getIsMultiClipEntries() {
        return this.isMultiClipEntries;
    }

    public void setIsMultiClipEntries(boolean bl) {
        this.isMultiClipEntries = bl;
    }

    public long getSubPlayItemInTime() {
        return this.subPlayItemInTime;
    }

    public void setSubPlayItemInTime(long l) {
        this.subPlayItemInTime = l;
    }

    public long getSubPlayItemOutTime() {
        return this.subPlayItemOutTime;
    }

    public void setSubPlayItemOutTime(long l) {
        this.subPlayItemOutTime = l;
    }

    public int getSyncPlayItemId() {
        return this.syncPlayItemId;
    }

    public void setSyncPlayItemId(int n) {
        this.syncPlayItemId = n;
    }

    public long getSyncStartPtsOfPlayItem() {
        return this.syncStartPtsOfPlayItem;
    }

    public void setSyncStartPtsOfPlayItem(long l) {
        this.syncStartPtsOfPlayItem = l;
    }
}

