/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie;

import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.RenamerPreviewContainer;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieRenamer;
import org.tinymediamanager.core.movie.entities.Movie;

public class MovieRenamerPreview {
    private final Movie movie;
    private final Movie clone;
    private final RenamerPreviewContainer container;

    public MovieRenamerPreview(Movie movie) {
        this.movie = movie;
        this.clone = new Movie();
        this.clone.merge(movie);
        this.clone.setDataSource(movie.getDataSource());
        this.container = new RenamerPreviewContainer(movie);
    }

    public RenamerPreviewContainer generatePreview() {
        String newPath = MovieRenamer.createDestinationForFoldername(MovieModuleManager.getInstance().getSettings().getRenamerPathname(), this.movie);
        this.container.newPath = StringUtils.isNotBlank((CharSequence)newPath) ? Paths.get(this.movie.getDataSource(), newPath) : this.movie.getPathNIO();
        this.clone.setPath(this.container.newPath.toString());
        this.processMovie();
        HashMap<String, RenamerPreviewContainer.MediaFileTypeContainer> duplicates = new HashMap<String, RenamerPreviewContainer.MediaFileTypeContainer>();
        for (RenamerPreviewContainer.MediaFileTypeContainer files : this.container.getFiles()) {
            for (String rel : files.newFiles) {
                if (duplicates.containsKey(rel)) {
                    files.duped = true;
                    RenamerPreviewContainer.MediaFileTypeContainer other = (RenamerPreviewContainer.MediaFileTypeContainer)duplicates.get(rel);
                    other.duped = true;
                    this.container.renamerProblems = true;
                    continue;
                }
                duplicates.put(rel, files);
            }
        }
        duplicates.clear();
        return this.container;
    }

    private void processMovie() {
        String newVideoBasename = MovieRenamer.generateNewVideoBasename(this.movie);
        for (MediaFileType type : MediaFileType.values()) {
            RenamerPreviewContainer.MediaFileTypeContainer c = new RenamerPreviewContainer.MediaFileTypeContainer();
            for (MediaFile typeMf : this.movie.getMediaFiles(type)) {
                c.oldFiles.add(this.container.getOldPath().relativize(typeMf.getFileAsPath()).toString());
                List<MediaFile> mfs = MovieRenamer.generateFilename(this.movie, new MediaFile(typeMf), newVideoBasename);
                for (MediaFile mf : mfs) {
                    c.newFiles.add(this.container.getOldPath().relativize(mf.getFileAsPath()).toString());
                }
            }
            if (c.oldFiles.isEmpty()) continue;
            this.container.addFile(c);
        }
    }
}

