/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;

public class FilesFirstWalker {
    private final LinkOption[] linkOptions;

    public FilesFirstWalker(boolean followLinks) {
        LinkOption[] linkOptionArray;
        if (followLinks) {
            linkOptionArray = new LinkOption[]{};
        } else {
            LinkOption[] linkOptionArray2 = new LinkOption[1];
            linkOptionArray = linkOptionArray2;
            linkOptionArray2[0] = LinkOption.NOFOLLOW_LINKS;
        }
        this.linkOptions = linkOptionArray;
    }

    public void walk(Path start, FileVisitor<? super Path> visitor) throws IOException {
        BasicFileAttributes attrs;
        try {
            attrs = Files.readAttributes(start, BasicFileAttributes.class, this.linkOptions);
        }
        catch (IOException e) {
            visitor.visitFileFailed(start, e);
            return;
        }
        if (!attrs.isDirectory()) {
            visitor.visitFile(start, attrs);
            return;
        }
        this.walkDir(start, visitor);
    }

    private void walkDir(Path dir, FileVisitor<? super Path> visitor) throws IOException {
        BasicFileAttributes dirAttrs;
        try {
            dirAttrs = Files.readAttributes(dir, BasicFileAttributes.class, this.linkOptions);
        }
        catch (IOException e) {
            visitor.visitFileFailed(dir, e);
            return;
        }
        FileVisitResult pre = visitor.preVisitDirectory(dir, dirAttrs);
        if (pre == FileVisitResult.SKIP_SUBTREE) {
            return;
        }
        if (pre == FileVisitResult.TERMINATE) {
            throw new WalkTerminatedException();
        }
        ArrayList<Path> subdirs = new ArrayList<Path>();
        try (DirectoryStream<Path> ds = Files.newDirectoryStream(dir);){
            for (Path entry : ds) {
                FileVisitResult vr;
                BasicFileAttributes a;
                try {
                    a = Files.readAttributes(entry, BasicFileAttributes.class, this.linkOptions);
                }
                catch (IOException e) {
                    FileVisitResult vr2 = visitor.visitFileFailed(entry, e);
                    if (vr2 != FileVisitResult.TERMINATE) continue;
                    throw new WalkTerminatedException();
                }
                if (a.isRegularFile() || a.isOther()) {
                    vr = visitor.visitFile(entry, a);
                    if (vr == FileVisitResult.TERMINATE) {
                        throw new WalkTerminatedException();
                    }
                    if (vr != FileVisitResult.SKIP_SUBTREE) continue;
                    return;
                }
                if (a.isDirectory()) {
                    subdirs.add(entry);
                    continue;
                }
                if (!a.isSymbolicLink()) continue;
                vr = visitor.visitFile(entry, a);
                if (vr == FileVisitResult.TERMINATE) {
                    throw new WalkTerminatedException();
                }
                if (vr != FileVisitResult.SKIP_SUBTREE) continue;
                return;
            }
        }
        catch (IOException e) {
            FileVisitResult vr = visitor.postVisitDirectory(dir, e);
            if (vr == FileVisitResult.TERMINATE) {
                throw new WalkTerminatedException();
            }
            return;
        }
        for (Path sub : subdirs) {
            try {
                this.walkDir(sub, visitor);
            }
            catch (WalkTerminatedException t) {
                throw t;
            }
            catch (IOException e) {
                FileVisitResult vr = visitor.postVisitDirectory(sub, e);
                if (vr != FileVisitResult.TERMINATE) continue;
                throw new WalkTerminatedException();
            }
        }
        FileVisitResult vr = visitor.postVisitDirectory(dir, null);
        if (vr == FileVisitResult.TERMINATE) {
            throw new WalkTerminatedException();
        }
    }

    private static class WalkTerminatedException
    extends RuntimeException {
        private WalkTerminatedException() {
        }
    }
}

