/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.loopfs.udf.descriptor;

import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.DescriptorTag;
import com.github.stephenc.javaisotools.loopfs.udf.exceptions.InvalidDescriptor;
import com.github.stephenc.javaisotools.loopfs.util.LittleEndian;
import java.math.BigInteger;
import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;

public abstract class UDFDescriptor {
    public DescriptorTag tag;
    public final int TAG_LENGTH = 16;
    public int currentPos = 16;

    public UDFDescriptor() {
    }

    public UDFDescriptor(byte[] byArray) throws InvalidDescriptor {
        this.deserialize(byArray);
        this.verifyTagIdentifier();
    }

    public abstract int getExpectedTagIdentifier();

    public abstract void deserialize(byte[] var1) throws InvalidDescriptor;

    public void verifyTagIdentifier() throws InvalidDescriptor {
        Integer n = this.tag.identifier;
        if (n.intValue() != this.getExpectedTagIdentifier()) {
            throw new InvalidDescriptor("Unexpected tag identifier: " + n.toString());
        }
    }

    public void deserializeTag(byte[] byArray) throws InvalidDescriptor {
        this.tag = new DescriptorTag(byArray);
    }

    public int getUInt8(byte[] byArray) {
        int n = LittleEndian.getUInt8((byte[])byArray, (int)this.currentPos);
        ++this.currentPos;
        return n;
    }

    public int getUInt16(byte[] byArray) {
        int n = LittleEndian.getUInt16((byte[])byArray, (int)this.currentPos);
        this.currentPos += 2;
        return n;
    }

    public long getUInt32(byte[] byArray) {
        long l = LittleEndian.getUInt32((byte[])byArray, (int)this.currentPos);
        this.currentPos += 4;
        return l;
    }

    public BigInteger getUInt64(byte[] byArray) {
        byte[] byArray2 = this.getBytes(byArray, 8);
        ArrayUtils.reverse((byte[])byArray2);
        return new BigInteger(byArray2);
    }

    public byte[] getBytes(byte[] byArray, int n) {
        byte[] byArray2 = Arrays.copyOfRange(byArray, this.currentPos, this.currentPos + n);
        this.currentPos += n;
        return byArray2;
    }
}

