/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.loopfs.spi;

import com.github.stephenc.javaisotools.loopfs.api.FileEntry;
import com.github.stephenc.javaisotools.loopfs.spi.AbstractFileSystem;
import com.github.stephenc.javaisotools.loopfs.spi.SeekableInput;
import com.github.stephenc.javaisotools.loopfs.spi.VolumeDescriptorSet;
import java.io.IOException;
import java.util.Iterator;

public abstract class AbstractBlockFileSystem<T extends FileEntry>
extends AbstractFileSystem<T> {
    private final int blockSize;
    private int reservedBlocks;
    protected VolumeDescriptorSet<T> volumeDescriptorSet;

    protected AbstractBlockFileSystem(SeekableInput seekableInput, boolean bl, int n, int n2) throws IOException {
        super(seekableInput, bl);
        if (n <= 0) {
            throw new IllegalArgumentException("'blockSize' must be > 0");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("'reservedBlocks' must be >= 0");
        }
        this.blockSize = n;
        this.reservedBlocks = n2;
    }

    public void setReservedBlocks(int n) {
        this.reservedBlocks = n;
    }

    public final Iterator<T> iterator() {
        this.ensureOpen();
        if (null == this.volumeDescriptorSet) {
            try {
                this.loadVolumeDescriptors();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        return this.iterator(this.volumeDescriptorSet.getRootEntry());
    }

    protected void loadVolumeDescriptors() throws IOException {
        byte[] byArray = new byte[this.blockSize];
        this.volumeDescriptorSet = this.createVolumeDescriptorSet();
        int n = this.reservedBlocks;
        while (this.readBlock(n, byArray) && !this.volumeDescriptorSet.deserialize(byArray)) {
            ++n;
        }
    }

    public final boolean readBlock(long l, byte[] byArray) throws IOException {
        int n = this.readData(l * (long)this.blockSize, byArray, 0, this.blockSize);
        if (n <= 0) {
            return false;
        }
        if (this.blockSize != n) {
            throw new IOException("Could not deserialize a complete block");
        }
        return true;
    }

    protected final synchronized int readData(long l, byte[] byArray, int n, int n2) throws IOException {
        this.seek(l);
        return this.read(byArray, n, n2);
    }

    protected final VolumeDescriptorSet<T> getVolumeDescriptorSet() {
        return this.volumeDescriptorSet;
    }

    protected abstract Iterator<T> iterator(T var1);

    protected abstract VolumeDescriptorSet<T> createVolumeDescriptorSet();
}

