/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.filters;

import java.util.List;
import java.util.regex.Matcher;
import javax.swing.JLabel;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.AbstractSettings;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowSettings;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.scraper.util.StrgUtils;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.tvshows.filters.AbstractTextTvShowUIFilter;
import org.tinymediamanager.ui.tvshows.filters.TvShowCountryFilter;
import org.tinymediamanager.ui.tvshows.filters.TvShowFilenameFilter;
import org.tinymediamanager.ui.tvshows.filters.TvShowNoteFilter;
import org.tinymediamanager.ui.tvshows.filters.TvShowStudioFilter;

public class TvShowAllInOneFilter
extends AbstractTextTvShowUIFilter {
    private final TvShowSettings settings = TvShowModuleManager.getInstance().getSettings();
    private final TvShowNoteFilter tvShowNoteFilter = new TvShowNoteFilter();
    private final TvShowFilenameFilter tvShowFilenameFilter = new TvShowFilenameFilter();
    private final TvShowStudioFilter tvShowStudioFilter = new TvShowStudioFilter();
    private final TvShowCountryFilter tvShowCountryFilter = new TvShowCountryFilter();

    @Override
    protected JLabel createLabel() {
        TmmLabel label = new TmmLabel(TmmResourceBundle.getString("filter.universal"));
        label.setHintIcon(IconManager.HINT);
        label.setToolTipText(TmmResourceBundle.getString("filter.universal.hint2"));
        return label;
    }

    @Override
    public String getId() {
        return "tvShowAllInOne";
    }

    @Override
    protected boolean accept(TvShow tvShow, List<TvShowEpisode> episodes, boolean invert) {
        if (StringUtils.isBlank((CharSequence)this.normalizedFilterText)) {
            return true;
        }
        List<AbstractSettings.UniversalFilterFields> filterFields = this.settings.getUniversalFilterFields();
        if (filterFields.contains((Object)AbstractSettings.UniversalFilterFields.NOTE)) {
            this.setFields(this.tvShowNoteFilter);
            if (this.tvShowNoteFilter.accept(tvShow, episodes, invert)) {
                return true;
            }
        }
        if (filterFields.contains((Object)AbstractSettings.UniversalFilterFields.FILENAME)) {
            this.setFields(this.tvShowFilenameFilter);
            if (this.tvShowFilenameFilter.accept(tvShow, episodes, invert)) {
                return true;
            }
        }
        if (filterFields.contains((Object)AbstractSettings.UniversalFilterFields.PRODUCTION_COMPANY)) {
            this.setFields(this.tvShowStudioFilter);
            if (this.tvShowStudioFilter.accept(tvShow, episodes, invert)) {
                return true;
            }
        }
        if (filterFields.contains((Object)AbstractSettings.UniversalFilterFields.COUNTRY)) {
            this.setFields(this.tvShowCountryFilter);
            if (this.tvShowCountryFilter.accept(tvShow, episodes, invert)) {
                return true;
            }
        }
        if (filterFields.contains((Object)AbstractSettings.UniversalFilterFields.ACTOR) && this.filterActors(tvShow, episodes, invert)) {
            return true;
        }
        if (filterFields.contains((Object)AbstractSettings.UniversalFilterFields.DIRECTOR) && this.filterDirectors(episodes, invert)) {
            return true;
        }
        if (filterFields.contains((Object)AbstractSettings.UniversalFilterFields.WRITER) && this.filterWriters(episodes, invert)) {
            return true;
        }
        return filterFields.contains((Object)AbstractSettings.UniversalFilterFields.TAGS) && this.filterTags(tvShow, episodes, invert);
    }

    private void setFields(AbstractTextTvShowUIFilter filter) {
        filter.textField = this.textField;
        filter.filterPattern = this.filterPattern;
        filter.normalizedFilterText = this.normalizedFilterText;
    }

    private boolean filterActors(TvShow tvShow, List<TvShowEpisode> episodes, boolean invert) {
        try {
            boolean foundShow = false;
            for (Person actor : tvShow.getActors()) {
                Matcher matcher = this.filterPattern.matcher(StrgUtils.normalizeString(actor.getName()));
                if (!matcher.find()) continue;
                foundShow = true;
            }
            if (!invert && foundShow) {
                return true;
            }
            if (invert && foundShow) {
                return false;
            }
            for (TvShowEpisode episode : episodes) {
                boolean found = false;
                for (Person actor : episode.getActors()) {
                    Matcher matcher;
                    if (!StringUtils.isNotBlank((CharSequence)actor.getName()) || !(matcher = this.filterPattern.matcher(StrgUtils.normalizeString(actor.getName()))).find()) continue;
                    found = true;
                    break;
                }
                if (invert && !found) {
                    return true;
                }
                if (invert || !found) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private boolean filterDirectors(List<TvShowEpisode> episodes, boolean invert) {
        try {
            for (TvShowEpisode episode : episodes) {
                boolean found = false;
                for (Person director : episode.getCrew()) {
                    Matcher matcher;
                    if (!StringUtils.isNotBlank((CharSequence)director.getName()) || !(matcher = this.filterPattern.matcher(StrgUtils.normalizeString(director.getName()))).find()) continue;
                    found = true;
                    break;
                }
                if (invert && !found) {
                    return true;
                }
                if (invert || !found) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private boolean filterWriters(List<TvShowEpisode> episodes, boolean invert) {
        try {
            for (TvShowEpisode episode : episodes) {
                boolean found = false;
                for (Person writer : episode.getWriters()) {
                    Matcher matcher;
                    if (!StringUtils.isNotBlank((CharSequence)writer.getName()) || !(matcher = this.filterPattern.matcher(StrgUtils.normalizeString(writer.getName()))).find()) continue;
                    found = true;
                    break;
                }
                if (invert && !found) {
                    return true;
                }
                if (invert || !found) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    protected boolean filterTags(TvShow tvShow, List<TvShowEpisode> episodes, boolean invert) {
        try {
            boolean foundShow = false;
            for (String tag : tvShow.getTags()) {
                Matcher matcher;
                if (!StringUtils.isNotBlank((CharSequence)tag) || !(matcher = this.filterPattern.matcher(StrgUtils.normalizeString(tag))).find()) continue;
                foundShow = true;
                break;
            }
            if (!invert && foundShow) {
                return true;
            }
            if (invert && foundShow) {
                return false;
            }
            for (TvShowEpisode episode : episodes) {
                boolean foundEpisode = false;
                for (String tag : episode.getTags()) {
                    Matcher matcher;
                    if (!StringUtils.isNotBlank((CharSequence)tag) || !(matcher = this.filterPattern.matcher(StrgUtils.normalizeString(tag))).find()) continue;
                    foundEpisode = true;
                    break;
                }
                if (invert && !foundEpisode) {
                    return true;
                }
                if (invert || !foundEpisode) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

