/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.actions;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.tvshows.TvShowSelectionModel;
import org.tinymediamanager.ui.tvshows.TvShowUIModule;

public class TvShowDownloadActorImagesAction
extends TmmAction {
    public TvShowDownloadActorImagesAction() {
        this.putValue("Name", TmmResourceBundle.getString("tvshow.downloadactorimages"));
        this.putValue("SmallIcon", IconManager.IMAGE);
        this.putValue("SwingLargeIconKey", IconManager.IMAGE);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(65, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx() + 512));
    }

    @Override
    protected void processAction(ActionEvent e) {
        TvShowSelectionModel.SelectedObjects selectedObjects = TvShowUIModule.getInstance().getSelectionModel().getSelectedObjects();
        if (selectedObjects.isLockedFound()) {
            TvShowSelectionModel.showLockedInformation();
        }
        if (selectedObjects.isEmpty()) {
            return;
        }
        boolean overwriteActorImages = false;
        Object[] options = new Object[]{TmmResourceBundle.getString("Button.yes"), TmmResourceBundle.getString("Button.no")};
        int answer = JOptionPane.showOptionDialog(MainWindow.getFrame(), TmmResourceBundle.getString("tvshow.downloadactorimages.overwrite"), TmmResourceBundle.getString("tvshow.downloadactorimages"), 0, 3, null, options, null);
        if (answer == 0) {
            overwriteActorImages = true;
        }
        for (TvShow tvShow : selectedObjects.getTvShows()) {
            tvShow.writeActorImages(overwriteActorImages);
        }
        for (TvShowEpisode episode : selectedObjects.getEpisodesRecursive()) {
            episode.writeActorImages(overwriteActorImages);
        }
    }
}

