/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.actions;

import java.awt.event.ActionEvent;
import java.nio.file.Path;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.tasks.MediaEntityCopyTask;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.tvshows.TvShowUIModule;

public class TvShowCopyToAction
extends TmmAction {
    public TvShowCopyToAction() {
        this.putValue("Name", TmmResourceBundle.getString("tvshow.copyto"));
        this.putValue("ShortDescription", TmmResourceBundle.getString("tvshow.copyto.desc"));
        this.putValue("SmallIcon", IconManager.COPY);
        this.putValue("SwingLargeIconKey", IconManager.COPY);
    }

    @Override
    protected void processAction(ActionEvent e) {
        List<TvShow> selectedTvShows = TvShowUIModule.getInstance().getSelectionModel().getSelectedTvShows(true);
        if (selectedTvShows.isEmpty()) {
            JOptionPane.showMessageDialog(MainWindow.getInstance(), TmmResourceBundle.getString("tmm.nothingselected"));
            return;
        }
        SwingUtilities.invokeLater(() -> {
            Path folder = TmmUIHelper.selectDirectory(TmmResourceBundle.getString("tvshow.copyto"), null);
            if (folder != null) {
                MediaEntityCopyTask task = new MediaEntityCopyTask(selectedTvShows, folder);
                TmmTaskManager.getInstance().addUnnamedTask(task);
            }
        });
    }
}

