/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.plaf;

import com.formdev.flatlaf.ui.FlatTextAreaUI;
import java.awt.Toolkit;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.undo.UndoManager;
import org.tinymediamanager.ui.plaf.RedoAction;
import org.tinymediamanager.ui.plaf.UndoAction;

public class TmmTextAreaUI
extends FlatTextAreaUI {
    private UndoListener undoListener;
    private UndoManager undoManager;
    private UndoAction undoAction;
    private RedoAction redoAction;

    public static ComponentUI createUI(JComponent c) {
        return new TmmTextAreaUI();
    }

    protected void installDefaults() {
        super.installDefaults();
        this.undoManager = new UndoManager();
        this.undoAction = new UndoAction(this.getComponent(), this.undoManager);
        this.redoAction = new RedoAction(this.getComponent(), this.undoManager);
    }

    protected void installKeyboardActions() {
        super.installKeyboardActions();
        InputMap im = this.getComponent().getInputMap();
        ActionMap am = this.getComponent().getActionMap();
        am.put("undo", this.undoAction);
        am.put("redo", this.redoAction);
        int commandKey = Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx();
        im.put(KeyStroke.getKeyStroke(90, commandKey), "undo");
        im.put(KeyStroke.getKeyStroke(89, commandKey), "redo");
    }

    protected void modelChanged() {
        super.modelChanged();
        if (this.undoListener != null) {
            this.getComponent().getDocument().removeUndoableEditListener(this.undoListener);
        }
        this.undoListener = new UndoListener();
        this.getComponent().getDocument().addUndoableEditListener(this.undoListener);
    }

    private class UndoListener
    implements UndoableEditListener {
        private UndoListener() {
        }

        @Override
        public void undoableEditHappened(UndoableEditEvent e) {
            if (TmmTextAreaUI.this.getComponent() != null && TmmTextAreaUI.this.getComponent().isEditable()) {
                TmmTextAreaUI.this.undoManager.addEdit(e.getEdit());
            }
        }
    }
}

