/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.filters;

import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.bus.EventBus;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.SetUtils;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.movies.filters.AbstractCheckComboBoxMovieUIFilter;

public class MovieVideoCodecFilter
extends AbstractCheckComboBoxMovieUIFilter<String> {
    public MovieVideoCodecFilter() {
        this.checkComboBox.enableFilter((s, s2) -> s.toLowerCase(Locale.ROOT).contains(s2.toLowerCase(Locale.ROOT)));
        this.buildAndInstallVideoCodecArray();
        EventBus.registerListener(EventBus.TOPIC_MOVIES_UI, event -> this.buildAndInstallVideoCodecArray());
    }

    @Override
    public String getId() {
        return "movieVideoCodec";
    }

    @Override
    public boolean accept(Movie movie) {
        List selectedValues = this.checkComboBox.getSelectedItems();
        return selectedValues.contains(movie.getMediaInfoVideoCodec());
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(TmmResourceBundle.getString("metatag.videocodec"));
    }

    private void buildAndInstallVideoCodecArray() {
        HashSet<String> videoCodecsInMovies = new HashSet<String>(this.movieList.getVideoCodecsInMovies());
        if (!SetUtils.equals(this.oldValues, videoCodecsInMovies)) {
            this.oldValues.clear();
            this.oldValues.addAll(videoCodecsInMovies);
            List<String> sortedVideoCodecs = ListUtils.asSortedList(videoCodecsInMovies);
            SwingUtilities.invokeLater(() -> this.setValues(sortedVideoCodecs));
        }
    }

    @Override
    protected String parseTypeToString(String type) throws Exception {
        return type;
    }

    @Override
    protected String parseStringToType(String string) throws Exception {
        return string;
    }
}

