/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.filters;

import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.bus.EventBus;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.SetUtils;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.movies.filters.AbstractCheckComboBoxMovieUIFilter;

public class MovieSubtitleLanguageFilter
extends AbstractCheckComboBoxMovieUIFilter<String> {
    public MovieSubtitleLanguageFilter() {
        this.checkComboBox.enableFilter((s, s2) -> s.toLowerCase(Locale.ROOT).contains(s2.toLowerCase(Locale.ROOT)));
        this.buildAndInstallSubtitleLanguageArray();
        EventBus.registerListener(EventBus.TOPIC_MOVIES_UI, event -> this.buildAndInstallSubtitleLanguageArray());
    }

    @Override
    protected String parseTypeToString(String type) throws Exception {
        return type;
    }

    @Override
    protected String parseStringToType(String string) throws Exception {
        return string;
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(TmmResourceBundle.getString("metatag.subtitlelanguage"));
    }

    @Override
    public String getId() {
        return "movieSubtitleLanguage";
    }

    @Override
    public boolean accept(Movie movie) {
        List selectedItems = this.checkComboBox.getSelectedItems();
        List<String> lang = movie.getMediaInfoSubtitleLanguageList();
        for (String sel : selectedItems) {
            if (!lang.contains(sel)) continue;
            return true;
        }
        return false;
    }

    public void buildAndInstallSubtitleLanguageArray() {
        HashSet<String> subtitleLanguagesInMovies = new HashSet<String>(this.movieList.getSubtitleLanguagesInMovies());
        if (!SetUtils.equals(this.oldValues, subtitleLanguagesInMovies)) {
            this.oldValues.clear();
            this.oldValues.addAll(subtitleLanguagesInMovies);
            List<String> sortedSubtitleLanguages = ListUtils.asSortedList(subtitleLanguagesInMovies);
            SwingUtilities.invokeLater(() -> this.setValues(sortedSubtitleLanguages));
        }
    }
}

