/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.filters;

import javax.swing.JLabel;
import javax.swing.SpinnerNumberModel;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.movies.filters.AbstractNumberMovieFilter;

public class MoviePosterSizeFilter
extends AbstractNumberMovieFilter {
    public MoviePosterSizeFilter() {
        this.spinnerLow.setEditor(this.prepareNumberEditor(this.spinnerLow, "####0 px"));
        this.spinnerHigh.setEditor(this.prepareNumberEditor(this.spinnerHigh, "####0 px"));
    }

    @Override
    public String getId() {
        return "moviePosterSize";
    }

    @Override
    protected SpinnerNumberModel getNumberModel() {
        return new SpinnerNumberModel(0, 0, 99999, 1);
    }

    @Override
    public boolean accept(Movie movie) {
        return this.matchInt(movie.getArtworkDimension((MediaFileType)MediaFileType.POSTER).height);
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(TmmResourceBundle.getString("filter.poster.height"));
    }
}

