/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.filters;

import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.bus.EventBus;
import org.tinymediamanager.core.entities.MediaGenres;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.SetUtils;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.movies.filters.AbstractCheckComboBoxMovieUIFilter;

public class MovieGenreFilter
extends AbstractCheckComboBoxMovieUIFilter<MediaGenres> {
    public MovieGenreFilter() {
        this.checkComboBox.enableFilter((s, s2) -> s.toString().toLowerCase(Locale.ROOT).contains(s2.toLowerCase(Locale.ROOT)));
        this.buildAndInstallMediaGenres();
        EventBus.registerListener(EventBus.TOPIC_MOVIES_UI, event -> this.buildAndInstallMediaGenres());
    }

    @Override
    public String getId() {
        return "movieGenre";
    }

    @Override
    public boolean accept(Movie movie) {
        List selectedItems = this.checkComboBox.getSelectedItems();
        if (selectedItems.isEmpty() && movie.getGenres().isEmpty()) {
            return true;
        }
        for (MediaGenres genre : movie.getGenres()) {
            if (!selectedItems.contains(genre)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(TmmResourceBundle.getString("movieextendedsearch.genre"));
    }

    private void buildAndInstallMediaGenres() {
        HashSet<MediaGenres> genres = new HashSet<MediaGenres>(this.movieList.getUsedGenres());
        if (!SetUtils.equals(this.oldValues, genres)) {
            this.oldValues.clear();
            this.oldValues.addAll(genres);
            List<MediaGenres> sortedGenres = ListUtils.asSortedList(genres);
            SwingUtilities.invokeLater(() -> this.setValues(sortedGenres));
        }
    }

    @Override
    protected String parseTypeToString(MediaGenres type) throws Exception {
        return type.name();
    }

    @Override
    protected MediaGenres parseStringToType(String string) throws Exception {
        return MediaGenres.getGenre(string);
    }
}

