/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.filters;

import java.util.HashSet;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.bus.EventBus;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.SetUtils;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.movies.filters.AbstractCheckComboBoxMovieUIFilter;

public class MovieDecadesFilter
extends AbstractCheckComboBoxMovieUIFilter<String> {
    public MovieDecadesFilter() {
        this.checkComboBox.enableFilter(String::startsWith);
        this.buildAndInstallDecadeArray();
        EventBus.registerListener(EventBus.TOPIC_MOVIES_UI, event -> this.buildAndInstallDecadeArray());
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(TmmResourceBundle.getString("metatag.decade"));
    }

    @Override
    public String getId() {
        return "movieDecades";
    }

    @Override
    public boolean accept(Movie movie) {
        List selectedItems = this.checkComboBox.getSelectedItems();
        return selectedItems.contains(movie.getDecadeShort());
    }

    @Override
    protected String parseTypeToString(String type) throws Exception {
        return type;
    }

    @Override
    protected String parseStringToType(String string) throws Exception {
        return string;
    }

    private void buildAndInstallDecadeArray() {
        HashSet<String> decadesInMovies = new HashSet<String>(this.movieList.getDecadesInMovies());
        if (!SetUtils.equals(this.oldValues, decadesInMovies)) {
            this.oldValues.clear();
            this.oldValues.addAll(decadesInMovies);
            List<String> sortedDecades = ListUtils.asSortedList(decadesInMovies);
            SwingUtilities.invokeLater(() -> this.setValues(sortedDecades));
        }
    }
}

