/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.filters;

import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.bus.EventBus;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.SetUtils;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.movies.filters.AbstractCheckComboBoxMovieUIFilter;

public class MovieAudioTitleFilter
extends AbstractCheckComboBoxMovieUIFilter<String> {
    public MovieAudioTitleFilter() {
        this.checkComboBox.enableFilter((s, s2) -> s.contains(s2.toLowerCase(Locale.ROOT)));
        this.buildAndInstallAudioTitleArray();
        EventBus.registerListener(EventBus.TOPIC_MOVIES_UI, event -> this.buildAndInstallAudioTitleArray());
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(TmmResourceBundle.getString("metatag.audiotitle"));
    }

    @Override
    public String getId() {
        return "movieAudioTitle";
    }

    @Override
    public boolean accept(Movie movie) {
        List selectedItems = this.checkComboBox.getSelectedItems();
        List<MediaFile> mediaFileList = movie.getMediaFiles(MediaFileType.VIDEO);
        for (MediaFile mf : mediaFileList) {
            if (selectedItems.isEmpty() && mf.getAudioTitleList().isEmpty()) {
                return true;
            }
            for (String title : mf.getAudioTitleList()) {
                if (!selectedItems.contains(title)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected String parseTypeToString(String type) throws Exception {
        return type;
    }

    @Override
    protected String parseStringToType(String string) throws Exception {
        return string;
    }

    private void buildAndInstallAudioTitleArray() {
        HashSet<String> audioTitlesInMovies = new HashSet<String>(this.movieList.getAudioTitlesInMovies());
        if (!SetUtils.equals(this.oldValues, audioTitlesInMovies)) {
            this.oldValues.clear();
            this.oldValues.addAll(audioTitlesInMovies);
            List<String> sortedAudioTitles = ListUtils.asSortedList(audioTitlesInMovies);
            SwingUtilities.invokeLater(() -> this.setValues(sortedAudioTitles));
        }
    }
}

