/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.filters;

import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.bus.EventBus;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.SetUtils;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.movies.filters.AbstractCheckComboBoxMovieUIFilter;

public class MovieAudioCodecFilter
extends AbstractCheckComboBoxMovieUIFilter<String> {
    public MovieAudioCodecFilter() {
        this.checkComboBox.enableFilter((s, s2) -> s.toLowerCase(Locale.ROOT).contains(s2.toLowerCase(Locale.ROOT)));
        this.buildAndInstallAudioCodecArray();
        EventBus.registerListener(EventBus.TOPIC_MOVIES_UI, event -> this.buildAndInstallAudioCodecArray());
    }

    @Override
    public String getId() {
        return "movieAudioCodec";
    }

    @Override
    public boolean accept(Movie movie) {
        List audioCodecs = this.checkComboBox.getSelectedItems();
        for (MediaFile mf : movie.getMediaFiles(MediaFileType.VIDEO, MediaFileType.AUDIO)) {
            for (String audioCodec : mf.getAudioCodecList()) {
                if (!audioCodecs.contains(audioCodec)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(TmmResourceBundle.getString("metatag.audiocodec"));
    }

    private void buildAndInstallAudioCodecArray() {
        HashSet<String> audioCodecsInMovies = new HashSet<String>(this.movieList.getAudioCodecsInMovies());
        if (!SetUtils.equals(this.oldValues, audioCodecsInMovies)) {
            this.oldValues.clear();
            this.oldValues.addAll(audioCodecsInMovies);
            List<String> sortedAudioCodecs = ListUtils.asSortedList(audioCodecsInMovies);
            SwingUtilities.invokeLater(() -> this.setValues(sortedAudioCodecs));
        }
    }

    @Override
    protected String parseTypeToString(String type) throws Exception {
        return type;
    }

    @Override
    protected String parseStringToType(String string) throws Exception {
        return string;
    }
}

