/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.ObservableElementList;
import com.fasterxml.jackson.databind.ObjectReader;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.h2.mvstore.MVMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.TmmOsUtils;
import org.tinymediamanager.core.AbstractModelObject;
import org.tinymediamanager.core.ImageCache;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.ObservableCopyOnWriteArrayList;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.bus.Event;
import org.tinymediamanager.core.bus.EventBus;
import org.tinymediamanager.core.bus.EventBusConnector;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.entities.MediaFileAudioStream;
import org.tinymediamanager.core.entities.MediaFileSubtitle;
import org.tinymediamanager.core.entities.MediaGenres;
import org.tinymediamanager.core.entities.MediaSource;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieRenamer;
import org.tinymediamanager.core.movie.MovieScraperMetadataConfig;
import org.tinymediamanager.core.movie.MovieSearchAndScrapeOptions;
import org.tinymediamanager.core.movie.MovieSetArtworkHelper;
import org.tinymediamanager.core.movie.MovieSetScraperMetadataConfig;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.entities.MovieSet;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.ScraperType;
import org.tinymediamanager.scraper.entities.MediaCertification;
import org.tinymediamanager.scraper.entities.MediaLanguages;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.interfaces.IMovieMetadataProvider;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.MediaIdUtil;
import org.tinymediamanager.scraper.util.MetadataUtil;
import org.tinymediamanager.scraper.util.StrgUtils;

public final class MovieList
extends AbstractModelObject {
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieList.class);
    private static volatile MovieList instance;
    private final List<Movie> movieList;
    private final List<MovieSet> movieSetList;
    private final CopyOnWriteArrayList<Integer> yearsInMovies;
    private final CopyOnWriteArrayList<String> tagsInMovies;
    private final CopyOnWriteArrayList<MediaGenres> genresInMovies;
    private final CopyOnWriteArrayList<String> videoCodecsInMovies;
    private final CopyOnWriteArrayList<String> videoContainersInMovies;
    private final CopyOnWriteArrayList<String> audioCodecsInMovies;
    private final CopyOnWriteArrayList<Integer> audioChannelsInMovies;
    private final CopyOnWriteArrayList<MediaCertification> certificationsInMovies;
    private final CopyOnWriteArrayList<Double> frameRatesInMovies;
    private final CopyOnWriteArrayList<Integer> audioStreamsInMovies;
    private final CopyOnWriteArrayList<Integer> subtitlesInMovies;
    private final CopyOnWriteArrayList<String> audioLanguagesInMovies;
    private final CopyOnWriteArrayList<String> subtitleLanguagesInMovies;
    private final CopyOnWriteArrayList<String> decadesInMovies;
    private final CopyOnWriteArrayList<String> hdrFormatInMovies;
    private final CopyOnWriteArrayList<String> audioTitlesInMovies;
    private final CopyOnWriteArrayList<String> subtitleFormatsInMovies;
    private final Map<UUID, Movie> byDbId;
    private final Map<Path, List<Movie>> byPath;
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final PropertyChangeListener movieSetListener;
    private final Comparator<MovieSet> movieSetComparator = new MovieSetComparator();

    private MovieList() {
        this.movieList = new ObservableElementList((EventList)GlazedLists.threadSafeList((EventList)new BasicEventList()), new EventBusConnector(EventBus.TOPIC_MOVIES));
        this.movieSetList = new ObservableCopyOnWriteArrayList<MovieSet>();
        this.byDbId = new HashMap<UUID, Movie>();
        this.byPath = new HashMap<Path, List<Movie>>();
        this.yearsInMovies = new CopyOnWriteArrayList();
        this.tagsInMovies = new CopyOnWriteArrayList();
        this.genresInMovies = new CopyOnWriteArrayList();
        this.videoCodecsInMovies = new CopyOnWriteArrayList();
        this.videoContainersInMovies = new CopyOnWriteArrayList();
        this.audioCodecsInMovies = new CopyOnWriteArrayList();
        this.audioChannelsInMovies = new CopyOnWriteArrayList();
        this.certificationsInMovies = new CopyOnWriteArrayList();
        this.frameRatesInMovies = new CopyOnWriteArrayList();
        this.audioStreamsInMovies = new CopyOnWriteArrayList();
        this.subtitlesInMovies = new CopyOnWriteArrayList();
        this.audioLanguagesInMovies = new CopyOnWriteArrayList();
        this.subtitleLanguagesInMovies = new CopyOnWriteArrayList();
        this.decadesInMovies = new CopyOnWriteArrayList();
        this.hdrFormatInMovies = new CopyOnWriteArrayList();
        this.audioTitlesInMovies = new CopyOnWriteArrayList();
        this.subtitleFormatsInMovies = new CopyOnWriteArrayList();
        EventBus.registerListener(EventBus.TOPIC_MOVIES, event -> {
            Object patt7739$temp = event.sender();
            if (patt7739$temp instanceof Movie) {
                Movie movie = (Movie)patt7739$temp;
                if (event.eventType().equals("save")) {
                    TmmTaskManager.getInstance().addUnnamedTask(() -> {
                        this.readWriteLock.writeLock().lock();
                        try {
                            this.deindexMovie(movie);
                            if (this.movieList.contains(movie)) {
                                this.indexMovie(movie);
                            }
                        }
                        finally {
                            this.readWriteLock.writeLock().unlock();
                        }
                    });
                }
            }
        });
        this.movieSetListener = evt -> {
            switch (evt.getPropertyName()) {
                case "addedMovie": 
                case "removedMovie": {
                    this.firePropertyChange("movieInMovieSetCount", null, this.getMovieInMovieSetCount());
                    break;
                }
            }
        };
        MovieModuleManager.getInstance().getSettings().addPropertyChangeListener(evt -> {
            switch (evt.getPropertyName()) {
                case "movieSetDataFolder": {
                    this.movieSetList.forEach(MovieSetArtworkHelper::updateArtwork);
                }
            }
        });
        EventBus.registerListener(EventBus.TOPIC_MOVIES, event -> {
            if (event.sender() instanceof Movie && (event.eventType().equals("remove") || event.eventType().equals("save"))) {
                EventBus.publishEvent("movieList", Event.createUpdateEvent(instance));
            }
        });
        EventBus.registerListener("movieList", event -> {
            if (event.sender() == instance) {
                ArrayList<Movie> movies = new ArrayList<Movie>();
                this.readWriteLock.readLock().lock();
                try {
                    movies.addAll(this.movieList);
                }
                finally {
                    this.readWriteLock.readLock().unlock();
                }
                this.updateYear(movies);
                this.updateDecades(movies);
                this.updateTags(movies);
                this.updateGenres(movies);
                this.updateCertifications(movies);
                this.updateMediaInformationLists(movies);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static MovieList getInstance() {
        if (instance != null) return instance;
        Class<MovieList> clazz = MovieList.class;
        synchronized (MovieList.class) {
            if (instance != null) return instance;
            instance = new MovieList();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    static void clearInstance() {
        instance = null;
    }

    public void addMovie(Movie movie) {
        if (this.findByDbId(movie.getDbId()).isEmpty()) {
            int oldValue = this.movieList.size();
            this.readWriteLock.writeLock().lock();
            try {
                this.movieList.add(movie);
                this.indexMovie(movie);
            }
            finally {
                this.readWriteLock.writeLock().unlock();
            }
            this.firePropertyChange("movies", null, this.movieList);
            this.firePropertyChange("movieCount", oldValue, this.movieList.size());
        }
    }

    void removeDatasource(String datasource) {
        if (StringUtils.isEmpty((CharSequence)datasource)) {
            return;
        }
        ArrayList<Movie> moviesToRemove = new ArrayList<Movie>();
        Path path = Paths.get(datasource, new String[0]);
        for (int i = this.movieList.size() - 1; i >= 0; --i) {
            Movie movie = this.movieList.get(i);
            if (!path.equals(Paths.get(movie.getDataSource(), new String[0]))) continue;
            moviesToRemove.add(movie);
        }
        this.removeMovies(moviesToRemove);
    }

    void exchangeDatasource(String oldDatasource, String newDatasource) {
        Path oldPath = Paths.get(oldDatasource, new String[0]);
        List<Movie> moviesToChange = this.movieList.stream().filter(movie -> oldPath.equals(Paths.get(movie.getDataSource(), new String[0]))).toList();
        ArrayList<MediaFile> imagesToCache = new ArrayList<MediaFile>();
        for (Movie movie2 : moviesToChange) {
            Path newMoviePath;
            Path oldMoviePath = movie2.getPathNIO();
            try {
                newMoviePath = Paths.get(newDatasource, Paths.get(movie2.getDataSource(), new String[0]).relativize(oldMoviePath).toString());
            }
            catch (Exception e) {
                newMoviePath = Paths.get(newDatasource, FilenameUtils.separatorsToSystem((String)movie2.getPath().replace(movie2.getDataSource(), "")));
            }
            movie2.setDataSource(newDatasource);
            movie2.setPath(newMoviePath.toAbsolutePath().toString());
            movie2.updateMediaFilePath(oldMoviePath, newMoviePath);
            movie2.saveToDb();
            imagesToCache.addAll(movie2.getImagesToCache());
        }
        if (!imagesToCache.isEmpty()) {
            imagesToCache.forEach(ImageCache::cacheImageAsync);
        }
    }

    public List<Movie> getUnscrapedMovies() {
        return this.movieList.parallelStream().filter(movie -> !movie.isScraped()).sorted(new MovieComparator()).collect(Collectors.toList());
    }

    public List<Movie> getNewMovies() {
        return this.movieList.parallelStream().filter(MediaEntity::isNewlyAdded).sorted(new MovieComparator()).collect(Collectors.toList());
    }

    public Collection<MediaGenres> getUsedGenres() {
        return Collections.unmodifiableList(this.genresInMovies);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMovies(List<Movie> movies) {
        if (movies == null || movies.isEmpty()) {
            return;
        }
        int oldValue = this.movieList.size();
        for (int i = movies.size() - 1; i >= 0; --i) {
            Movie movie = movies.get(i);
            if (movie.getMovieSet() != null) {
                MovieSet movieSet = movie.getMovieSet();
                movieSet.removeMovie(movie, false);
                movie.setMovieSet(null);
            }
            this.readWriteLock.writeLock().lock();
            try {
                this.deindexMovie(movie);
                this.movieList.remove(movie);
            }
            finally {
                this.readWriteLock.writeLock().unlock();
            }
            try {
                MovieModuleManager.getInstance().removeMovieFromDb(movie);
                EventBus.publishEvent(EventBus.TOPIC_MOVIES, Event.createRemoveEvent(movie));
            }
            catch (Exception e) {
                LOGGER.error("Error removing movie '{}' from DB - '{}'", (Object)movie.getTitle(), (Object)e.getMessage());
            }
            for (MediaFile mf : movie.getMediaFiles()) {
                if (!mf.isGraphic()) continue;
                ImageCache.invalidateCachedImage(mf);
            }
        }
        this.firePropertyChange("movies", null, this.movieList);
        this.firePropertyChange("movieCount", oldValue, this.movieList.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteMovies(List<Movie> movies) {
        if (movies == null || movies.isEmpty()) {
            return;
        }
        int oldValue = this.movieList.size();
        for (int i = movies.size() - 1; i >= 0; --i) {
            Movie movie = movies.get(i);
            movie.deleteFilesSafely();
            this.readWriteLock.writeLock().lock();
            try {
                this.deindexMovie(movie);
                this.movieList.remove(movie);
            }
            finally {
                this.readWriteLock.writeLock().unlock();
            }
            if (movie.getMovieSet() != null) {
                MovieSet movieSet = movie.getMovieSet();
                movieSet.removeMovie(movie, false);
                movie.setMovieSet(null);
            }
            try {
                MovieModuleManager.getInstance().removeMovieFromDb(movie);
                EventBus.publishEvent(EventBus.TOPIC_MOVIES, Event.createRemoveEvent(movie));
            }
            catch (Exception e) {
                LOGGER.error("Error removing movie '{}' from DB - '{}'", (Object)movie.getTitle(), (Object)e.getMessage());
            }
            for (MediaFile mf : movie.getMediaFiles()) {
                if (!mf.isGraphic()) continue;
                ImageCache.invalidateCachedImage(mf);
            }
        }
        this.firePropertyChange("movies", null, this.movieList);
        this.firePropertyChange("movieCount", oldValue, this.movieList.size());
    }

    public List<Movie> getMovies() {
        return this.movieList;
    }

    void loadMoviesFromDatabase(MVMap<UUID, String> movieMap) {
        LOGGER.info("Loading movies from database...");
        ObjectReader movieObjectReader = MovieModuleManager.getInstance().getMovieObjectReader();
        ArrayList toRemove = new ArrayList();
        HashSet loadedMoviesWithoutDuplicates = new HashSet();
        long start = System.nanoTime();
        new ArrayList<UUID>(movieMap.keyList()).forEach(uuid -> {
            String json = "";
            try {
                json = (String)movieMap.get(uuid);
                Movie movie = (Movie)movieObjectReader.readValue(json);
                movie.setDbId((UUID)uuid);
                if (this.isCorrupt(movie)) {
                    LOGGER.debug("Removing corrupt movie: {}", (Object)json);
                    toRemove.add(uuid);
                    return;
                }
                if (!loadedMoviesWithoutDuplicates.add(movie)) {
                    LOGGER.debug("removed duplicate '{}'", (Object)movie.getTitle());
                    toRemove.add(uuid);
                }
            }
            catch (Exception e) {
                LOGGER.debug("problem decoding movie json string: {}", (Object)json);
                LOGGER.warn("Dropping corrupt movie from database because of '{}'", (Object)e.getMessage());
                toRemove.add(uuid);
            }
        });
        this.movieList.addAll(loadedMoviesWithoutDuplicates);
        long end = System.nanoTime();
        for (UUID uuid2 : toRemove) {
            movieMap.remove((Object)uuid2);
        }
        LOGGER.debug("took {} ms", (Object)((end - start) / 1000000L));
        LOGGER.info("==> Loaded {} movies", (Object)loadedMoviesWithoutDuplicates.size());
    }

    void loadMovieSetsFromDatabase(MVMap<UUID, String> movieSetMap) {
        LOGGER.info("Loading movie sets from database...");
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        ObjectReader movieSetObjectReader = MovieModuleManager.getInstance().getMovieSetObjectReader();
        ArrayList toRemove = new ArrayList();
        HashSet loadedMovieSetsWithoutDuplicates = new HashSet();
        long start = System.nanoTime();
        new ArrayList(movieSetMap.keyList()).parallelStream().forEach(uuid -> {
            try {
                MovieSet movieSet = (MovieSet)movieSetObjectReader.readValue((String)movieSetMap.get(uuid));
                movieSet.setDbId((UUID)uuid);
                lock.writeLock().lock();
                loadedMovieSetsWithoutDuplicates.add(movieSet);
                lock.writeLock().unlock();
            }
            catch (Exception e) {
                LOGGER.debug("problem decoding movie set json string: {}", (Object)e.getMessage());
                LOGGER.info("Dropping corrupt movie set");
                lock.writeLock().lock();
                toRemove.add(uuid);
                lock.writeLock().unlock();
            }
        });
        long end = System.nanoTime();
        this.movieSetList.addAll(loadedMovieSetsWithoutDuplicates);
        for (UUID uuid2 : toRemove) {
            movieSetMap.remove((Object)uuid2);
        }
        LOGGER.debug("took {} ms", (Object)((end - start) / 1000000L));
        LOGGER.info("==> Loaded {} movie sets", (Object)loadedMovieSetsWithoutDuplicates.size());
    }

    void initDataAfterLoading() {
        this.checkAndCleanupMediaFiles();
        for (Movie movie : this.movieList) {
            movie.initializeAfterLoading();
        }
        this.readWriteLock.writeLock().lock();
        try {
            this.byDbId.clear();
            this.byPath.clear();
            for (Movie movie : this.movieList) {
                this.indexMovie(movie);
            }
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
        EventBus.publishEvent("movieList", Event.createUpdateEvent(instance));
        for (MovieSet movieSet : this.movieSetList) {
            movieSet.initializeAfterLoading();
        }
    }

    private boolean isCorrupt(Movie movie) {
        if (movie.getMediaFiles(MediaFileType.VIDEO).isEmpty()) {
            LOGGER.debug("Movie without MediaFiles - dropping");
            return true;
        }
        if (StringUtils.isBlank((CharSequence)movie.getPath())) {
            LOGGER.debug("Movie without path - dropping");
            return true;
        }
        if (StringUtils.isBlank((CharSequence)movie.getDataSource())) {
            LOGGER.debug("Movie without datasource - dropping");
            return true;
        }
        if (TmmOsUtils.hasInvalidCharactersForFilesystem(movie.getPath())) {
            LOGGER.debug("Movie with invalid characters for this OS - dropping");
            return true;
        }
        return false;
    }

    public void persistMovie(Movie movie) {
        if (this.findByDbId(movie.getDbId()).isEmpty()) {
            LOGGER.debug("not persisting movie - not in movielist");
            return;
        }
        if (this.isCorrupt(movie)) {
            LOGGER.warn("Cannot persist movie '{}' - dropping", (Object)movie.getTitle());
            this.removeMovies(Collections.singletonList(movie));
        } else {
            try {
                MovieModuleManager.getInstance().persistMovie(movie);
                EventBus.publishEvent(EventBus.TOPIC_MOVIES, Event.createSaveEvent(movie));
            }
            catch (Exception e) {
                LOGGER.error("Failed to persist movie '{}' - '{}'", (Object)movie.getTitle(), (Object)e.getMessage());
            }
        }
    }

    public void persistMovieSet(MovieSet movieSet) {
        try {
            MovieModuleManager.getInstance().persistMovieSet(movieSet);
            EventBus.publishEvent(EventBus.TOPIC_MOVIE_SETS, Event.createSaveEvent(movieSet));
        }
        catch (Exception e) {
            LOGGER.error("Failed to persist movie set '{}' - '{}'", (Object)movieSet.getTitle(), (Object)e.getMessage());
        }
    }

    public MovieSet lookupMovieSet(UUID uuid) {
        for (MovieSet movieSet : this.movieSetList) {
            if (!movieSet.getDbId().equals(uuid)) continue;
            return movieSet;
        }
        return null;
    }

    private void indexMovie(Movie movie) {
        Path np;
        List list;
        Path p;
        UUID id = movie.getDbId();
        if (id != null) {
            this.byDbId.put(id, movie);
        }
        if ((p = movie.getPathNIO()) != null && !(list = this.byPath.computeIfAbsent(np = this.normalizePath(p), k -> new CopyOnWriteArrayList())).contains(movie)) {
            list.add(movie);
        }
    }

    private void deindexMovie(Movie movie) {
        UUID id = movie.getDbId();
        if (id != null) {
            this.byDbId.remove(id);
        }
        this.byPath.values().forEach(list -> list.remove(movie));
        this.byPath.values().removeIf(List::isEmpty);
    }

    private Path normalizePath(Path p) {
        Path np = p.toAbsolutePath().normalize();
        if (SystemUtils.IS_OS_WINDOWS) {
            return Paths.get(np.toString().toLowerCase(Locale.ROOT), new String[0]);
        }
        return np;
    }

    public Optional<Movie> findByDbId(UUID id) {
        if (id == null) {
            return Optional.empty();
        }
        this.readWriteLock.readLock().lock();
        try {
            Optional<Movie> optional = Optional.ofNullable(this.byDbId.get(id));
            return optional;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Movie> findByPath(Path path) {
        if (path == null) {
            return Collections.emptyList();
        }
        this.readWriteLock.readLock().lock();
        try {
            List<Movie> list = this.byPath.get(this.normalizePath(path));
            List<Movie> list2 = list == null ? Collections.emptyList() : List.copyOf(list);
            return list2;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public Movie findFirstByPath(Path path) {
        List<Movie> movies = this.findByPath(path);
        if (movies.isEmpty()) {
            return null;
        }
        return movies.get(0);
    }

    public void reevaluateMMD() {
        if (ListUtils.isEmpty(this.movieList)) {
            return;
        }
        HashMap<String, List> moviePathMap = new HashMap<String, List>();
        for (Movie movie : this.movieList) {
            String path = movie.getPathNIO().toAbsolutePath().toString();
            List moviesForPath = moviePathMap.computeIfAbsent(path, k -> new ArrayList());
            moviesForPath.add(movie);
        }
        HashMap<String, List> subMoviePathMap = new HashMap<String, List>();
        for (Movie movie : this.movieList) {
            Path datasource = Paths.get(movie.getDataSource(), new String[0]);
            Path path = movie.getPathNIO().toAbsolutePath();
            do {
                List moviesForPath = subMoviePathMap.computeIfAbsent(path.toString(), k -> new ArrayList());
                moviesForPath.add(movie);
            } while (!path.equals(datasource) && (path = path.getParent()) != null);
        }
        LOGGER.debug("re-evaluating MMD for {} movies...", (Object)this.movieList.size());
        for (Movie movie : this.movieList) {
            boolean old = movie.isMultiMovieDir();
            if (!movie.getPathNIO().equals(Paths.get(movie.getDataSource(), new String[0]))) {
                List subMovies = (List)subMoviePathMap.get(movie.getPathNIO().toAbsolutePath().toString());
                if (subMovies.size() > 1) {
                    movie.setMultiMovieDir(true);
                } else {
                    List samePath = (List)moviePathMap.get(movie.getPathNIO().toAbsolutePath().toString());
                    if (samePath.size() > 1) {
                        movie.setMultiMovieDir(true);
                    } else if (movie.getPathNIO().getFileName().toString().matches("(?i)^(\\w|\\d{4}|\\d{4}s|\\d{4}\\-\\d{4})$") || MediaGenres.containsGenre(movie.getPathNIO().getFileName().toString())) {
                        movie.setMultiMovieDir(true);
                    } else {
                        movie.setMultiMovieDir(false);
                    }
                }
            } else {
                movie.setMultiMovieDir(true);
            }
            if (old == movie.isMultiMovieDir()) continue;
            LOGGER.debug("Movie '{}' changed MMD {} -> {}", new Object[]{movie.getTitle(), old, movie.isMultiMovieDir()});
            movie.saveToDb();
        }
    }

    public List<MediaSearchResult> searchMovie(String searchTerm, int year, Map<String, Object> ids, MediaScraper metadataScraper) throws ScrapeException {
        return this.searchMovie(searchTerm, year, ids, metadataScraper, MovieModuleManager.getInstance().getSettings().getScraperLanguage());
    }

    public List<MediaSearchResult> searchMovie(String searchTerm, int year, Map<String, Object> ids, MediaScraper mediaScraper, MediaLanguages language) throws ScrapeException {
        String newSearchTerm;
        String yearInTitle;
        if (mediaScraper == null || !mediaScraper.isEnabled()) {
            return Collections.emptyList();
        }
        TreeSet<MediaSearchResult> sr = new TreeSet<MediaSearchResult>();
        IMovieMetadataProvider provider = (IMovieMetadataProvider)mediaScraper.getMediaProvider();
        Pattern tmdbPattern = Pattern.compile("https://www.themoviedb.org/movie/(.*?)-.*");
        MovieSearchAndScrapeOptions options = new MovieSearchAndScrapeOptions();
        options.setLanguage(language);
        options.setCertificationCountry(MovieModuleManager.getInstance().getSettings().getCertificationCountry());
        options.setReleaseDateCountry(MovieModuleManager.getInstance().getSettings().getReleaseDateCountry());
        options.setMetadataScraper(mediaScraper);
        if (ids != null) {
            options.setIds(ids);
        }
        if (!searchTerm.isEmpty()) {
            String query = searchTerm.toLowerCase(Locale.ROOT);
            if (MediaIdUtil.isValidImdbId(query)) {
                options.setImdbId(query);
            } else if (query.startsWith("imdb:")) {
                String imdbId = query.replace("imdb:", "");
                if (MediaIdUtil.isValidImdbId(imdbId)) {
                    options.setImdbId(imdbId);
                }
            } else if (query.startsWith("https://www.imdb.com/title/")) {
                String imdbId = query.split("/")[4];
                if (MediaIdUtil.isValidImdbId(imdbId)) {
                    options.setImdbId(imdbId);
                }
            } else if (query.startsWith("tmdb:")) {
                try {
                    int tmdbId = Integer.parseInt(query.replace("tmdb:", ""));
                    if (tmdbId > 0) {
                        options.setTmdbId(tmdbId);
                    }
                }
                catch (Exception tmdbId) {}
            } else if (tmdbPattern.matcher(query).matches()) {
                try {
                    int tmdbId = Integer.parseInt(tmdbPattern.matcher(query).replaceAll("$1"));
                    if (tmdbId > 0) {
                        options.setTmdbId(tmdbId);
                    }
                }
                catch (Exception tmdbId) {
                    // empty catch block
                }
            }
            options.setSearchQuery(searchTerm);
        }
        if (year > 0) {
            options.setSearchYear(year);
        }
        if (!(yearInTitle = StrgUtils.substr(searchTerm, "(\\(\\d{4}\\))")).isEmpty() && !(newSearchTerm = searchTerm.replace(yearInTitle, "").strip()).isBlank()) {
            options.setSearchQuery(newSearchTerm);
            yearInTitle = yearInTitle.substring(1, 5);
            year = MetadataUtil.parseInt(yearInTitle, 0);
            options.setSearchYear(year);
        }
        LOGGER.info("Search '{}' for movie title '{}'", (Object)provider.getProviderInfo().getId(), (Object)searchTerm);
        LOGGER.debug("=====================================================");
        LOGGER.debug("Searching with scraper: {}", (Object)provider.getProviderInfo().getId());
        LOGGER.debug("options: {}", (Object)options);
        LOGGER.debug("=====================================================");
        sr.addAll(provider.search(options).stream().filter(Objects::nonNull).filter(mediaSearchResult -> !mediaSearchResult.getIds().isEmpty() && StringUtils.isNotBlank((CharSequence)mediaSearchResult.getTitle())).toList());
        if (sr.isEmpty() && options.getSearchQuery().matches("^\\d{4}.*")) {
            LOGGER.info("Nothing found - trying to search without year in title");
            MovieSearchAndScrapeOptions o = new MovieSearchAndScrapeOptions(options);
            o.setSearchQuery(options.getSearchQuery().substring(4));
            LOGGER.debug("=====================================================");
            LOGGER.debug("Searching again without year in title: {}", (Object)provider.getProviderInfo().getId());
            LOGGER.debug("options: {}", (Object)o);
            LOGGER.debug("=====================================================");
            sr.addAll(provider.search(o).stream().filter(Objects::nonNull).filter(mediaSearchResult -> !mediaSearchResult.getIds().isEmpty() && StringUtils.isNotBlank((CharSequence)mediaSearchResult.getTitle())).toList());
        }
        if (sr.isEmpty() && MovieModuleManager.getInstance().getSettings().isScraperFallback()) {
            LOGGER.info("Nothing found - trying to search with other scrapers");
            for (MediaScraper ms : this.getAvailableMediaScrapers()) {
                if (provider.getProviderInfo().equals(ms.getMediaProvider().getProviderInfo()) || ms.getMediaProvider().getProviderInfo().getName().startsWith("Kodi") || !ms.getMediaProvider().isActive()) continue;
                LOGGER.debug("no result yet - trying alternate scraper: {}", (Object)ms.getName());
                try {
                    LOGGER.debug("=====================================================");
                    LOGGER.debug("Searching with alternate scraper: '{}', '{}'", (Object)ms.getMediaProvider().getId(), (Object)provider.getProviderInfo().getVersion());
                    LOGGER.debug("options: {}", (Object)options);
                    LOGGER.debug("=====================================================");
                    sr.addAll(((IMovieMetadataProvider)ms.getMediaProvider()).search(options).stream().filter(Objects::nonNull).filter(mediaSearchResult -> !mediaSearchResult.getIds().isEmpty() && StringUtils.isNotBlank((CharSequence)mediaSearchResult.getTitle())).toList());
                }
                catch (ScrapeException e) {
                    LOGGER.error("Could not search for movie '{}' with '{}' - '{}'", new Object[]{searchTerm, ms.getId(), e.getMessage()});
                }
                if (sr.isEmpty()) continue;
                break;
            }
        }
        LOGGER.info("Found '{}' results for movie title '{}'", (Object)sr.size(), (Object)searchTerm);
        return new ArrayList<MediaSearchResult>(sr);
    }

    public List<MediaScraper> getAvailableMediaScrapers() {
        List<MediaScraper> availableScrapers = MediaScraper.getMediaScrapers(ScraperType.MOVIE);
        availableScrapers.sort(new MovieMediaScraperComparator());
        return availableScrapers;
    }

    public MediaScraper getDefaultMediaScraper() {
        MediaScraper scraper = MediaScraper.getMediaScraperById(MovieModuleManager.getInstance().getSettings().getMovieScraper(), ScraperType.MOVIE);
        if (scraper == null || !scraper.isEnabled()) {
            scraper = MediaScraper.getMediaScraperById("tmdb", ScraperType.MOVIE);
        }
        return scraper;
    }

    public MediaScraper getMediaScraperById(String providerId) {
        return MediaScraper.getMediaScraperById(providerId, ScraperType.MOVIE);
    }

    public List<MediaScraper> getAvailableArtworkScrapers() {
        List<MediaScraper> availableScrapers = MediaScraper.getMediaScrapers(ScraperType.MOVIE_ARTWORK);
        availableScrapers.sort(new MovieMediaScraperComparator());
        return availableScrapers;
    }

    public List<MediaScraper> getArtworkScrapers(List<String> providerIds) {
        ArrayList<MediaScraper> artworkScrapers = new ArrayList<MediaScraper>();
        for (String providerId : providerIds) {
            MediaScraper artworkScraper;
            if (StringUtils.isBlank((CharSequence)providerId) || (artworkScraper = MediaScraper.getMediaScraperById(providerId, ScraperType.MOVIE_ARTWORK)) == null) continue;
            artworkScrapers.add(artworkScraper);
        }
        return artworkScrapers;
    }

    public List<MediaScraper> getDefaultArtworkScrapers() {
        List<MediaScraper> defaultScrapers = this.getArtworkScrapers(MovieModuleManager.getInstance().getSettings().getArtworkScrapers());
        return defaultScrapers.stream().filter(MediaScraper::isActive).collect(Collectors.toList());
    }

    public List<MediaScraper> getAvailableTrailerScrapers() {
        List<MediaScraper> availableScrapers = MediaScraper.getMediaScrapers(ScraperType.MOVIE_TRAILER);
        availableScrapers.sort(new MovieMediaScraperComparator());
        return availableScrapers;
    }

    public List<MediaScraper> getDefaultTrailerScrapers() {
        List<MediaScraper> defaultScrapers = this.getTrailerScrapers(MovieModuleManager.getInstance().getSettings().getTrailerScrapers());
        return defaultScrapers.stream().filter(MediaScraper::isActive).collect(Collectors.toList());
    }

    public List<MediaScraper> getTrailerScrapers(List<String> providerIds) {
        ArrayList<MediaScraper> trailerScrapers = new ArrayList<MediaScraper>();
        for (String providerId : providerIds) {
            MediaScraper trailerScraper;
            if (StringUtils.isBlank((CharSequence)providerId) || (trailerScraper = MediaScraper.getMediaScraperById(providerId, ScraperType.MOVIE_TRAILER)) == null) continue;
            trailerScrapers.add(trailerScraper);
        }
        return trailerScrapers;
    }

    public List<MediaScraper> getAvailableSubtitleScrapers() {
        List<MediaScraper> availableScrapers = MediaScraper.getMediaScrapers(ScraperType.MOVIE_SUBTITLE);
        availableScrapers.sort(new MovieMediaScraperComparator());
        return availableScrapers;
    }

    public List<MediaScraper> getDefaultSubtitleScrapers() {
        List<MediaScraper> defaultScrapers = this.getSubtitleScrapers(MovieModuleManager.getInstance().getSettings().getSubtitleScrapers());
        return defaultScrapers.stream().filter(MediaScraper::isActive).collect(Collectors.toList());
    }

    public List<MediaScraper> getSubtitleScrapers(List<String> providerIds) {
        ArrayList<MediaScraper> subtitleScrapers = new ArrayList<MediaScraper>();
        for (String providerId : providerIds) {
            MediaScraper subtitleScraper;
            if (StringUtils.isBlank((CharSequence)providerId) || (subtitleScraper = MediaScraper.getMediaScraperById(providerId, ScraperType.MOVIE_SUBTITLE)) == null) continue;
            subtitleScrapers.add(subtitleScraper);
        }
        return subtitleScrapers;
    }

    public int getMovieCount() {
        return this.movieList.size();
    }

    public int getMovieSetCount() {
        return this.movieSetList.size();
    }

    public int getMovieInMovieSetCount() {
        int count = 0;
        for (MovieSet movieSet : this.movieSetList) {
            count += movieSet.getMovies().size();
        }
        return count;
    }

    private void updateYear(List<Movie> movies) {
        TreeSet years = new TreeSet();
        movies.forEach(movie -> years.add(movie.getYear()));
        if (!new HashSet<Integer>(this.yearsInMovies).equals(years)) {
            this.yearsInMovies.clear();
            this.yearsInMovies.addAll(years);
            EventBus.publishEvent(EventBus.TOPIC_MOVIES_UI, Event.createUpdateEvent(instance));
        }
    }

    private void updateDecades(List<Movie> movies) {
        HashSet decades = new HashSet();
        movies.forEach(movie -> {
            String decadeShort = movie.getDecadeShort();
            if (StringUtils.isNotBlank((CharSequence)decadeShort)) {
                decades.add(decadeShort);
            }
        });
        if (!new HashSet<String>(this.decadesInMovies).equals(decades)) {
            this.decadesInMovies.clear();
            this.decadesInMovies.addAll(decades);
            EventBus.publishEvent(EventBus.TOPIC_MOVIES_UI, Event.createUpdateEvent(instance));
        }
    }

    private void updateGenres(List<Movie> movies) {
        HashSet genres = new HashSet();
        movies.forEach(movie -> genres.addAll(movie.getGenres()));
        if (!new HashSet<MediaGenres>(this.genresInMovies).equals(genres)) {
            this.genresInMovies.clear();
            this.genresInMovies.addAll(genres);
            EventBus.publishEvent(EventBus.TOPIC_MOVIES_UI, Event.createUpdateEvent(instance));
        }
    }

    private void updateTags(List<Movie> movies) {
        TreeSet<String> tags = new TreeSet<String>();
        movies.forEach(movie -> tags.addAll(movie.getTags()));
        Utils.removeDuplicateStringFromCollectionIgnoreCase(tags);
        if (!new HashSet<String>(this.tagsInMovies).equals(tags)) {
            this.tagsInMovies.clear();
            this.tagsInMovies.addAll(tags);
            EventBus.publishEvent(EventBus.TOPIC_MOVIES_UI, Event.createUpdateEvent(instance));
        }
    }

    private void updateMediaInformationLists(List<Movie> movies) {
        HashSet<String> videoCodecs = new HashSet<String>();
        HashSet<Double> frameRates = new HashSet<Double>();
        HashMap<String, String> videoContainers = new HashMap<String, String>();
        HashSet<String> audioCodecs = new HashSet<String>();
        HashSet<Integer> audioChannels = new HashSet<Integer>();
        HashSet<Integer> audioStreamCount = new HashSet<Integer>();
        HashSet<Integer> subtitleStreamCount = new HashSet<Integer>();
        HashSet<String> audioLanguages = new HashSet<String>();
        HashSet<String> subtitleLanguages = new HashSet<String>();
        HashSet<String> hdrFormat = new HashSet<String>();
        HashSet<String> audioTitles = new HashSet<String>();
        HashSet<String> subtitleFormats = new HashSet<String>();
        for (Movie movie : movies) {
            MediaFile mf2;
            boolean firstVideoFile = true;
            for (MediaFile mf2 : movie.getMediaFiles(MediaFileType.VIDEO, MediaFileType.SUBTITLE)) {
                if (mf2.getType() == MediaFileType.VIDEO && !firstVideoFile) continue;
                if (!mf2.getSubtitleLanguages().isEmpty()) {
                    subtitleLanguages.addAll(mf2.getSubtitleLanguages());
                }
                for (MediaFileSubtitle subtitle : mf2.getSubtitles()) {
                    if (subtitle.getCodec().isEmpty()) continue;
                    subtitleFormats.add(subtitle.getCodec());
                }
                if (mf2.getType() != MediaFileType.VIDEO) continue;
                firstVideoFile = false;
            }
            subtitleStreamCount.add(movie.getMediaInfoSubtitleStreamCount());
            firstVideoFile = true;
            for (MediaFile mf2 : movie.getMediaFiles(MediaFileType.VIDEO, MediaFileType.AUDIO)) {
                if (mf2.getType() == MediaFileType.VIDEO && !firstVideoFile) continue;
                for (MediaFileAudioStream audio : mf2.getAudioStreams()) {
                    if (StringUtils.isNotBlank((CharSequence)audio.getCodec())) {
                        audioCodecs.add(audio.getCodec());
                    }
                    audioChannels.add(audio.getAudioChannels());
                }
                if (!mf2.getAudioLanguagesList().isEmpty()) {
                    audioLanguages.addAll(mf2.getAudioLanguagesList());
                }
                if (!mf2.getAudioTitleList().isEmpty()) {
                    audioTitles.addAll(mf2.getAudioTitleList());
                }
                if (mf2.getType() != MediaFileType.VIDEO) continue;
                firstVideoFile = false;
            }
            audioStreamCount.add(movie.getMediaInfoAudioStreamCount());
            Iterator<MediaFile> iterator = movie.getMediaFiles(MediaFileType.VIDEO).iterator();
            if (!iterator.hasNext()) continue;
            mf2 = iterator.next();
            if (StringUtils.isNotBlank((CharSequence)mf2.getVideoCodec())) {
                videoCodecs.add(mf2.getVideoCodec());
            }
            if (mf2.getFrameRate() > 0.0) {
                frameRates.add(mf2.getFrameRate());
            }
            if (StringUtils.isNotBlank((CharSequence)mf2.getContainerFormat())) {
                videoContainers.putIfAbsent(mf2.getContainerFormat().toLowerCase(Locale.ROOT), mf2.getContainerFormat());
            }
            if (mf2.getHdrFormat().isEmpty()) continue;
            hdrFormat.addAll(Arrays.asList(mf2.getHdrFormat().split(", ")));
        }
        if (ListUtils.addToCopyOnWriteArrayListIfAbsent(this.videoCodecsInMovies, videoCodecs)) {
            EventBus.publishEvent(EventBus.TOPIC_MOVIES_UI, Event.createUpdateEvent(instance));
        }
        if (ListUtils.addToCopyOnWriteArrayListIfAbsent(this.frameRatesInMovies, frameRates)) {
            EventBus.publishEvent(EventBus.TOPIC_MOVIES_UI, Event.createUpdateEvent(instance));
        }
        if (ListUtils.addToCopyOnWriteArrayListIfAbsent(this.videoContainersInMovies, videoContainers.values())) {
            EventBus.publishEvent(EventBus.TOPIC_MOVIES_UI, Event.createUpdateEvent(instance));
        }
        if (ListUtils.addToCopyOnWriteArrayListIfAbsent(this.audioCodecsInMovies, audioCodecs)) {
            EventBus.publishEvent(EventBus.TOPIC_MOVIES_UI, Event.createUpdateEvent(instance));
        }
        if (ListUtils.addToCopyOnWriteArrayListIfAbsent(this.audioChannelsInMovies, audioChannels)) {
            EventBus.publishEvent(EventBus.TOPIC_MOVIES_UI, Event.createUpdateEvent(instance));
        }
        if (ListUtils.addToCopyOnWriteArrayListIfAbsent(this.audioStreamsInMovies, audioStreamCount)) {
            EventBus.publishEvent(EventBus.TOPIC_MOVIES_UI, Event.createUpdateEvent(instance));
        }
        if (ListUtils.addToCopyOnWriteArrayListIfAbsent(this.audioLanguagesInMovies, audioLanguages)) {
            EventBus.publishEvent(EventBus.TOPIC_MOVIES_UI, Event.createUpdateEvent(instance));
        }
        if (ListUtils.addToCopyOnWriteArrayListIfAbsent(this.subtitlesInMovies, subtitleStreamCount)) {
            EventBus.publishEvent(EventBus.TOPIC_MOVIES_UI, Event.createUpdateEvent(instance));
        }
        if (ListUtils.addToCopyOnWriteArrayListIfAbsent(this.subtitleLanguagesInMovies, subtitleLanguages)) {
            EventBus.publishEvent(EventBus.TOPIC_MOVIES_UI, Event.createUpdateEvent(instance));
        }
        if (ListUtils.addToCopyOnWriteArrayListIfAbsent(this.subtitleFormatsInMovies, subtitleFormats)) {
            EventBus.publishEvent(EventBus.TOPIC_MOVIES_UI, Event.createUpdateEvent(instance));
        }
        if (ListUtils.addToCopyOnWriteArrayListIfAbsent(this.hdrFormatInMovies, hdrFormat)) {
            EventBus.publishEvent(EventBus.TOPIC_MOVIES_UI, Event.createUpdateEvent(instance));
        }
        if (ListUtils.addToCopyOnWriteArrayListIfAbsent(this.audioTitlesInMovies, audioTitles)) {
            EventBus.publishEvent(EventBus.TOPIC_MOVIES_UI, Event.createUpdateEvent(instance));
        }
    }

    private void updateCertifications(List<Movie> movies) {
        TreeSet certifications = new TreeSet();
        movies.forEach(movie -> certifications.add(movie.getCertification()));
        if (certifications.hashCode() != this.certificationsInMovies.hashCode()) {
            this.certificationsInMovies.clear();
            this.certificationsInMovies.addAll(certifications);
            EventBus.publishEvent(EventBus.TOPIC_MOVIES_UI, Event.createUpdateEvent(this.movieList));
        }
    }

    public List<Integer> getYearsInMovies() {
        return Collections.unmodifiableList(this.yearsInMovies);
    }

    public List<String> getDecadesInMovies() {
        return Collections.unmodifiableList(this.decadesInMovies);
    }

    public List<String> getTagsInMovies() {
        return Collections.unmodifiableList(this.tagsInMovies);
    }

    public List<String> getVideoCodecsInMovies() {
        return Collections.unmodifiableList(this.videoCodecsInMovies);
    }

    public List<String> getVideoContainersInMovies() {
        return Collections.unmodifiableList(this.videoContainersInMovies);
    }

    public List<String> getAudioCodecsInMovies() {
        return Collections.unmodifiableList(this.audioCodecsInMovies);
    }

    public List<Integer> getAudioChannelsInMovies() {
        return Collections.unmodifiableList(this.audioChannelsInMovies);
    }

    public List<MediaCertification> getCertificationsInMovies() {
        return Collections.unmodifiableList(this.certificationsInMovies);
    }

    public List<Double> getFrameRatesInMovies() {
        return Collections.unmodifiableList(this.frameRatesInMovies);
    }

    public List<Integer> getAudioStreamsInMovies() {
        return Collections.unmodifiableList(this.audioStreamsInMovies);
    }

    public List<Integer> getSubtitlesInMovies() {
        return Collections.unmodifiableList(this.subtitlesInMovies);
    }

    public List<String> getAudioLanguagesInMovies() {
        return Collections.unmodifiableList(this.audioLanguagesInMovies);
    }

    public List<String> getSubtitleLanguagesInMovies() {
        return Collections.unmodifiableList(this.subtitleLanguagesInMovies);
    }

    public List<String> getSubtitleFormatsInMovies() {
        return Collections.unmodifiableList(this.subtitleFormatsInMovies);
    }

    public List<String> getHDRFormatInMovies() {
        return Collections.unmodifiableList(this.hdrFormatInMovies);
    }

    public List<String> getAudioTitlesInMovies() {
        return Collections.unmodifiableList(this.audioTitlesInMovies);
    }

    public void searchDuplicates() {
        HashMap<Object, Movie> duplicates = new HashMap<Object, Movie>();
        for (Movie movie : this.movieList) {
            movie.clearDuplicate();
            Map<String, Object> ids = movie.getIds();
            for (Map.Entry<String, Object> entry : ids.entrySet()) {
                if ("tmdbSet".equalsIgnoreCase(entry.getKey()) || entry.getKey().toLowerCase(Locale.US).startsWith("tmdbcol") || entry.getValue() == null) continue;
                String id = entry.getKey() + entry.getValue();
                if (duplicates.containsKey(id)) {
                    movie.setDuplicate();
                    Movie movie2 = (Movie)duplicates.get(id);
                    movie2.setDuplicate();
                    LOGGER.info("Duplicate check: movies have the same ID ({}): {} <=> {}", new Object[]{id, movie.getTitle(), movie2.getTitle()});
                    continue;
                }
                duplicates.put(id, movie);
            }
            String crc = movie.getCRC32();
            if (crc.isEmpty()) continue;
            if (duplicates.containsKey(crc)) {
                movie.setDuplicate();
                Movie movie2 = (Movie)duplicates.get(crc);
                movie2.setDuplicate();
                LOGGER.info("Duplicate check: files have the same hash ({}): {} <=> {}", new Object[]{crc, movie.getMainFile().getFileAsPath().toAbsolutePath(), movie2.getMainFile().getFileAsPath().toAbsolutePath()});
                continue;
            }
            duplicates.put(crc, movie);
        }
        duplicates.clear();
    }

    public List<MovieSet> getMovieSetList() {
        return Collections.unmodifiableList(this.movieSetList);
    }

    public List<MovieSet> getSortedMovieSetList() {
        ArrayList<MovieSet> sortedMovieSets = new ArrayList<MovieSet>(this.getMovieSetList());
        sortedMovieSets.sort(this.movieSetComparator);
        return sortedMovieSets;
    }

    public void addMovieSet(MovieSet movieSet) {
        int oldValue = this.movieSetList.size();
        this.readWriteLock.writeLock().lock();
        this.movieSetList.add(movieSet);
        this.readWriteLock.writeLock().unlock();
        movieSet.addPropertyChangeListener(this.movieSetListener);
        this.firePropertyChange("addedMovieSet", null, movieSet);
        this.firePropertyChange("movieSetCount", oldValue, this.movieSetList.size());
        this.firePropertyChange("movieInMovieSetCount", oldValue, this.getMovieInMovieSetCount());
    }

    public void removeMovieSet(MovieSet movieSet) {
        int oldValue = this.movieSetList.size();
        movieSet.removePropertyChangeListener(this.movieSetListener);
        try {
            for (MediaFile mf : movieSet.getMediaFiles(MediaFileType.NFO)) {
                Utils.deleteFileSafely(mf.getFileAsPath());
            }
            MovieSetArtworkHelper.removeMovieSetArtwork(movieSet);
            if (StringUtils.isNotBlank((CharSequence)MovieModuleManager.getInstance().getSettings().getMovieSetDataFolder())) {
                String movieSetName = MovieSetArtworkHelper.getMovieSetTitleForStorage(movieSet);
                Utils.deleteEmptyDirectoryRecursive(Paths.get(MovieModuleManager.getInstance().getSettings().getMovieSetDataFolder(), movieSetName));
            }
            movieSet.removeAllMovies();
            this.readWriteLock.writeLock().lock();
            this.movieSetList.remove(movieSet);
            this.readWriteLock.writeLock().unlock();
            MovieModuleManager.getInstance().removeMovieSetFromDb(movieSet);
            EventBus.publishEvent(EventBus.TOPIC_MOVIE_SETS, Event.createRemoveEvent(movieSet));
        }
        catch (Exception e) {
            LOGGER.error("Error removing movie set '{}' from DB - '{}'", (Object)movieSet.getTitle(), (Object)e.getMessage());
        }
        this.firePropertyChange("removedMovieSet", null, movieSet);
        this.firePropertyChange("movieSetCount", oldValue, this.movieSetList.size());
        this.firePropertyChange("movieInMovieSetCount", oldValue, this.getMovieInMovieSetCount());
    }

    public MovieSet findMovieSet(String title, int tmdbId) {
        if (tmdbId > 0) {
            for (MovieSet movieSet : this.movieSetList) {
                if (movieSet.getTmdbId() != tmdbId) continue;
                return movieSet;
            }
        }
        if (StringUtils.isNotBlank((CharSequence)title)) {
            for (MovieSet movieSet : this.movieSetList) {
                if (!movieSet.getTitle().equals(title)) continue;
                return movieSet;
            }
        }
        return null;
    }

    public synchronized MovieSet getMovieSet(String title, int tmdbId) {
        MovieSet movieSet = this.findMovieSet(title, tmdbId);
        if (movieSet == null && StringUtils.isNotBlank((CharSequence)title)) {
            movieSet = new MovieSet(title);
            if (tmdbId > 0) {
                movieSet.setTmdbId(tmdbId);
            }
            movieSet.saveToDb();
            this.addMovieSet(movieSet);
        }
        return movieSet;
    }

    private void checkAndCleanupMediaFiles() {
        ArrayList<Movie> moviesToRemove = new ArrayList<Movie>();
        for (Movie movie : this.movieList) {
            List<MediaFile> mfs = movie.getMediaFiles(MediaFileType.VIDEO);
            if (!mfs.isEmpty()) continue;
            moviesToRemove.add(movie);
        }
        if (!moviesToRemove.isEmpty()) {
            LOGGER.debug("movies without VIDEOs detected");
            for (Movie movie : moviesToRemove) {
                LOGGER.debug("  -> '{}' / '{}'", (Object)movie.getTitle(), (Object)movie.getPathNIO());
            }
            this.removeMovies(moviesToRemove);
            Thread thread = new Thread(() -> {
                try {
                    Thread.sleep(15000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Message message = new Message(Message.MessageLevel.SEVERE, "tmm.movies", "message.database.corrupteddata");
                MessageManager.getInstance().pushMessage(message);
            });
            thread.start();
        }
    }

    public void invalidateTitleSortable() {
        this.movieList.parallelStream().forEach(Movie::clearTitleSortable);
    }

    public void addOfflineMovie(String title, String datasource, MediaSource mediaSource) {
        if (!MovieModuleManager.getInstance().getSettings().getMovieDataSource().contains(datasource)) {
            return;
        }
        Movie movie = new Movie();
        movie.setTitle(title);
        String cleanedTitle = MovieRenamer.createDestinationForFoldername(MovieModuleManager.getInstance().getSettings().getRenamerPathname(), movie);
        int i = 1;
        Path stubFolder = Paths.get(datasource, cleanedTitle);
        while (Files.exists(stubFolder, new LinkOption[0])) {
            stubFolder = Paths.get(datasource, cleanedTitle + "(" + i++ + ")");
        }
        cleanedTitle = MovieRenamer.createDestinationForFilename(MovieModuleManager.getInstance().getSettings().getRenamerPathname(), movie);
        Path stubFile = stubFolder.resolve(cleanedTitle + ".disc");
        try {
            Files.createDirectory(stubFolder, new FileAttribute[0]);
            Files.createFile(stubFile, new FileAttribute[0]);
        }
        catch (IOException e) {
            LOGGER.error("Could not create stub file '{}' - '{}'", (Object)stubFile, (Object)e.getMessage());
            return;
        }
        movie.setPath(stubFolder.toAbsolutePath().toString());
        movie.setDataSource(datasource);
        movie.setMediaSource(mediaSource);
        movie.setDateAdded(new Date());
        MediaFile mf = new MediaFile(stubFile);
        mf.gatherMediaInformation();
        movie.addToMediaFiles(mf);
        movie.setOffline(true);
        movie.setNewlyAdded(true);
        try {
            this.addMovie(movie);
            movie.saveToDb();
        }
        catch (Exception e) {
            try {
                Utils.deleteDirectoryRecursive(stubFolder);
            }
            catch (Exception e1) {
                LOGGER.debug("could not delete stub folder - {}", (Object)e1.getMessage());
            }
            throw e;
        }
    }

    public List<String> getTvShowTitles() {
        ArrayList<String> tvShowTitles = new ArrayList<String>();
        TvShowModuleManager.getInstance().getTvShowList().getTvShows().forEach(tvShow -> tvShowTitles.add(tvShow.getTitle()));
        tvShowTitles.sort(Comparator.naturalOrder());
        return tvShowTitles;
    }

    public List<MovieScraperMetadataConfig> detectMissingMetadata(Movie movie) {
        return this.detectMissingFields(movie, MovieModuleManager.getInstance().getSettings().getMovieCheckMetadata());
    }

    public List<MovieScraperMetadataConfig> detectMissingArtwork(Movie movie) {
        return this.detectMissingFields(movie, MovieModuleManager.getInstance().getSettings().getMovieCheckArtwork());
    }

    public List<MovieScraperMetadataConfig> detectMissingFields(Movie movie, List<MovieScraperMetadataConfig> toCheck) {
        ArrayList<MovieScraperMetadataConfig> missingMetadata = new ArrayList<MovieScraperMetadataConfig>();
        for (MovieScraperMetadataConfig metadataConfig : toCheck) {
            Object value = movie.getValueForMetadata(metadataConfig);
            if (value == null) {
                missingMetadata.add(metadataConfig);
                continue;
            }
            if (value instanceof String && StringUtils.isBlank((CharSequence)((String)value))) {
                missingMetadata.add(metadataConfig);
                continue;
            }
            if (value instanceof Number && ((Number)value).intValue() <= 0) {
                missingMetadata.add(metadataConfig);
                continue;
            }
            if (value instanceof Collection && ((Collection)value).isEmpty()) {
                missingMetadata.add(metadataConfig);
                continue;
            }
            if (value instanceof Map && ((Map)value).isEmpty()) {
                missingMetadata.add(metadataConfig);
                continue;
            }
            if (value != MediaCertification.UNKNOWN) continue;
            missingMetadata.add(metadataConfig);
        }
        return missingMetadata;
    }

    public List<MovieSetScraperMetadataConfig> detectMissingMetadata(MovieSet movieSet) {
        return this.detectMissingFields(movieSet, MovieModuleManager.getInstance().getSettings().getMovieSetCheckMetadata());
    }

    public List<MovieSetScraperMetadataConfig> detectMissingArtwork(MovieSet movieSet) {
        return this.detectMissingFields(movieSet, MovieModuleManager.getInstance().getSettings().getMovieSetCheckArtwork());
    }

    public List<MovieSetScraperMetadataConfig> detectMissingFields(MovieSet movieSet, List<MovieSetScraperMetadataConfig> toCheck) {
        ArrayList<MovieSetScraperMetadataConfig> missingMetadata = new ArrayList<MovieSetScraperMetadataConfig>();
        for (MovieSetScraperMetadataConfig metadataConfig : toCheck) {
            Object value = movieSet.getValueForMetadata(metadataConfig);
            if (value == null) {
                missingMetadata.add(metadataConfig);
                continue;
            }
            if (value instanceof String && StringUtils.isBlank((CharSequence)((String)value))) {
                missingMetadata.add(metadataConfig);
                continue;
            }
            if (value instanceof Number && ((Number)value).intValue() <= 0) {
                missingMetadata.add(metadataConfig);
                continue;
            }
            if (value instanceof Collection && ((Collection)value).isEmpty()) {
                missingMetadata.add(metadataConfig);
                continue;
            }
            if (value instanceof Map && ((Map)value).isEmpty()) {
                missingMetadata.add(metadataConfig);
                continue;
            }
            if (value != MediaCertification.UNKNOWN) continue;
            missingMetadata.add(metadataConfig);
        }
        return missingMetadata;
    }

    private static class MovieSetComparator
    implements Comparator<MovieSet> {
        private MovieSetComparator() {
        }

        @Override
        public int compare(MovieSet o1, MovieSet o2) {
            if (o1 == null || o2 == null || o1.getTitleSortable() == null || o2.getTitleSortable() == null) {
                return 0;
            }
            return o1.getTitleSortable().compareToIgnoreCase(o2.getTitleSortable());
        }
    }

    private static class MovieComparator
    implements Comparator<Movie> {
        private MovieComparator() {
        }

        @Override
        public int compare(Movie o1, Movie o2) {
            if (o1 == null || o2 == null || o1.getTitleSortable() == null || o2.getTitleSortable() == null) {
                return 0;
            }
            return o1.getTitleSortable().compareToIgnoreCase(o2.getTitleSortable());
        }
    }

    private static class MovieMediaScraperComparator
    implements Comparator<MediaScraper> {
        private MovieMediaScraperComparator() {
        }

        @Override
        public int compare(MediaScraper o1, MediaScraper o2) {
            if (o1.getPriority() == o2.getPriority()) {
                return o1.getId().compareTo(o2.getId());
            }
            return Integer.compare(o2.getPriority(), o1.getPriority());
        }
    }
}

