/*
 * Decompiled with CFR 0.152.
 */
package com.github.kiulian.downloader.model.search;

import com.github.kiulian.downloader.jackson.JSONObject;
import com.github.kiulian.downloader.model.Utils;
import com.github.kiulian.downloader.model.search.AbstractSearchResultList;
import com.github.kiulian.downloader.model.search.SearchResultItemType;

public class SearchResultChannelDetails
extends AbstractSearchResultList {
    private final String channelId;
    private final String videoCountText;
    private final String subscriberCountText;
    private final String description;

    public SearchResultChannelDetails(JSONObject jSONObject) {
        super(jSONObject);
        this.channelId = jSONObject.getString("channelId");
        this.videoCountText = Utils.parseRuns(jSONObject.getJSONObject("videoCountText"));
        this.subscriberCountText = jSONObject.containsKey("subscriberCountText") ? jSONObject.getJSONObject("subscriberCountText").getString("simpleText") : null;
        this.description = Utils.parseRuns(jSONObject.getJSONObject("descriptionSnippet"));
        this.thumbnails = Utils.parseThumbnails(jSONObject.getJSONObject("thumbnail"));
    }

    @Override
    public SearchResultItemType type() {
        return SearchResultItemType.CHANNEL;
    }

    @Override
    public SearchResultChannelDetails asChannel() {
        return this;
    }

    public String channelId() {
        return this.channelId;
    }

    public String videoCountText() {
        return this.videoCountText;
    }

    public String subscriberCountText() {
        return this.subscriberCountText;
    }

    public String description() {
        return this.description;
    }
}

