/*
 * Decompiled with CFR 0.152.
 */
package org.mp4parser.muxer.tracks.h264;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.mp4parser.muxer.tracks.h264.parsing.model.SeqParameterSet;
import org.mp4parser.muxer.tracks.h264.parsing.read.CAVLCReader;

public class SEIMessage {
    int payloadType = 0;
    int payloadSize = 0;
    boolean removal_delay_flag;
    int cpb_removal_delay;
    int dpb_removal_delay;
    boolean clock_timestamp_flag;
    int pic_struct;
    int ct_type;
    int nuit_field_based_flag;
    int counting_type;
    int full_timestamp_flag;
    int discontinuity_flag;
    int cnt_dropped_flag;
    int n_frames;
    int seconds_value;
    int minutes_value;
    int hours_value;
    int time_offset_length;
    int time_offset;
    SeqParameterSet sps;

    public SEIMessage(InputStream is, SeqParameterSet sps) throws IOException {
        this.sps = sps;
        is.read();
        int datasize = is.available();
        int read = 0;
        while (read < datasize) {
            this.payloadType = 0;
            this.payloadSize = 0;
            int last_payload_type_bytes = is.read();
            ++read;
            while (last_payload_type_bytes == 255) {
                this.payloadType += last_payload_type_bytes;
                last_payload_type_bytes = is.read();
                ++read;
            }
            this.payloadType += last_payload_type_bytes;
            int last_payload_size_bytes = is.read();
            ++read;
            while (last_payload_size_bytes == 255) {
                this.payloadSize += last_payload_size_bytes;
                last_payload_size_bytes = is.read();
                ++read;
            }
            this.payloadSize += last_payload_size_bytes;
            if (datasize - read >= this.payloadSize) {
                if (this.payloadType == 1) {
                    if (sps.vuiParams != null && (sps.vuiParams.nalHRDParams != null || sps.vuiParams.vclHRDParams != null || sps.vuiParams.pic_struct_present_flag)) {
                        int numClockTS;
                        byte[] data = new byte[this.payloadSize];
                        is.read(data);
                        read += this.payloadSize;
                        CAVLCReader reader = new CAVLCReader(new ByteArrayInputStream(data));
                        if (sps.vuiParams.nalHRDParams != null || sps.vuiParams.vclHRDParams != null) {
                            this.removal_delay_flag = true;
                            this.cpb_removal_delay = reader.readU(sps.vuiParams.nalHRDParams.cpb_removal_delay_length_minus1 + 1, "SEI: cpb_removal_delay");
                            this.dpb_removal_delay = reader.readU(sps.vuiParams.nalHRDParams.dpb_output_delay_length_minus1 + 1, "SEI: dpb_removal_delay");
                        } else {
                            this.removal_delay_flag = false;
                        }
                        if (!sps.vuiParams.pic_struct_present_flag) continue;
                        this.pic_struct = reader.readU(4, "SEI: pic_struct");
                        switch (this.pic_struct) {
                            default: {
                                numClockTS = 1;
                                break;
                            }
                            case 3: 
                            case 4: 
                            case 7: {
                                numClockTS = 2;
                                break;
                            }
                            case 5: 
                            case 6: 
                            case 8: {
                                numClockTS = 3;
                            }
                        }
                        for (int i = 0; i < numClockTS; ++i) {
                            this.clock_timestamp_flag = reader.readBool("pic_timing SEI: clock_timestamp_flag[" + i + "]");
                            if (!this.clock_timestamp_flag) continue;
                            this.ct_type = reader.readU(2, "pic_timing SEI: ct_type");
                            this.nuit_field_based_flag = reader.readU(1, "pic_timing SEI: nuit_field_based_flag");
                            this.counting_type = reader.readU(5, "pic_timing SEI: counting_type");
                            this.full_timestamp_flag = reader.readU(1, "pic_timing SEI: full_timestamp_flag");
                            this.discontinuity_flag = reader.readU(1, "pic_timing SEI: discontinuity_flag");
                            this.cnt_dropped_flag = reader.readU(1, "pic_timing SEI: cnt_dropped_flag");
                            this.n_frames = reader.readU(8, "pic_timing SEI: n_frames");
                            if (this.full_timestamp_flag == 1) {
                                this.seconds_value = reader.readU(6, "pic_timing SEI: seconds_value");
                                this.minutes_value = reader.readU(6, "pic_timing SEI: minutes_value");
                                this.hours_value = reader.readU(5, "pic_timing SEI: hours_value");
                            } else if (reader.readBool("pic_timing SEI: seconds_flag")) {
                                this.seconds_value = reader.readU(6, "pic_timing SEI: seconds_value");
                                if (reader.readBool("pic_timing SEI: minutes_flag")) {
                                    this.minutes_value = reader.readU(6, "pic_timing SEI: minutes_value");
                                    if (reader.readBool("pic_timing SEI: hours_flag")) {
                                        this.hours_value = reader.readU(5, "pic_timing SEI: hours_value");
                                    }
                                }
                            }
                            this.time_offset_length = sps.vuiParams.nalHRDParams != null ? sps.vuiParams.nalHRDParams.time_offset_length : (sps.vuiParams.vclHRDParams != null ? sps.vuiParams.vclHRDParams.time_offset_length : 24);
                            this.time_offset = reader.readU(24, "pic_timing SEI: time_offset");
                        }
                        continue;
                    }
                    for (int i = 0; i < this.payloadSize; ++i) {
                        is.read();
                        ++read;
                    }
                    continue;
                }
                for (int i = 0; i < this.payloadSize; ++i) {
                    is.read();
                    ++read;
                }
                continue;
            }
            read = datasize;
        }
    }

    public String toString() {
        String out = "SEIMessage{payloadType=" + this.payloadType + ", payloadSize=" + this.payloadSize;
        if (this.payloadType == 1) {
            if (this.sps.vuiParams.nalHRDParams != null || this.sps.vuiParams.vclHRDParams != null) {
                out = out + ", cpb_removal_delay=" + this.cpb_removal_delay + ", dpb_removal_delay=" + this.dpb_removal_delay;
            }
            if (this.sps.vuiParams.pic_struct_present_flag) {
                out = out + ", pic_struct=" + this.pic_struct;
                if (this.clock_timestamp_flag) {
                    out = out + ", ct_type=" + this.ct_type + ", nuit_field_based_flag=" + this.nuit_field_based_flag + ", counting_type=" + this.counting_type + ", full_timestamp_flag=" + this.full_timestamp_flag + ", discontinuity_flag=" + this.discontinuity_flag + ", cnt_dropped_flag=" + this.cnt_dropped_flag + ", n_frames=" + this.n_frames + ", seconds_value=" + this.seconds_value + ", minutes_value=" + this.minutes_value + ", hours_value=" + this.hours_value + ", time_offset_length=" + this.time_offset_length + ", time_offset=" + this.time_offset;
                }
            }
        }
        out = out + '}';
        return out;
    }
}

