/*
 * Decompiled with CFR 0.152.
 */
package org.mp4parser.muxer.tracks;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.mp4parser.Box;
import org.mp4parser.boxes.iso14496.part12.CompositionTimeToSample;
import org.mp4parser.boxes.iso14496.part12.SampleDependencyTypeBox;
import org.mp4parser.boxes.iso14496.part12.SubSampleInformationBox;
import org.mp4parser.boxes.sampleentry.SampleEntry;
import org.mp4parser.boxes.sampleentry.TextSampleEntry;
import org.mp4parser.boxes.threegpp.ts26245.FontTableBox;
import org.mp4parser.muxer.AbstractTrack;
import org.mp4parser.muxer.Sample;
import org.mp4parser.muxer.SampleImpl;
import org.mp4parser.muxer.TrackMetaData;

public class TextTrackImpl
extends AbstractTrack {
    TrackMetaData trackMetaData = new TrackMetaData();
    TextSampleEntry tx3g;
    List<Line> subs = new LinkedList<Line>();
    List<Sample> samples;

    public TextTrackImpl() {
        super("subtitles");
        this.tx3g = new TextSampleEntry("tx3g");
        this.tx3g.setDataReferenceIndex(1);
        this.tx3g.setStyleRecord(new TextSampleEntry.StyleRecord());
        this.tx3g.setBoxRecord(new TextSampleEntry.BoxRecord());
        FontTableBox ftab = new FontTableBox();
        ftab.setEntries(Collections.singletonList(new FontTableBox.FontRecord(1, "Serif")));
        this.tx3g.addBox((Box)ftab);
        this.trackMetaData.setCreationTime(new Date());
        this.trackMetaData.setModificationTime(new Date());
        this.trackMetaData.setTimescale(1000L);
    }

    public List<Line> getSubs() {
        return this.subs;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public synchronized List<Sample> getSamples() {
        if (this.samples == null) {
            this.samples = new ArrayList<Sample>();
            long lastEnd = 0L;
            for (Line sub : this.subs) {
                long silentTime = sub.from - lastEnd;
                if (silentTime > 0L) {
                    this.samples.add(new SampleImpl(ByteBuffer.wrap(new byte[]{0, 0}), (SampleEntry)this.tx3g));
                } else if (silentTime < 0L) {
                    throw new Error("Subtitle display times may not intersect");
                }
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                DataOutputStream dos = new DataOutputStream(baos);
                try {
                    dos.writeShort(sub.text.getBytes("UTF-8").length);
                    dos.write(sub.text.getBytes("UTF-8"));
                    dos.close();
                }
                catch (IOException e) {
                    throw new Error("VM is broken. Does not support UTF-8");
                }
                this.samples.add(new SampleImpl(ByteBuffer.wrap(baos.toByteArray()), (SampleEntry)this.tx3g));
                lastEnd = sub.to;
            }
        }
        return this.samples;
    }

    @Override
    public List<SampleEntry> getSampleEntries() {
        return Collections.singletonList(this.tx3g);
    }

    @Override
    public long[] getSampleDurations() {
        ArrayList<Long> decTimes = new ArrayList<Long>();
        long lastEnd = 0L;
        for (Line sub : this.subs) {
            long silentTime = sub.from - lastEnd;
            if (silentTime > 0L) {
                decTimes.add(silentTime);
            } else if (silentTime < 0L) {
                throw new Error("Subtitle display times may not intersect");
            }
            decTimes.add(sub.to - sub.from);
            lastEnd = sub.to;
        }
        long[] decTimesArray = new long[decTimes.size()];
        int index = 0;
        for (Long decTime : decTimes) {
            decTimesArray[index++] = decTime;
        }
        return decTimesArray;
    }

    @Override
    public List<CompositionTimeToSample.Entry> getCompositionTimeEntries() {
        return null;
    }

    @Override
    public long[] getSyncSamples() {
        return null;
    }

    @Override
    public List<SampleDependencyTypeBox.Entry> getSampleDependencies() {
        return null;
    }

    @Override
    public TrackMetaData getTrackMetaData() {
        return this.trackMetaData;
    }

    @Override
    public String getHandler() {
        return "sbtl";
    }

    @Override
    public SubSampleInformationBox getSubsampleInformationBox() {
        return null;
    }

    public static class Line {
        long from;
        long to;
        String text;

        public Line(long from, long to, String text) {
            this.from = from;
            this.to = to;
            this.text = text;
        }

        public long getFrom() {
            return this.from;
        }

        public String getText() {
            return this.text;
        }

        public long getTo() {
            return this.to;
        }
    }
}

