/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.model.meta;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jupnp.model.Namespace;
import org.jupnp.model.ValidationError;
import org.jupnp.model.ValidationException;
import org.jupnp.model.meta.Action;
import org.jupnp.model.meta.Device;
import org.jupnp.model.meta.DeviceDetails;
import org.jupnp.model.meta.DeviceIdentity;
import org.jupnp.model.meta.Icon;
import org.jupnp.model.meta.LocalService;
import org.jupnp.model.meta.Service;
import org.jupnp.model.meta.StateVariable;
import org.jupnp.model.meta.UDAVersion;
import org.jupnp.model.profile.DeviceDetailsProvider;
import org.jupnp.model.profile.RemoteClientInfo;
import org.jupnp.model.resource.DeviceDescriptorResource;
import org.jupnp.model.resource.IconResource;
import org.jupnp.model.resource.Resource;
import org.jupnp.model.resource.ServiceControlResource;
import org.jupnp.model.resource.ServiceDescriptorResource;
import org.jupnp.model.resource.ServiceEventSubscriptionResource;
import org.jupnp.model.types.DeviceType;
import org.jupnp.model.types.ServiceId;
import org.jupnp.model.types.ServiceType;
import org.jupnp.model.types.UDN;

public class LocalDevice
extends Device<DeviceIdentity, LocalDevice, LocalService> {
    private final DeviceDetailsProvider deviceDetailsProvider;

    public LocalDevice(DeviceIdentity identity) throws ValidationException {
        super(identity);
        this.deviceDetailsProvider = null;
    }

    public LocalDevice(DeviceIdentity identity, DeviceType type, DeviceDetails details, LocalService service) throws ValidationException {
        super(identity, type, details, null, (Service[])new LocalService[]{service});
        this.deviceDetailsProvider = null;
    }

    public LocalDevice(DeviceIdentity identity, DeviceType type, DeviceDetailsProvider deviceDetailsProvider, LocalService service) throws ValidationException {
        super(identity, type, null, null, (Service[])new LocalService[]{service});
        this.deviceDetailsProvider = deviceDetailsProvider;
    }

    public LocalDevice(DeviceIdentity identity, DeviceType type, DeviceDetailsProvider deviceDetailsProvider, LocalService service, LocalDevice embeddedDevice) throws ValidationException {
        super(identity, type, null, null, (Service[])new LocalService[]{service}, (Device[])new LocalDevice[]{embeddedDevice});
        this.deviceDetailsProvider = deviceDetailsProvider;
    }

    public LocalDevice(DeviceIdentity identity, DeviceType type, DeviceDetails details, LocalService service, LocalDevice embeddedDevice) throws ValidationException {
        super(identity, type, details, null, (Service[])new LocalService[]{service}, (Device[])new LocalDevice[]{embeddedDevice});
        this.deviceDetailsProvider = null;
    }

    public LocalDevice(DeviceIdentity identity, DeviceType type, DeviceDetails details, LocalService[] services) throws ValidationException {
        super(identity, type, details, null, (Service[])services);
        this.deviceDetailsProvider = null;
    }

    public LocalDevice(DeviceIdentity identity, DeviceType type, DeviceDetails details, LocalService[] services, LocalDevice[] embeddedDevices) throws ValidationException {
        super(identity, type, details, null, (Service[])services, (Device[])embeddedDevices);
        this.deviceDetailsProvider = null;
    }

    public LocalDevice(DeviceIdentity identity, DeviceType type, DeviceDetails details, Icon icon, LocalService service) throws ValidationException {
        super(identity, type, details, new Icon[]{icon}, (Service[])new LocalService[]{service});
        this.deviceDetailsProvider = null;
    }

    public LocalDevice(DeviceIdentity identity, DeviceType type, DeviceDetails details, Icon icon, LocalService service, LocalDevice embeddedDevice) throws ValidationException {
        super(identity, type, details, new Icon[]{icon}, (Service[])new LocalService[]{service}, (Device[])new LocalDevice[]{embeddedDevice});
        this.deviceDetailsProvider = null;
    }

    public LocalDevice(DeviceIdentity identity, DeviceType type, DeviceDetails details, Icon icon, LocalService[] services) throws ValidationException {
        super(identity, type, details, new Icon[]{icon}, (Service[])services);
        this.deviceDetailsProvider = null;
    }

    public LocalDevice(DeviceIdentity identity, DeviceType type, DeviceDetailsProvider deviceDetailsProvider, Icon icon, LocalService[] services) throws ValidationException {
        super(identity, type, null, new Icon[]{icon}, (Service[])services);
        this.deviceDetailsProvider = deviceDetailsProvider;
    }

    public LocalDevice(DeviceIdentity identity, DeviceType type, DeviceDetails details, Icon icon, LocalService[] services, LocalDevice[] embeddedDevices) throws ValidationException {
        super(identity, type, details, new Icon[]{icon}, (Service[])services, (Device[])embeddedDevices);
        this.deviceDetailsProvider = null;
    }

    public LocalDevice(DeviceIdentity identity, DeviceType type, DeviceDetails details, Icon[] icons, LocalService service) throws ValidationException {
        super(identity, type, details, icons, (Service[])new LocalService[]{service});
        this.deviceDetailsProvider = null;
    }

    public LocalDevice(DeviceIdentity identity, DeviceType type, DeviceDetails details, Icon[] icons, LocalService service, LocalDevice embeddedDevice) throws ValidationException {
        super(identity, type, details, icons, (Service[])new LocalService[]{service}, (Device[])new LocalDevice[]{embeddedDevice});
        this.deviceDetailsProvider = null;
    }

    public LocalDevice(DeviceIdentity identity, DeviceType type, DeviceDetailsProvider deviceDetailsProvider, Icon[] icons, LocalService service, LocalDevice embeddedDevice) throws ValidationException {
        super(identity, type, null, icons, (Service[])new LocalService[]{service}, (Device[])new LocalDevice[]{embeddedDevice});
        this.deviceDetailsProvider = deviceDetailsProvider;
    }

    public LocalDevice(DeviceIdentity identity, DeviceType type, DeviceDetails details, Icon[] icons, LocalService[] services) throws ValidationException {
        super(identity, type, details, icons, (Service[])services);
        this.deviceDetailsProvider = null;
    }

    public LocalDevice(DeviceIdentity identity, DeviceType type, DeviceDetails details, Icon[] icons, LocalService[] services, LocalDevice[] embeddedDevices) throws ValidationException {
        super(identity, type, details, icons, (Service[])services, (Device[])embeddedDevices);
        this.deviceDetailsProvider = null;
    }

    public LocalDevice(DeviceIdentity identity, UDAVersion version, DeviceType type, DeviceDetails details, Icon[] icons, LocalService[] services, LocalDevice[] embeddedDevices) throws ValidationException {
        super(identity, version, type, details, icons, (Service[])services, (Device[])embeddedDevices);
        this.deviceDetailsProvider = null;
    }

    public LocalDevice(DeviceIdentity identity, UDAVersion version, DeviceType type, DeviceDetailsProvider deviceDetailsProvider, Icon[] icons, LocalService[] services, LocalDevice[] embeddedDevices) throws ValidationException {
        super(identity, version, type, null, icons, (Service[])services, (Device[])embeddedDevices);
        this.deviceDetailsProvider = deviceDetailsProvider;
    }

    public DeviceDetailsProvider getDeviceDetailsProvider() {
        return this.deviceDetailsProvider;
    }

    @Override
    public DeviceDetails getDetails(RemoteClientInfo info) {
        if (this.getDeviceDetailsProvider() != null) {
            return this.getDeviceDetailsProvider().provide(info);
        }
        return this.getDetails();
    }

    public LocalService[] getServices() {
        return this.services != null ? (LocalService[])this.services : new LocalService[]{};
    }

    public LocalDevice[] getEmbeddedDevices() {
        return this.embeddedDevices != null ? (LocalDevice[])this.embeddedDevices : new LocalDevice[]{};
    }

    public LocalDevice newInstance(UDN udn, UDAVersion version, DeviceType type, DeviceDetails details, Icon[] icons, LocalService[] services, List<LocalDevice> embeddedDevices) throws ValidationException {
        return new LocalDevice(new DeviceIdentity(udn, ((DeviceIdentity)this.getIdentity()).getMaxAgeSeconds()), version, type, details, icons, services, !embeddedDevices.isEmpty() ? embeddedDevices.toArray(new LocalDevice[embeddedDevices.size()]) : null);
    }

    @Override
    public LocalService newInstance(ServiceType serviceType, ServiceId serviceId, URI descriptorURI, URI controlURI, URI eventSubscriptionURI, Action<LocalService>[] actions, StateVariable<LocalService>[] stateVariables) throws ValidationException {
        return new LocalService(serviceType, serviceId, (Action[])actions, (StateVariable[])stateVariables);
    }

    public LocalDevice[] toDeviceArray(Collection<LocalDevice> col) {
        return col.toArray(new LocalDevice[col.size()]);
    }

    public LocalService[] newServiceArray(int size) {
        return new LocalService[size];
    }

    public LocalService[] toServiceArray(Collection<LocalService> col) {
        return col.toArray(new LocalService[col.size()]);
    }

    @Override
    public List<ValidationError> validate() {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>(super.validate());
        if (this.hasIcons()) {
            Icon[] iconArray = this.getIcons();
            int n = iconArray.length;
            int n2 = 0;
            while (n2 < n) {
                Icon icon = iconArray[n2];
                if (icon.getUri().isAbsolute()) {
                    errors.add(new ValidationError(this.getClass(), "icons", "Local icon URI can not be absolute: " + String.valueOf(icon.getUri())));
                }
                if (icon.getUri().toString().contains("../")) {
                    errors.add(new ValidationError(this.getClass(), "icons", "Local icon URI must not contain '../': " + String.valueOf(icon.getUri())));
                }
                if (icon.getUri().toString().startsWith("/")) {
                    errors.add(new ValidationError(this.getClass(), "icons", "Local icon URI must not start with '/': " + String.valueOf(icon.getUri())));
                }
                ++n2;
            }
        }
        return errors;
    }

    @Override
    public Resource[] discoverResources(Namespace namespace) {
        ArrayList<Resource> discovered = new ArrayList<Resource>();
        if (this.isRoot()) {
            discovered.add(new DeviceDescriptorResource(namespace.getDescriptorPath(this), this));
        }
        Object[] objectArray = this.getServices();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            LocalService service = objectArray[n2];
            discovered.add(new ServiceDescriptorResource(namespace.getDescriptorPath(service), service));
            discovered.add(new ServiceControlResource(namespace.getControlPath(service), service));
            discovered.add(new ServiceEventSubscriptionResource(namespace.getEventSubscriptionPath(service), service));
            ++n2;
        }
        objectArray = this.getIcons();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            Object icon = objectArray[n2];
            discovered.add(new IconResource(namespace.prefixIfRelative(this, ((Icon)icon).getUri()), (Icon)icon));
            ++n2;
        }
        if (this.hasEmbeddedDevices()) {
            objectArray = this.getEmbeddedDevices();
            n = objectArray.length;
            n2 = 0;
            while (n2 < n) {
                Object embeddedDevice = objectArray[n2];
                discovered.addAll(Arrays.asList(((Device)embeddedDevice).discoverResources(namespace)));
                ++n2;
            }
        }
        return discovered.toArray(new Resource[discovered.size()]);
    }

    @Override
    public LocalDevice getRoot() {
        if (this.isRoot()) {
            return this;
        }
        LocalDevice current = this;
        while (current.getParentDevice() != null) {
            current = (LocalDevice)current.getParentDevice();
        }
        return current;
    }

    @Override
    public LocalDevice findDevice(UDN udn) {
        return this.find(udn, this);
    }
}

