/*
 * Decompiled with CFR 0.152.
 */
package com.uwetrottmann.trakt5.enums;

import com.uwetrottmann.trakt5.enums.TraktEnum;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public enum Status implements TraktEnum
{
    ENDED("ended"),
    RETURNING("returning series"),
    CANCELED("canceled"),
    IN_PRODUCTION("in production");

    private final String value;
    private static final Map<String, Status> STRING_MAPPING;

    private Status(String value) {
        this.value = value;
    }

    public static Status fromValue(String value) {
        return STRING_MAPPING.get(value.toUpperCase(Locale.ROOT));
    }

    @Override
    public String toString() {
        return this.value;
    }

    static {
        STRING_MAPPING = new HashMap<String, Status>();
        for (Status via : Status.values()) {
            STRING_MAPPING.put(via.toString().toUpperCase(Locale.ROOT), via);
        }
    }
}

