/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.thirdparty.imageviewer;

import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import org.tinymediamanager.ui.thirdparty.imageviewer.ImageViewer;
import org.tinymediamanager.ui.thirdparty.imageviewer.ResizeStrategy;

public class ImageViewerPopup
extends JPopupMenu {
    private final ImageViewer viewer;

    public ImageViewerPopup(ImageViewer imageViewer) {
        this.viewer = imageViewer;
        JRadioButtonMenuItem zoomOriginalSize = new JRadioButtonMenuItem("Original size", this.viewer.getResizeStrategy() == ResizeStrategy.NO_RESIZE);
        zoomOriginalSize.addActionListener(e -> this.viewer.setResizeStrategy(ResizeStrategy.NO_RESIZE));
        JRadioButtonMenuItem zoomResizeToFit = new JRadioButtonMenuItem("Resize to fit", this.viewer.getResizeStrategy() == ResizeStrategy.RESIZE_TO_FIT);
        zoomResizeToFit.addActionListener(e -> this.viewer.setResizeStrategy(ResizeStrategy.RESIZE_TO_FIT));
        CustomZoomEntry[] customZoomEntries = new CustomZoomEntry[]{new CustomZoomEntry("25%", 0.25), new CustomZoomEntry("50%", 0.5), new CustomZoomEntry("75%", 0.75), new CustomZoomEntry("100%", 1.0), new CustomZoomEntry("150%", 1.5), new CustomZoomEntry("200%", 2.0), new CustomZoomEntry("300%", 3.0), new CustomZoomEntry("500%", 5.0)};
        ButtonGroup group = new ButtonGroup();
        group.add(zoomOriginalSize);
        group.add(zoomResizeToFit);
        for (CustomZoomEntry cze : customZoomEntries) {
            group.add(cze.menuItem);
        }
        this.viewer.addPropertyChangeListener("resizeStrategy", evt -> {
            block0 : switch ((ResizeStrategy)((Object)((Object)evt.getNewValue()))) {
                case NO_RESIZE: {
                    zoomOriginalSize.setSelected(true);
                    break;
                }
                case RESIZE_TO_FIT: {
                    zoomResizeToFit.setSelected(true);
                    break;
                }
                case CUSTOM_ZOOM: {
                    group.clearSelection();
                    for (CustomZoomEntry cze : customZoomEntries) {
                        if (cze.value != this.viewer.getZoomFactor()) continue;
                        cze.menuItem.setSelected(true);
                        break block0;
                    }
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unknown resize strategy: " + evt.getNewValue()));
                }
            }
        });
        this.viewer.addPropertyChangeListener("zoomFactor", evt -> {
            if (this.viewer.getResizeStrategy() == ResizeStrategy.CUSTOM_ZOOM) {
                group.clearSelection();
                for (CustomZoomEntry cze : customZoomEntries) {
                    if (cze.value != this.viewer.getZoomFactor()) continue;
                    cze.menuItem.setSelected(true);
                    break;
                }
            }
        });
        JCheckBoxMenuItem togglePixelatedZoomItem = new JCheckBoxMenuItem("Pixelated zoom");
        togglePixelatedZoomItem.setState(this.viewer.isPixelatedZoom());
        this.viewer.addPropertyChangeListener("pixelatedZoom", evt -> togglePixelatedZoomItem.setState(this.viewer.isPixelatedZoom()));
        togglePixelatedZoomItem.addActionListener(e -> this.viewer.setPixelatedZoom(!this.viewer.isPixelatedZoom()));
        this.add(zoomOriginalSize);
        this.add(zoomResizeToFit);
        this.addSeparator();
        for (CustomZoomEntry cze : customZoomEntries) {
            this.add(cze.menuItem);
        }
        this.addSeparator();
        this.add(togglePixelatedZoomItem);
    }

    private class CustomZoomEntry {
        String label;
        double value;
        JRadioButtonMenuItem menuItem;

        private CustomZoomEntry(String label, double value) {
            this.label = label;
            this.value = value;
            this.menuItem = new JRadioButtonMenuItem(label, ImageViewerPopup.this.viewer.getResizeStrategy() == ResizeStrategy.CUSTOM_ZOOM && ImageViewerPopup.this.viewer.getZoomFactor() == value);
            this.menuItem.addActionListener(e -> {
                ImageViewerPopup.this.viewer.setResizeStrategy(ResizeStrategy.CUSTOM_ZOOM);
                ImageViewerPopup.this.viewer.setZoomFactor(this.value);
            });
        }
    }
}

