/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.thirdparty.imageviewer;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;
import org.tinymediamanager.ui.components.NoBorderScrollPane;
import org.tinymediamanager.ui.thirdparty.imageviewer.ImageComponent;
import org.tinymediamanager.ui.thirdparty.imageviewer.ImageViewerPopup;
import org.tinymediamanager.ui.thirdparty.imageviewer.ResizeStrategy;

public class ImageViewer {
    private final ImageComponent theImage;
    private final JScrollPane scroller;
    private final JPanel panel;
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private final JPopupMenu popup;

    public ImageViewer() {
        this(null);
    }

    public ImageViewer(BufferedImage image) {
        this.panel = new JPanel((LayoutManager)new MigLayout("", "[300lp,grow]", "[300lp,grow]"));
        this.scroller = new NoBorderScrollPane(){

            @Override
            protected JViewport createViewport() {
                return new JViewport(){

                    @Override
                    protected LayoutManager createLayoutManager() {
                        return new CustomViewportLayout(ImageViewer.this);
                    }

                    @Override
                    public Dimension getMaximumSize() {
                        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
                    }
                };
            }

            @Override
            public boolean isValidateRoot() {
                return false;
            }
        };
        this.theImage = new ImageComponent(this, this.propertyChangeSupport);
        this.scroller.setViewportView(new ScrollablePanel(this.theImage));
        this.theImage.setImage(image);
        this.panel.add((Component)this.scroller, "cell 0 0, center, grow");
        this.popup = new ImageViewerPopup(this);
        this.theImage.addMouseListener(new MyMouseAdapter(this.popup, this.panel));
    }

    public JPopupMenu getPopupMenu() {
        return this.popup;
    }

    public JComponent getComponent() {
        return this.panel;
    }

    public void setImage(BufferedImage image) {
        this.theImage.setImage(image);
    }

    public BufferedImage getImage() {
        return this.theImage.getImage();
    }

    void setResizeStrategy(ResizeStrategy resizeStrategy) {
        this.theImage.setResizeStrategy(resizeStrategy);
    }

    ResizeStrategy getResizeStrategy() {
        return this.theImage.getResizeStrategy();
    }

    void setPixelatedZoom(boolean pixelatedZoom) {
        this.theImage.setPixelatedZoom(pixelatedZoom);
    }

    boolean isPixelatedZoom() {
        return this.theImage.isPixelatedZoom();
    }

    Object getInterpolationType() {
        return this.theImage.getInterpolationType();
    }

    void setInterpolationType(Object type) {
        this.theImage.setInterpolationType(type);
    }

    double getZoomFactor() {
        return this.theImage.getZoomFactor();
    }

    void setZoomFactor(double newZoomFactor) {
        this.theImage.setZoomFactor(newZoomFactor);
    }

    public void addMouseListener(MouseListener l) {
        this.theImage.addMouseListener(l);
    }

    public void removeMouseListener(MouseListener l) {
        this.theImage.removeMouseListener(l);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    public void addPropertyChangeListener(String name, PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(name, l);
    }

    public void removePropertyChangeListener(String name, PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(name, l);
    }

    JScrollPane getScrollPane() {
        return this.scroller;
    }

    private static class ScrollablePanel
    extends JPanel
    implements Scrollable {
        private final ImageComponent theImage;

        public ScrollablePanel(ImageComponent imageComponent) {
            this.theImage = imageComponent;
            this.setLayout(new ScrollableLayout(this.theImage));
            this.add(this.theImage);
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 10;
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 50;
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return this.theImage.getResizeStrategy() == ResizeStrategy.SHRINK_TO_FIT || this.theImage.getResizeStrategy() == ResizeStrategy.RESIZE_TO_FIT;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return this.theImage.getResizeStrategy() == ResizeStrategy.SHRINK_TO_FIT || this.theImage.getResizeStrategy() == ResizeStrategy.RESIZE_TO_FIT;
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            if (this.theImage.getResizeStrategy() == ResizeStrategy.NO_RESIZE) {
                return this.getPreferredSize();
            }
            return SwingUtilities.getAncestorOfClass(JViewport.class, this).getSize();
        }
    }

    private static class MyMouseAdapter
    extends MouseAdapter {
        private final JPopupMenu popup;
        private final JPanel panel;

        public MyMouseAdapter(JPopupMenu popup, JPanel panel) {
            this.popup = popup;
            this.panel = panel;
        }

        private void showPopup(MouseEvent e) {
            e.consume();
            Point point = this.panel.getPopupLocation(e);
            if (point == null) {
                point = e.getPoint();
            }
            this.popup.show(e.getComponent(), point.x, point.y);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.showPopup(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.showPopup(e);
            }
        }
    }

    private static class ScrollableLayout
    implements LayoutManager {
        private final ImageComponent theImage;

        public ScrollableLayout(ImageComponent theImage) {
            this.theImage = theImage;
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return this.theImage.getPreferredSize();
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.theImage.getMinimumSize();
        }

        @Override
        public void layoutContainer(Container parent) {
            for (int i = 0; i < parent.getComponentCount(); ++i) {
                parent.getComponent(i).setBounds(0, 0, parent.getWidth(), parent.getHeight());
            }
        }
    }

    private static class CustomViewportLayout
    implements LayoutManager {
        private final ImageViewer viewer;

        public CustomViewportLayout(ImageViewer viewer) {
            this.viewer = viewer;
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            BufferedImage image = this.viewer.getImage();
            if (image == null) {
                return new Dimension();
            }
            return new Dimension(image.getWidth(), image.getHeight());
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return new Dimension(4, 4);
        }

        @Override
        public void layoutContainer(Container parent) {
            JViewport vp = (JViewport)parent;
            Component view = vp.getView();
            if (view == null) {
                return;
            }
            Dimension vpSize = vp.getSize();
            Dimension viewSize = new Dimension(view.getPreferredSize());
            if (this.viewer.getResizeStrategy() == ResizeStrategy.SHRINK_TO_FIT || this.viewer.getResizeStrategy() == ResizeStrategy.RESIZE_TO_FIT) {
                viewSize.width = vpSize.width;
                viewSize.height = vpSize.height;
            } else {
                viewSize.width = Math.max(viewSize.width, vpSize.width);
                viewSize.height = Math.max(viewSize.height, vpSize.height);
            }
            vp.setViewSize(viewSize);
        }
    }
}

