/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.filters;

import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.tinymediamanager.ui.ITmmUIFilter;
import org.tinymediamanager.ui.components.datepicker.DatePicker;
import org.tinymediamanager.ui.movies.filters.AbstractMovieUIFilter;

public abstract class AbstractDateMovieFilter
extends AbstractMovieUIFilter {
    protected DatePicker datePickerLow;
    protected DatePicker datePickerHigh;
    protected JLabel lblTo;

    @Override
    public String getFilterValueAsString() {
        StringBuilder sb = new StringBuilder();
        Date dateLow = this.datePickerLow.getDate();
        Date dateHigh = this.datePickerHigh.getDate();
        if (dateLow != null) {
            sb.append(dateLow.getTime());
        }
        sb.append(",");
        if (dateHigh != null) {
            sb.append(dateHigh.getTime());
        }
        return sb.toString();
    }

    @Override
    public void setFilterValue(Object value) {
        if (value != null && StringUtils.isNotBlank((CharSequence)value.toString())) {
            String[] values = value.toString().split(",");
            try {
                if (values.length > 0 && StringUtils.isNotBlank((CharSequence)values[0])) {
                    this.datePickerLow.setDate(new Date(Long.parseLong(values[0])));
                }
                if (values.length > 1 && StringUtils.isNotBlank((CharSequence)values[1])) {
                    this.datePickerHigh.setDate(new Date(Long.parseLong(values[1])));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void clearFilter() {
        this.datePickerLow.setDate(null);
        this.datePickerHigh.setDate(null);
    }

    @Override
    protected JComboBox<ITmmUIFilter.FilterOption> createOptionComboBox() {
        JComboBox<ITmmUIFilter.FilterOption> comboBox = new JComboBox<ITmmUIFilter.FilterOption>(new ITmmUIFilter.FilterOption[]{ITmmUIFilter.FilterOption.LT, ITmmUIFilter.FilterOption.LE, ITmmUIFilter.FilterOption.EQ, ITmmUIFilter.FilterOption.GT, ITmmUIFilter.FilterOption.GE, ITmmUIFilter.FilterOption.BT});
        comboBox.addActionListener(l -> {
            this.lblTo.setVisible(comboBox.getSelectedItem() == ITmmUIFilter.FilterOption.BT);
            this.datePickerHigh.setVisible(comboBox.getSelectedItem() == ITmmUIFilter.FilterOption.BT);
        });
        comboBox.setSelectedItem((Object)ITmmUIFilter.FilterOption.EQ);
        return comboBox;
    }

    @Override
    protected JComponent createFilterComponent() {
        JPanel panelFilterComponent = new JPanel((LayoutManager)new MigLayout("insets 0", "[][][]", "[]"));
        this.datePickerLow = new DatePicker();
        this.datePickerLow.addPropertyChangeListener("date", e -> {
            if (this.getFilterState() != ITmmUIFilter.FilterState.INACTIVE) {
                this.filterChanged();
            }
        });
        panelFilterComponent.add((Component)this.datePickerLow, "cell 0 0");
        this.lblTo = new JLabel("-");
        panelFilterComponent.add((Component)this.lblTo, "cell 1 0");
        this.datePickerHigh = new DatePicker();
        this.datePickerHigh.addPropertyChangeListener("date", e -> {
            if (this.getFilterState() != ITmmUIFilter.FilterState.INACTIVE) {
                this.filterChanged();
            }
        });
        panelFilterComponent.add((Component)this.datePickerHigh, "cell 2 0");
        return panelFilterComponent;
    }

    protected boolean matchDate(Date date) {
        if (date == null) {
            return false;
        }
        Date dateLow = this.datePickerLow.getDate();
        Date dateHigh = this.datePickerHigh.getDate();
        if (dateLow == null && dateHigh == null) {
            return true;
        }
        ITmmUIFilter.FilterOption filterOption = this.getFilterOption();
        Calendar calDate = Calendar.getInstance();
        calDate.setTime(date);
        calDate = DateUtils.truncate((Calendar)calDate, (int)5);
        if (dateLow != null) {
            Calendar calLow = Calendar.getInstance();
            calLow.setTime(dateLow);
            calLow = DateUtils.truncate((Calendar)calLow, (int)5);
            if (filterOption == ITmmUIFilter.FilterOption.EQ && DateUtils.isSameDay((Calendar)calDate, (Calendar)calLow)) {
                return true;
            }
            if (filterOption == ITmmUIFilter.FilterOption.LT && calDate.before(calLow)) {
                return true;
            }
            if (filterOption == ITmmUIFilter.FilterOption.LE && (DateUtils.isSameDay((Calendar)calDate, (Calendar)calLow) || calDate.before(calLow))) {
                return true;
            }
            if (filterOption == ITmmUIFilter.FilterOption.GE && (DateUtils.isSameDay((Calendar)calDate, (Calendar)calLow) || calDate.after(calLow))) {
                return true;
            }
            if (filterOption == ITmmUIFilter.FilterOption.GT && calDate.after(calLow)) {
                return true;
            }
            if (filterOption == ITmmUIFilter.FilterOption.BT && dateHigh != null) {
                Calendar calHigh = Calendar.getInstance();
                calHigh.setTime(dateHigh);
                calHigh = DateUtils.truncate((Calendar)calHigh, (int)5);
                boolean afterOrEqualLow = DateUtils.isSameDay((Calendar)calDate, (Calendar)calLow) || calDate.after(calLow);
                boolean beforeOrEqualHigh = DateUtils.isSameDay((Calendar)calDate, (Calendar)calHigh) || calDate.before(calHigh);
                return afterOrEqualLow && beforeOrEqualHigh;
            }
        }
        return false;
    }
}

