/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components.table;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.swing.GlazedListsSwing;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.table.TableModel;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaFileAudioStream;
import org.tinymediamanager.core.entities.MediaStreamInfo;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.components.table.TmmEditorTable;
import org.tinymediamanager.ui.components.table.TmmTableFormat;
import org.tinymediamanager.ui.components.table.TmmTableModel;
import org.tinymediamanager.ui.panels.IModalPopupPanelProvider;
import org.tinymediamanager.ui.panels.MediaFileAudioStreamEditorPanel;
import org.tinymediamanager.ui.panels.ModalPopupPanel;

public abstract class MediaFileAudioStreamEditTable
extends TmmEditorTable {
    private final EventList<MediaFileAudioStream> audioStreamEventList;

    public MediaFileAudioStreamEditTable(EventList<MediaFileAudioStream> audioStreamEventList) {
        this.audioStreamEventList = audioStreamEventList;
        this.setModel((TableModel)((Object)new TmmTableModel<MediaFileAudioStream>((EventList<MediaFileAudioStream>)GlazedListsSwing.swingThreadProxyList(audioStreamEventList), new AudioStreamTableFormat())));
        this.adjustColumnPreferredWidths(3);
    }

    @Override
    protected void editButtonClicked(int row) {
        IModalPopupPanelProvider iModalPopupPanelProvider = IModalPopupPanelProvider.findModalProvider(this);
        if (iModalPopupPanelProvider == null) {
            return;
        }
        MediaFileAudioStream audioStream = this.getAudioStream(row);
        ModalPopupPanel popupPanel = iModalPopupPanelProvider.createModalPopupPanel();
        popupPanel.setTitle(TmmResourceBundle.getString("audiostream.edit"));
        popupPanel.setOnCloseHandler(this::onEditAudioStream);
        MediaFileAudioStreamEditorPanel audioStreamEditorPanel = new MediaFileAudioStreamEditorPanel(audioStream);
        popupPanel.setContent(audioStreamEditorPanel);
        iModalPopupPanelProvider.showModalPopupPanel(popupPanel);
    }

    public abstract void onEditAudioStream();

    private MediaFileAudioStream getAudioStream(int row) {
        int index = this.convertRowIndexToModel(row);
        return (MediaFileAudioStream)this.audioStreamEventList.get(index);
    }

    public List<MediaFileAudioStream> getAudioStreams() {
        ArrayList<MediaFileAudioStream> audioStreams = new ArrayList<MediaFileAudioStream>();
        for (int i : this.getSelectedRows()) {
            MediaFileAudioStream audioStream = this.getAudioStream(i);
            if (audioStream == null) continue;
            audioStreams.add(audioStream);
        }
        return audioStreams;
    }

    public void addAudioStream() {
        IModalPopupPanelProvider iModalPopupPanelProvider = IModalPopupPanelProvider.findModalProvider(this);
        if (iModalPopupPanelProvider == null) {
            return;
        }
        MediaFileAudioStream audioStream = new MediaFileAudioStream();
        ModalPopupPanel popupPanel = iModalPopupPanelProvider.createModalPopupPanel();
        popupPanel.setTitle(TmmResourceBundle.getString("audiostream.add"));
        popupPanel.setOnCloseHandler(() -> {
            this.audioStreamEventList.add((Object)audioStream);
            this.onAddAudioStream();
        });
        MediaFileAudioStreamEditorPanel audioStreamEditorPanel = new MediaFileAudioStreamEditorPanel(audioStream);
        popupPanel.setContent(audioStreamEditorPanel);
        iModalPopupPanelProvider.showModalPopupPanel(popupPanel);
    }

    public abstract void onAddAudioStream();

    private static class AudioStreamTableFormat
    extends TmmTableFormat<MediaFileAudioStream> {
        private AudioStreamTableFormat() {
            TmmTableFormat.Column col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.codec"), "codec", MediaStreamInfo::getCodec, String.class);
            col.setColumnResizeable(false);
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.channels"), "channels", MediaFileAudioStream::getAudioChannels, Integer.class);
            col.setColumnResizeable(false);
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.bitrate"), "bitrate", MediaFileAudioStream::getBitrate, Integer.class);
            col.setColumnResizeable(false);
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.bitdepth"), "bitdepth", MediaFileAudioStream::getBitDepth, Integer.class);
            col.setColumnResizeable(false);
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.language"), "language", MediaStreamInfo::getLanguage, String.class);
            col.setColumnResizeable(false);
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.default"), "default", MediaStreamInfo::isDefaultStream, Boolean.class);
            col.setColumnResizeable(false);
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.forced"), "forced", MediaStreamInfo::isForced, Boolean.class);
            col.setColumnResizeable(false);
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.title"), "title", MediaStreamInfo::getTitle, String.class);
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("Button.edit"), "edit", person -> IconManager.EDIT, ImageIcon.class);
            col.setColumnResizeable(false);
            col.setHeaderIcon(IconManager.EDIT_HEADER);
            this.addColumn(col);
        }
    }
}

