/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.thirdparty.yt;

import com.github.kiulian.downloader.YoutubeDownloader;
import com.github.kiulian.downloader.downloader.AbstractDownloader;
import com.github.kiulian.downloader.downloader.request.RequestWebpage;
import com.github.kiulian.downloader.downloader.response.ResponseImpl;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.regex.Matcher;
import okhttp3.Call;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.license.TmmFeature;
import org.tinymediamanager.scraper.exceptions.HttpException;
import org.tinymediamanager.scraper.http.TmmHttpClient;
import org.tinymediamanager.scraper.http.Url;

public class YtDownloader
extends YoutubeDownloader
implements TmmFeature {
    private static YtDownloader instance;

    public static void init() {
        instance = new YtDownloader();
    }

    public static YtDownloader getInstance() {
        if (instance == null) {
            YtDownloader.init();
        }
        return instance;
    }

    private YtDownloader() {
        this.setDownloader(new DownloaderImpl());
    }

    public String extractYoutubeId(String url) {
        if (StringUtils.isBlank((CharSequence)url)) {
            return "";
        }
        Matcher matcher = Utils.YOUTUBE_PATTERN.matcher(url);
        if (matcher.matches()) {
            return matcher.group(5);
        }
        return "";
    }

    class DownloaderImpl
    extends AbstractDownloader {
        DownloaderImpl() {
        }

        @Override
        public com.github.kiulian.downloader.downloader.response.Response<String> downloadWebpage(RequestWebpage requestWebpage) {
            if ("POST".equals(requestWebpage.getMethod())) {
                return this.post(requestWebpage);
            }
            return this.get(requestWebpage);
        }

        private com.github.kiulian.downloader.downloader.response.Response<String> get(RequestWebpage requestWebpage) {
            try {
                Url url = new Url(requestWebpage.getDownloadUrl().replace("{API_KEY}", YtDownloader.this.getApiKey()));
                if (requestWebpage.getHeaders() != null) {
                    for (Map.Entry<String, String> entry : requestWebpage.getHeaders().entrySet()) {
                        url.addHeader(entry.getKey(), entry.getValue());
                    }
                }
                String body = requestWebpage.getMaxRetries() != null ? new String(url.getBytesWithRetry(requestWebpage.getMaxRetries()), StandardCharsets.UTF_8) : new String(url.getBytes(), StandardCharsets.UTF_8);
                return ResponseImpl.from(body);
            }
            catch (Exception e) {
                return ResponseImpl.error(e);
            }
        }

        private com.github.kiulian.downloader.downloader.response.Response<String> post(RequestWebpage requestWebpage) {
            Call call = null;
            Response response = null;
            try {
                RequestBody body = RequestBody.create((String)requestWebpage.getBody(), (MediaType)MediaType.parse((String)"application/json"));
                Request.Builder builder = new Request.Builder().url(requestWebpage.getDownloadUrl().replace("{API_KEY}", YtDownloader.this.getApiKey())).post(body);
                if (requestWebpage.getHeaders() != null) {
                    for (Map.Entry<String, String> entry : requestWebpage.getHeaders().entrySet()) {
                        builder.addHeader(entry.getKey(), entry.getValue());
                    }
                }
                Request request = builder.build();
                call = TmmHttpClient.getHttpClient().newCall(request);
                response = call.execute();
                int responseCode = response.code();
                String responseMessage = response.message();
                if (responseCode < 200 || responseCode >= 400) {
                    throw new HttpException(requestWebpage.getBody(), responseCode, responseMessage);
                }
                return ResponseImpl.from(response.body().string());
            }
            catch (Exception e) {
                if (call != null) {
                    call.cancel();
                }
                if (response != null) {
                    response.close();
                }
                return ResponseImpl.error(e);
            }
        }
    }
}

