/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.thirdparty.yt;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.Globals;
import org.tinymediamanager.addon.YtDlpAddon;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.TmmProperties;
import org.tinymediamanager.core.threading.TmmTask;
import org.tinymediamanager.core.threading.TmmTaskHandle;
import org.tinymediamanager.thirdparty.FFmpeg;

public class YtDlp {
    private static final Logger LOGGER = LoggerFactory.getLogger(YtDlp.class);

    private YtDlp() {
        throw new IllegalAccessError();
    }

    public static void init() {
        YtDlpAddon ytDlpAddon = new YtDlpAddon();
        if (ytDlpAddon.isAvailable()) {
            LOGGER.info("yt-dlp is available at '{}'", (Object)ytDlpAddon.getExecutablePath());
        } else {
            LOGGER.warn("yt-dlp is not available");
        }
    }

    public static void downloadTrailer(String url, int height, Path trailerFile) throws IOException, InterruptedException {
        YtDlp.selfUpdateIfAvailable();
        YtDlp.executeCommand(YtDlp.createCommandForDownload(url, height, trailerFile));
    }

    private static List<String> createCommandForDownload(String url, int height, Path trailerFile) throws IOException {
        Path cookieFile;
        ArrayList<String> cmdList = new ArrayList<String>();
        cmdList.add(YtDlp.getYtDlpExecutable());
        if (FFmpeg.isAvailable()) {
            cmdList.add("--ffmpeg-location");
            cmdList.add(FFmpeg.getFfmpegExecutable());
        }
        if (Files.exists(cookieFile = Paths.get(Globals.DATA_FOLDER, "yt-dlp-cookies.txt"), new LinkOption[0])) {
            cmdList.add("--cookies");
            cmdList.add(cookieFile.toAbsolutePath().toString());
        }
        if (StringUtils.isNotBlank((CharSequence)Settings.getInstance().getYtDlpParams())) {
            StringTokenizer tokenizer = new StringTokenizer(Settings.getInstance().getYtDlpParams());
            while (tokenizer.hasMoreTokens()) {
                cmdList.add(tokenizer.nextToken());
            }
        } else {
            cmdList.add("-f");
            cmdList.add("bv*+ba/best");
            if (height > 0) {
                cmdList.add("-S");
                cmdList.add("res:" + height);
            }
            cmdList.add("--merge-output-format");
            cmdList.add("mkv");
            cmdList.add("--concurrent-fragments");
            cmdList.add("4");
            cmdList.add("--abort-on-unavailable-fragment");
            cmdList.add("--fragment-retries");
            cmdList.add("99");
        }
        if (Settings.getInstance().isIgnoreSSLProblems()) {
            cmdList.add("--no-check-certificates");
        }
        cmdList.add(url);
        cmdList.add("-P");
        cmdList.add(trailerFile.getParent().toAbsolutePath().toString());
        cmdList.add("-o");
        cmdList.add(trailerFile.getFileName().toString() + ".%(ext)s");
        return cmdList;
    }

    private static String executeCommand(List<String> cmdline) throws IOException, InterruptedException {
        LOGGER.debug("Running command: {}", (Object)String.join((CharSequence)" ", cmdline));
        ProcessBuilder pb = new ProcessBuilder(cmdline.toArray(new String[0])).redirectErrorStream(true);
        Process process = pb.start();
        try {
            String string;
            try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
                new Thread(() -> {
                    try {
                        IOUtils.copy((InputStream)process.getInputStream(), (OutputStream)outputStream);
                    }
                    catch (IOException e) {
                        LOGGER.debug("could not get output from the process", (Throwable)e);
                    }
                }).start();
                int processValue = process.waitFor();
                String response = outputStream.toString(StandardCharsets.UTF_8);
                if (processValue != 0) {
                    LOGGER.debug("Error calling yt-dlp - '{}' / '{}'", (Object)processValue, (Object)response);
                    throw new IOException(response);
                }
                string = response;
            }
            return string;
        }
        finally {
            process.destroy();
            IOUtils.close((Closeable)process.getErrorStream());
        }
    }

    public static boolean isAvailable() {
        YtDlpAddon ytDlpAddon = new YtDlpAddon();
        return ytDlpAddon.isAvailable();
    }

    private static String getYtDlpExecutable() throws IOException {
        YtDlpAddon ytDlpAddon = new YtDlpAddon();
        if (!Settings.getInstance().isUseInternalYtDlp() && StringUtils.isNotBlank((CharSequence)Settings.getInstance().getExternalYtDlpPath()) && Files.isExecutable(Paths.get(Settings.getInstance().getExternalYtDlpPath(), new String[0]))) {
            return Settings.getInstance().getExternalYtDlpPath();
        }
        if (ytDlpAddon.isAvailable()) {
            return ytDlpAddon.getExecutablePath();
        }
        throw new IOException("yt-dlp is not available");
    }

    public static void selfUpdateIfAvailable() {
        final YtDlpAddon ytDlpAddon = new YtDlpAddon();
        if (ytDlpAddon.isAvailable()) {
            String lastUpdateCheck = TmmProperties.getInstance().getProperty("lastYtDlpUpdateCheck", "0");
            long old = Long.parseLong(lastUpdateCheck);
            long now = new Date().getTime();
            if ((float)now > (float)old + 1.728E8f) {
                TmmTask upd = new TmmTask("YT-DLP", 1, TmmTaskHandle.TaskType.BACKGROUND_TASK){

                    @Override
                    protected void doInBackground() {
                        this.setTaskDescription("self updating YT-DLP...");
                        TmmProperties.getInstance().putProperty("lastYtDlpUpdateCheck", Long.toString(new Date().getTime()));
                        TmmProperties.getInstance().writeProperties();
                        try {
                            String response = YtDlp.executeCommand(List.of(ytDlpAddon.getExecutablePath(), "--update"));
                            LOGGER.debug(response);
                        }
                        catch (Exception e) {
                            LOGGER.warn("Error self-updating yt-dlp - '{}'", (Object)e.getMessage());
                        }
                    }
                };
                upd.run();
            }
        }
    }
}

