/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.thirdparty.upnp;

import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.lang3.StringUtils;
import org.jupnp.binding.annotations.UpnpService;
import org.jupnp.binding.annotations.UpnpServiceId;
import org.jupnp.binding.annotations.UpnpServiceType;
import org.jupnp.binding.annotations.UpnpStateVariable;
import org.jupnp.binding.annotations.UpnpStateVariables;
import org.jupnp.model.types.ErrorCode;
import org.jupnp.support.contentdirectory.AbstractContentDirectoryService;
import org.jupnp.support.contentdirectory.ContentDirectoryErrorCode;
import org.jupnp.support.contentdirectory.ContentDirectoryException;
import org.jupnp.support.contentdirectory.DIDLParser;
import org.jupnp.support.model.BrowseFlag;
import org.jupnp.support.model.BrowseResult;
import org.jupnp.support.model.DIDLContent;
import org.jupnp.support.model.DIDLObject;
import org.jupnp.support.model.SortCriterion;
import org.jupnp.support.model.container.Container;
import org.jupnp.support.model.container.GenreContainer;
import org.jupnp.support.model.container.StorageFolder;
import org.jupnp.support.model.item.Item;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaGenres;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;
import org.tinymediamanager.scraper.util.MetadataUtil;
import org.tinymediamanager.thirdparty.upnp.Metadata;

@UpnpService(serviceId=@UpnpServiceId(value="ContentDirectory"), serviceType=@UpnpServiceType(value="ContentDirectory"))
@UpnpStateVariables(value={@UpnpStateVariable(name="A_ARG_TYPE_ObjectID", sendEvents=false, datatype="string"), @UpnpStateVariable(name="A_ARG_TYPE_Result", sendEvents=false, datatype="string"), @UpnpStateVariable(name="A_ARG_TYPE_BrowseFlag", sendEvents=false, datatype="string", allowedValuesEnum=BrowseFlag.class), @UpnpStateVariable(name="A_ARG_TYPE_Filter", sendEvents=false, datatype="string"), @UpnpStateVariable(name="A_ARG_TYPE_SortCriteria", sendEvents=false, datatype="string"), @UpnpStateVariable(name="A_ARG_TYPE_Index", sendEvents=false, datatype="ui4"), @UpnpStateVariable(name="A_ARG_TYPE_Count", sendEvents=false, datatype="ui4"), @UpnpStateVariable(name="A_ARG_TYPE_UpdateID", sendEvents=false, datatype="ui4"), @UpnpStateVariable(name="A_ARG_TYPE_URI", sendEvents=false, datatype="uri"), @UpnpStateVariable(name="A_ARG_TYPE_SearchCriteria", sendEvents=false, datatype="string")})
public class ContentDirectoryService
extends AbstractContentDirectoryService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContentDirectoryService.class);
    private StorageFolder cdsTree = null;

    public ContentDirectoryService() {
    }

    public ContentDirectoryService(List<String> searchCapabilities, List<String> sortCapabilities) {
        super(searchCapabilities, sortCapabilities);
    }

    private void createTreeIfNull() {
        if (this.cdsTree == null) {
            Object gc;
            StorageFolder uRoot = new StorageFolder("0", "-1", "All", "", Integer.valueOf(0), Long.valueOf(0L));
            StorageFolder uMovies = new StorageFolder("1", (Container)uRoot, TmmResourceBundle.getString("tmm.movies"), "", Integer.valueOf(0), Long.valueOf(0L));
            List<Movie> movies = MovieModuleManager.getInstance().getMovieList().getMovies();
            movies.sort((m1, m2) -> String.CASE_INSENSITIVE_ORDER.compare(m1.getTitleSortable(), m2.getTitleSortable()));
            StorageFolder grpTitles = new StorageFolder(uMovies.getId() + "/t", (Container)uMovies, TmmResourceBundle.getString("metatag.title"), "", Integer.valueOf(MovieModuleManager.getInstance().getMovieList().getMovieCount()), Long.valueOf(0L));
            for (Movie movie : movies) {
                org.jupnp.support.model.item.Movie um = Metadata.getUpnpMovie(movie, false);
                um.setId(grpTitles.getId() + "/" + um.getId());
                um.setParentID(grpTitles.getId());
                grpTitles.addItem((Item)um);
            }
            uMovies.addContainer((Container)grpTitles);
            Collection<MediaGenres> mgs = MovieModuleManager.getInstance().getMovieList().getUsedGenres();
            GenreContainer grpGenres = new GenreContainer(uMovies.getId() + "/g", (Container)uMovies, TmmResourceBundle.getString("metatag.genre"), "", Integer.valueOf(mgs.size()));
            for (MediaGenres mg : mgs) {
                gc = new GenreContainer(grpGenres.getId() + "/" + mg.getLocalizedName(), (Container)grpGenres, mg.getLocalizedName(), "", Integer.valueOf(0));
                for (Movie movie : movies) {
                    if (!movie.getGenres().contains(mg)) continue;
                    org.jupnp.support.model.item.Movie um = Metadata.getUpnpMovie(movie, false);
                    um.setId(gc.getId() + "/" + um.getId());
                    um.setParentID(gc.getId());
                    gc.addItem((Item)um);
                }
                gc.setChildCount(Integer.valueOf(gc.getContainers().size() + gc.getItems().size()));
                grpGenres.addContainer((Container)gc);
            }
            uMovies.addContainer((Container)grpGenres);
            ArrayList<Integer> years = new ArrayList<Integer>(MovieModuleManager.getInstance().getMovieList().getYearsInMovies());
            Collections.sort(years, Collections.reverseOrder());
            StorageFolder grpYear = new StorageFolder(uMovies.getId() + "/y", (Container)uMovies, TmmResourceBundle.getString("metatag.year"), "", Integer.valueOf(years.size()), Long.valueOf(0L));
            gc = years.iterator();
            while (gc.hasNext()) {
                int year = (Integer)gc.next();
                StorageFolder yc = new StorageFolder(grpYear.getId() + "/" + year, (Container)grpYear, "" + year, "", Integer.valueOf(0), Long.valueOf(0L));
                for (Movie movie : movies) {
                    if (movie.getYear() != year) continue;
                    org.jupnp.support.model.item.Movie um = Metadata.getUpnpMovie(movie, false);
                    um.setId(yc.getId() + "/" + um.getId());
                    um.setParentID(yc.getId());
                    yc.addItem((Item)um);
                }
                yc.setChildCount(Integer.valueOf(yc.getContainers().size() + yc.getItems().size()));
                grpYear.addContainer((Container)yc);
            }
            uMovies.addContainer((Container)grpYear);
            uMovies.setChildCount(Integer.valueOf(uMovies.getContainers().size() + uMovies.getItems().size()));
            uRoot.addContainer((Container)uMovies);
            StorageFolder uTvShows = new StorageFolder("2", (Container)uRoot, TmmResourceBundle.getString("tmm.tvshows"), "", Integer.valueOf(TvShowModuleManager.getInstance().getTvShowList().getTvShowCount()), Long.valueOf(0L));
            List<TvShow> tmmShows = TvShowModuleManager.getInstance().getTvShowList().getTvShows();
            tmmShows.sort((t1, t2) -> String.CASE_INSENSITIVE_ORDER.compare(t1.getTitleSortable(), t2.getTitleSortable()));
            for (TvShow t : tmmShows) {
                StorageFolder uTvShow = new StorageFolder("2/" + t.getDbId(), (Container)uTvShows, t.getTitle(), "", Integer.valueOf(t.getSeasonCount()), Long.valueOf(0L));
                for (TvShowSeason s : t.getSeasons()) {
                    StorageFolder uSeason = new StorageFolder(uTvShow.getId() + "/" + s.getSeason(), (Container)uTvShow, "Season " + s.getSeason(), "", Integer.valueOf(t.getEpisodeCount()), Long.valueOf(0L));
                    for (TvShowEpisode ep : s.getEpisodes()) {
                        org.jupnp.support.model.item.Movie um = Metadata.getUpnpTvShowEpisode(t, ep, false);
                        uSeason.addItem((Item)um);
                    }
                    uTvShow.addContainer((Container)uSeason);
                }
                uTvShows.addContainer((Container)uTvShow);
            }
            uRoot.addContainer((Container)uTvShows);
            uRoot.setChildCount(Integer.valueOf(uRoot.getContainers().size()));
            this.cdsTree = uRoot;
        }
    }

    public BrowseResult browse(String objectID, BrowseFlag browseFlag, String filter, long firstResult, long maxResults, SortCriterion[] orderby) throws ContentDirectoryException {
        try {
            LOGGER.debug("ObjectId: {}", (Object)objectID);
            LOGGER.debug("BrowseFlag: {}", (Object)browseFlag);
            LOGGER.debug("Filter: {}", (Object)filter);
            LOGGER.debug("FirstResult: {}", (Object)firstResult);
            LOGGER.debug("MaxResults: {}", (Object)maxResults);
            LOGGER.debug("OrderBy: {}", (Object)SortCriterion.toString((SortCriterion[])orderby));
            this.createTreeIfNull();
            DIDLContent didl = new DIDLContent();
            String[] path = StringUtils.split((String)objectID, (char)'/');
            if (path == null) {
                throw new ContentDirectoryException(ContentDirectoryErrorCode.CANNOT_PROCESS, "path was NULL");
            }
            String request = path[path.length - 1];
            String parent = "";
            if (objectID.contains("/")) {
                parent = objectID.substring(0, objectID.lastIndexOf("/"));
            }
            if (browseFlag.equals((Object)BrowseFlag.METADATA)) {
                DIDLObject obj = this.findId(objectID, this.cdsTree);
                if (obj instanceof Container) {
                    didl.addContainer((Container)obj);
                } else if (obj instanceof Item) {
                    TvShowEpisode ep;
                    TvShow t;
                    Item item = (Item)obj;
                    if (path[0].equals("1") && this.isUUID(request)) {
                        Movie m = MovieModuleManager.getInstance().getMovieList().findByDbId(UUID.fromString(request)).orElse(null);
                        if (m != null) {
                            org.jupnp.support.model.item.Movie um = Metadata.getUpnpMovie(m, true);
                            um.setId(parent + "/" + um.getId());
                            um.setParentID(parent);
                            item = um;
                        }
                    } else if (path[0].equals("2") && path.length == 4 && (t = TvShowModuleManager.getInstance().getTvShowList().lookupTvShow(UUID.fromString(path[1]))) != null && (ep = (TvShowEpisode)t.getEpisode(this.getInt(path[2]), this.getInt(path[3])).stream().findFirst().orElse(null)) != null) {
                        item = Metadata.getUpnpTvShowEpisode(t, ep, true);
                    }
                    didl.addItem(item);
                }
                return this.returnResult(didl, 1L);
            }
            if (browseFlag.equals((Object)BrowseFlag.DIRECT_CHILDREN)) {
                DIDLObject obj = this.findId(objectID, this.cdsTree);
                long total = 0L;
                if (obj instanceof Container) {
                    Container cont = (Container)obj;
                    didl = this.createContentDidl(cont, firstResult, maxResults);
                    total = (long)cont.getContainers().size() + (long)cont.getItems().size();
                }
                return this.returnResult(didl, total);
            }
            throw new ContentDirectoryException(ContentDirectoryErrorCode.NO_SUCH_OBJECT, "BrowseFlag wrong " + browseFlag);
        }
        catch (Exception ex) {
            LOGGER.debug("Browse failed", (Throwable)ex);
            throw new ContentDirectoryException(ContentDirectoryErrorCode.CANNOT_PROCESS, ex.toString());
        }
    }

    private DIDLObject findId(String id, StorageFolder folder) {
        StorageFolder ret = folder;
        String[] path = id.split("/");
        Object parent = "";
        for (int i = 0; i < path.length; ++i) {
            String s = path[i];
            ret = this.getTreeObject((String)parent + s, (DIDLObject)ret);
            parent = (String)parent + s + "/";
            if (ret == null) break;
        }
        return ret;
    }

    private DIDLObject getTreeObject(String id, DIDLObject obj) {
        Container ret = null;
        if (id.equalsIgnoreCase(obj.getId())) {
            return obj;
        }
        if (obj instanceof Container) {
            for (Container c : ((Container)obj).getContainers()) {
                if (!c.getId().equalsIgnoreCase(id)) continue;
                ret = c;
                break;
            }
            for (Item i : ((Container)obj).getItems()) {
                if (!i.getId().equalsIgnoreCase(id)) continue;
                ret = i;
                break;
            }
        }
        return ret;
    }

    private boolean isUUID(String uuid) {
        return uuid.length() == 36;
    }

    private DIDLContent createContentDidl(Container cont, long firstResult, long maxResults) {
        DIDLContent didl = new DIDLContent();
        int cnt = 0;
        for (Container c : cont.getContainers()) {
            if (firstResult > 0L) {
                --firstResult;
                continue;
            }
            if (maxResults != 0L && (long)cnt >= maxResults) continue;
            didl.addContainer(c);
            ++cnt;
        }
        for (Item i : cont.getItems()) {
            if (firstResult > 0L) {
                --firstResult;
                continue;
            }
            if (maxResults != 0L && (long)cnt >= maxResults) continue;
            didl.addItem(i);
            ++cnt;
        }
        return didl;
    }

    private BrowseResult returnResult(DIDLContent didl, long total) throws Exception {
        DIDLParser dip = new DIDLParser();
        String ret = dip.generate(didl);
        LOGGER.trace(ContentDirectoryService.prettyFormat(ret, 2));
        return new BrowseResult(ret, didl.getCount(), total);
    }

    private int getInt(String s) {
        return MetadataUtil.parseInt(s, 0);
    }

    public BrowseResult search(String containerId, String searchCriteria, String filter, long firstResult, long maxResults, SortCriterion[] orderBy) throws ContentDirectoryException {
        try {
            return new BrowseResult(new DIDLParser().generate(new DIDLContent()), 0L, 0L);
        }
        catch (Exception e) {
            throw new ContentDirectoryException(ErrorCode.ACTION_FAILED, e.toString());
        }
    }

    public static String prettyFormat(String input, int indent) {
        try {
            StreamSource xmlInput = new StreamSource(new StringReader(input));
            StringWriter stringWriter = new StringWriter();
            StreamResult xmlOutput = new StreamResult(stringWriter);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setAttribute("indent-number", indent);
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(xmlInput, xmlOutput);
            return xmlOutput.getWriter().toString();
        }
        catch (Exception e) {
            return "! error parsing xml !";
        }
    }
}

