/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.kodi;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.text.translate.UnicodeUnescaper;
import org.jsoup.Jsoup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.scraper.exceptions.HttpException;
import org.tinymediamanager.scraper.kodi.Expression;
import org.tinymediamanager.scraper.kodi.KodiScraper;
import org.tinymediamanager.scraper.kodi.KodiUrl;
import org.tinymediamanager.scraper.kodi.KodiUtil;
import org.tinymediamanager.scraper.kodi.RegExp;
import org.tinymediamanager.scraper.kodi.ScraperFunction;

class KodiScraperProcessor {
    public static final String FUNCTION_SETTINGS = "GetSettings";
    private static final Logger LOGGER = LoggerFactory.getLogger(KodiScraperProcessor.class);
    private static final int PATTERN_OPTIONS = 42;
    private boolean truncateLogging = true;
    private KodiScraper scraper = null;
    private String[] buffers = new String[21];
    private final UnicodeUnescaper uu = new UnicodeUnescaper();

    public KodiScraperProcessor(KodiScraper scraper) {
        if (scraper == null) {
            throw new RuntimeException("Scraper cannot be null!");
        }
        this.scraper = scraper;
        LOGGER.debug("KodiScraperProcessor created using Scraper: " + scraper + "; Complete Logging: " + !this.truncateLogging);
        this.clearBuffers();
    }

    private KodiScraperProcessor(KodiScraper scraper, String[] buffers) {
        this.scraper = scraper;
        if (buffers != null) {
            for (int i = 0; i < buffers.length; ++i) {
                this.buffers[i] = buffers[i];
            }
        } else {
            this.clearBuffers();
        }
    }

    public String executeFunction(String function, String[] input) {
        ScraperFunction func = this.scraper.getFunction(function);
        if (func != null) {
            func = this.scraper.getFunction(function).clone();
            LOGGER.trace("** BEGIN Function: " + func.getName() + "; Dest: " + func.getDest() + "; ClearBuffers: " + func.isClearBuffers());
            if (func.isClearBuffers()) {
                this.clearBuffers();
            }
            this.setBuffers(input);
            this.executeRegexps(func.getRegExps());
            LOGGER.trace("** END Function: " + func.getName() + "; Dest: " + func.getDest() + "; ClearBuffers: " + func.isClearBuffers());
            return this.getBuffer(func.getDest());
        }
        LOGGER.debug("** Could not locate Function: " + function + " in the scraper " + this.scraper.getProviderInfo().getId());
        return "";
    }

    private void executeRegexps(RegExp[] regExps) {
        int i = 0;
        for (RegExp r : regExps) {
            LOGGER.trace(String.format("Executing Regex " + ++i + "/" + regExps.length + ": %s; Dest: %s; Input: %s; Output: %s", r.getExpression(), r.getDest(), r.getInput(), r.getOutput()));
            this.executeRegexp(r);
        }
    }

    private void executeRegexp(RegExp regex) {
        String cond = regex.getConditional();
        if (cond != null && !cond.isEmpty()) {
            boolean b2;
            Boolean b;
            boolean not = cond.startsWith("!");
            if (not) {
                cond = cond.substring(1);
            }
            b = (b = Boolean.valueOf(this.scraper.getProviderInfo().getConfig().getValueAsBool(cond))) == null || b != false;
            LOGGER.trace("Processing Conditional: {} > {}", (Object)regex.getConditional(), (Object)(not ? !b.booleanValue() : b));
            boolean bl = b2 = b == null || b == true;
            if (!(b2 || not && !b2)) {
                LOGGER.trace("Condition Not Met: {} > {}", (Object)regex.getConditional(), (Object)b2);
                return;
            }
        }
        if (regex.hasRegExps()) {
            this.executeRegexps(regex.getRegExps());
        }
        this.executeExpression(regex);
    }

    private void executeExpression(RegExp r) {
        this.logCurrentBuffers();
        Expression exp = r.getExpression();
        String in = this.getBuffer(r.getInput());
        if (in == null) {
            in = "";
        }
        if (exp == null) {
            LOGGER.debug("Main Expression was empty.  Returning processed output buffer using input as replacement array.");
            this.setBuffer(r.getDest(), this.processOutputBuffers(r.getOutput(), new String[]{"", in}), r.isAppendBuffer());
            return;
        }
        String expr = exp.getExpression();
        if (expr == null || expr.strip().length() == 0) {
            LOGGER.debug("Expression was empty.  Returning processed output buffer using input as replacement array.");
            this.setBuffer(r.getDest(), this.processOutputBuffers(r.getOutput(), new String[]{"", in}), r.isAppendBuffer());
            return;
        }
        LOGGER.trace("Expression: <" + expr);
        expr = this.processOutputBuffersForPropertyReferences(this.processOutputBuffersForInputBufferReferences(expr));
        LOGGER.trace("Expression: >" + expr);
        LOGGER.trace("     Input: " + this.logBuffer(in));
        Pattern p = null;
        try {
            p = Pattern.compile(expr, 42);
        }
        catch (Exception e) {
            LOGGER.trace("Could not compile regex: " + e.getMessage() + " - trying quoted instead");
            p = Pattern.compile(Pattern.quote(expr), 42);
        }
        Matcher m = p.matcher(in);
        if (m.find()) {
            LOGGER.trace("Matched: Group Count: " + m.groupCount());
            this.setBuffer(r.getDest(), this.processOutputBuffers(r.getOutput(), this.toGroupArray(exp.getNoCleanArray(), m)), r.isAppendBuffer());
            if (exp.isRepeat()) {
                while (m.find()) {
                    LOGGER.trace("Repeat Matched. Group Count: " + m.groupCount());
                    this.setBuffer(r.getDest(), this.processOutputBuffers(r.getOutput(), this.toGroupArray(exp.getNoCleanArray(), m)), true);
                }
            }
        } else {
            LOGGER.trace(String.format("No Match! Expression: %s; Text: %s;", expr, this.logBuffer(in)));
            if (exp.isClear()) {
                LOGGER.trace("Clearing Destination Buffer: " + r.getDest());
                this.setBuffer(r.getDest(), "", false);
            }
        }
    }

    private String logBuffer(String in) {
        if (!LOGGER.isDebugEnabled()) {
            return in;
        }
        if (this.isTruncateLogging() && in != null && ((String)in).length() > 200) {
            in = "TRUNCATED(200): " + ((String)in).substring(0, 200) + "...";
        }
        return in;
    }

    private String[] toGroupArray(String[] noCleanArray, Matcher groups) {
        int c = groups.groupCount();
        String[] g = new String[c + 1];
        for (int i = 0; i <= c; ++i) {
            g[i] = noCleanArray != null && noCleanArray[i] != null ? groups.group(i) : this.cleanHtml(groups.group(i));
        }
        return g;
    }

    private String cleanHtml(String group) {
        if (group == null) {
            return "";
        }
        LOGGER.trace("Before Clean Html: " + group);
        String s = Jsoup.parse((String)this.uu.translate((CharSequence)group)).body().text();
        LOGGER.trace("After  Clean Html: " + s);
        return s;
    }

    private String processOutputBuffers(String output, String[] groups) {
        Pattern p = Pattern.compile("\\\\([0-9])");
        Matcher m = p.matcher(output);
        StringBuffer sb = new StringBuffer();
        int lastStart = 0;
        while (m.find()) {
            LOGGER.trace("Processing output buffer replacement ");
            sb.append(output.substring(lastStart, m.start()));
            lastStart = m.end();
            int g = Integer.parseInt(m.group(1));
            if (g > groups.length) {
                LOGGER.trace("No Group Replacement for: " + g);
                continue;
            }
            int index = Integer.parseInt(m.group(1));
            String val = "";
            if (index < groups.length) {
                val = groups[index];
            }
            if (val == null) {
                val = "";
            }
            LOGGER.trace("Replace '\\" + m.group(1) + "' with '" + val + "'");
            sb.append(val);
        }
        sb.append(output.substring(lastStart));
        return this.processOutputBuffersForPropertyReferences(this.processOutputBuffersForInputBufferReferences(sb.toString()));
    }

    private String processOutputBuffersForInputBufferReferences(String output) {
        Pattern p = Pattern.compile("\\$\\$([0-9]+)");
        Matcher m = p.matcher(output);
        StringBuffer sb = new StringBuffer();
        int lastStart = 0;
        while (m.find()) {
            sb.append(output.substring(lastStart, m.start()));
            lastStart = m.end();
            LOGGER.trace("replacing input reference '" + m.group(1) + "' with '" + this.getBuffer(Integer.parseInt(m.group(1))) + "'");
            sb.append(this.getBuffer(Integer.parseInt(m.group(1))));
        }
        sb.append(output.substring(lastStart));
        return sb.toString();
    }

    private String processOutputBuffersForPropertyReferences(String output) {
        Pattern p = Pattern.compile("\\$INFO\\[([^\\]]+)\\]");
        Matcher m = p.matcher(output);
        StringBuffer sb = new StringBuffer();
        int lastStart = 0;
        while (m.find()) {
            sb.append(output.substring(lastStart, m.start()));
            lastStart = m.end();
            LOGGER.trace("replacing property reference '" + m.group(1) + "' with '" + this.scraper.getProviderInfo().getConfig().getValue(m.group(1)) + "'");
            sb.append(this.scraper.getProviderInfo().getConfig().getValue(m.group(1)));
        }
        sb.append(output.substring(lastStart));
        return sb.toString();
    }

    private String getBuffer(int buffer) {
        String text = this.buffers[buffer];
        if (text == null) {
            text = "";
        }
        text = KodiUtil.fixXmlHeader(text);
        text = KodiUtil.fixScripts(text);
        text = this.processOutputBuffersForPropertyReferences(text);
        LOGGER.trace("Get Int Buffer: " + buffer + "; Text: " + this.logBuffer(text));
        return text;
    }

    private String getBuffer(String buffer) {
        if (buffer == null) {
            buffer = "";
        }
        buffer = KodiUtil.fixXmlHeader(buffer);
        buffer = KodiUtil.fixScripts(buffer);
        buffer = this.processOutputBuffersForPropertyReferences(buffer);
        LOGGER.trace(String.format("Get String Buffer: %s", buffer));
        Pattern bufferPattern = Pattern.compile("\\$\\$([0-9]+)");
        Matcher m = bufferPattern.matcher(buffer);
        if (m.find()) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.getBuffer(Integer.parseInt(m.group(1))));
            while (m.find()) {
                sb.append(this.getBuffer(Integer.parseInt(m.group(1))));
            }
            return sb.toString();
        }
        LOGGER.trace("getBuffer(): Using raw input: " + this.logBuffer(buffer));
        return buffer;
    }

    private void setBuffer(int buffer, String text, boolean append) {
        String s;
        if (text == null) {
            text = "";
        }
        LOGGER.trace(String.format("Set Buffer: %s; Append: %s; Text: %s", buffer, append, this.logBuffer((String)text)));
        Pattern p = Pattern.compile("<url\\s+.*function=");
        Matcher m = p.matcher((CharSequence)text);
        if (m.find()) {
            LOGGER.debug("Processing Sub Function URL: " + (String)text);
            try {
                KodiUrl url = new KodiUrl((String)text);
                ScraperFunction func = this.scraper.getFunction(url.getFunctionName());
                if (func == null) {
                    throw new Exception("Invalid Function Name: " + url.getFunctionName());
                }
                func = this.scraper.getFunction(url.getFunctionName()).clone();
                KodiScraperProcessor proc = this.newSubProcessor(func.isClearBuffers());
                text = proc.executeFunction(url.getFunctionName(), new String[]{"", url.getTextContent()});
            }
            catch (HttpException e) {
                LOGGER.debug("Failed to process function: '{}' - HTTP: '{}'", text, (Object)e.getStatusCode());
                text = "";
            }
            catch (Exception e) {
                LOGGER.debug("Failed to process function: " + (String)text, (Throwable)e);
                text = "";
            }
        }
        if ((m = (p = Pattern.compile("<chain function=\"(.*)\">(.*)</chain>")).matcher((CharSequence)text)).find()) {
            LOGGER.debug("Processing Sub Function CHAIN: " + (String)text);
            try {
                ScraperFunction func = this.scraper.getFunction(m.group(1));
                if (func == null) {
                    throw new Exception("Invalid Function Name: " + m.group(1));
                }
                func = this.scraper.getFunction(m.group(1)).clone();
                KodiScraperProcessor proc = this.newSubProcessor(func.isClearBuffers());
                text = "<" + m.group(1) + ">" + proc.executeFunction(m.group(1), new String[]{"", m.group(2)}) + "</" + m.group(1) + ">";
            }
            catch (Exception e) {
                LOGGER.debug("Failed to process function: " + (String)text, (Throwable)e);
                text = "\n<error>" + (String)text + "\n<msg>" + e.getMessage() + "</msg></error>\n";
            }
        }
        if (append && (s = this.buffers[buffer]) != null) {
            text = s + (String)text;
            LOGGER.trace("Appending to buffer {}: {}", (Object)buffer, text);
        }
        this.buffers[buffer] = text;
    }

    public void clearBuffers() {
        for (int i = 0; i < this.buffers.length; ++i) {
            this.setBuffer(i, "", false);
        }
    }

    public void logCurrentBuffers() {
        LOGGER.trace("============================================================");
        for (int i = 0; i < this.buffers.length; ++i) {
            LOGGER.trace("===  " + i + ":  " + this.logBuffer(this.buffers[i]));
        }
        LOGGER.trace("============================================================");
    }

    private void setBuffers(String[] input) {
        if (input == null) {
            return;
        }
        LOGGER.trace("Set Buffers: # of input Buffers: " + input.length);
        for (int i = 0; i < input.length; ++i) {
            if (input[i] == null) continue;
            this.setBuffer(i, input[i], false);
        }
    }

    public boolean containsFunction(String functionName) {
        return this.scraper.containsFunction(functionName);
    }

    public KodiScraper getScraper() {
        return this.scraper;
    }

    public boolean isTruncateLogging() {
        return this.truncateLogging;
    }

    public void setTruncateLogging(boolean truncateLogging) {
        this.truncateLogging = truncateLogging;
    }

    public KodiScraperProcessor newSubProcessor(boolean clearBuffers) {
        return new KodiScraperProcessor(this.scraper, clearBuffers ? null : this.buffers);
    }
}

