/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.library.bluray.index;

import jakarta.xml.bind.annotation.XmlType;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.tinymediamanager.library.bluray.index.IndexObject;
import org.tinymediamanager.library.bluray.index.StringIOHelper;

@XmlType(name="BDJIndexObject")
public class BDJIndexObject
extends IndexObject {
    BDJPlaybackType type;
    String bdjoName;
    IndexObject.IndexObjectType objectType = IndexObject.IndexObjectType.V_10;

    public void setBDJOName(String string) {
        this.bdjoName = string;
    }

    public String getBDJOName() {
        return this.bdjoName;
    }

    public void setPlaybackType(BDJPlaybackType bDJPlaybackType) {
        this.type = bDJPlaybackType;
    }

    public BDJPlaybackType getPlaybackType() {
        return this.type;
    }

    @Override
    public void readObject(DataInputStream dataInputStream) throws IOException {
        byte by = dataInputStream.readByte();
        dataInputStream.skipBytes(1);
        String string = StringIOHelper.readISO646String(dataInputStream, 5);
        dataInputStream.skipBytes(1);
        int n = (by & 0xC0) >> 6;
        BDJPlaybackType[] bDJPlaybackTypeArray = BDJPlaybackType.values();
        for (int i = 0; i < bDJPlaybackTypeArray.length; ++i) {
            if (bDJPlaybackTypeArray[i].ordinal() != n) continue;
            this.setPlaybackType(bDJPlaybackTypeArray[i]);
            break;
        }
        this.setBDJOName(string);
    }

    @Override
    public void writeObject(DataOutputStream dataOutputStream) throws IOException {
        int n = this.getPlaybackType().ordinal() << 6;
        byte[] byArray = new byte[1];
        dataOutputStream.writeByte(n);
        dataOutputStream.write(byArray);
        dataOutputStream.write(StringIOHelper.getISO646Bytes(this.getBDJOName()));
        dataOutputStream.write(byArray);
    }

    @Override
    public IndexObject.IndexObjectType getObjectType() {
        return this.objectType;
    }

    public static enum BDJPlaybackType {
        BDJPlayback_RESERVED,
        BDJPlayback_RESERVED2,
        BDJPlayback_MOVIE,
        BDJPlayback_INTERACTIVE;


        public byte getEncoding() {
            return (byte)this.ordinal();
        }
    }
}

