/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.jmte;

import com.floreysoft.jmte.NamedRenderer;
import com.floreysoft.jmte.RenderFormatInfo;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.Locale;
import java.util.Map;

public class NamedFramerateRenderer
implements NamedRenderer {
    public String render(Object o, String s, Locale locale, Map<String, Object> map) {
        boolean isInt;
        if (!(o instanceof Number)) {
            return "";
        }
        double frameRate = (Double)o;
        if ("round".equalsIgnoreCase(s)) {
            frameRate = this.round(frameRate, 0);
        }
        DecimalFormat format = new DecimalFormat("0.###");
        boolean bl = isInt = Math.floor(frameRate) == frameRate;
        if (isInt) {
            format = new DecimalFormat("0");
        }
        try {
            return format.format(o);
        }
        catch (Exception e) {
            return "";
        }
    }

    private double round(double value, int places) {
        BigDecimal bd = new BigDecimal(Double.toString(value));
        return bd.setScale(places, RoundingMode.HALF_UP).doubleValue();
    }

    public String getName() {
        return "framerate";
    }

    public RenderFormatInfo getFormatInfo() {
        return null;
    }

    public Class<?>[] getSupportedClasses() {
        return new Class[]{Integer.class, Float.class, Double.class};
    }
}

