/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.Globals;
import org.tinymediamanager.TinyMediaManager;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.mediainfo.MediaInfoUtils;
import org.tinymediamanager.thirdparty.MediaInfo;

public class TmmOsUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(TmmOsUtils.class);
    public static final String DESKTOP_FILE = "tinyMediaManager.desktop";

    private TmmOsUtils() {
        throw new IllegalAccessError();
    }

    public static boolean existsDesktopFileForLinux() {
        if (SystemUtils.IS_OS_WINDOWS || SystemUtils.IS_OS_MAC) {
            return false;
        }
        String currentUsersHomeDir = System.getProperty("user.home");
        for (Path path : Arrays.asList(Paths.get(currentUsersHomeDir, ".local", "share", "applications", DESKTOP_FILE).toAbsolutePath(), Paths.get("/", "usr", "local", "share", "applications", DESKTOP_FILE).toAbsolutePath(), Paths.get("/", "usr", "share", "applications", DESKTOP_FILE).toAbsolutePath())) {
            if (!path.toFile().exists()) continue;
            return true;
        }
        return false;
    }

    public static void createDesktopFileForLinux(File desktop) {
        if (SystemUtils.IS_OS_WINDOWS || SystemUtils.IS_OS_MAC) {
            return;
        }
        String path = new File(TinyMediaManager.class.getProtectionDomain().getCodeSource().getLocation().getPath()).getParent();
        path = URLDecoder.decode(path, StandardCharsets.UTF_8);
        StringBuilder sb = new StringBuilder(60);
        sb.append("[Desktop Entry]\n");
        sb.append("Type=Application\n");
        sb.append("Name=tinyMediaManager\n");
        sb.append("Path=");
        sb.append(path);
        sb.append('\n');
        sb.append("Exec=/bin/sh -c \"");
        sb.append(path);
        sb.append("/tinyMediaManager\"\n");
        sb.append("Icon=");
        sb.append(path);
        sb.append("/tmm.png\n");
        sb.append("Categories=AudioVideo;Video;Database;Java;\n");
        sb.append("StartupWMClass=org-tinymediamanager-TinyMediaManager\n");
        sb.append("\n");
        try {
            Path parent = desktop.toPath().getParent();
            if (parent != null) {
                try {
                    Files.createDirectories(parent, new FileAttribute[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try (BufferedWriter writer = Files.newBufferedWriter(desktop.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
                writer.write(sb.toString());
                if (!desktop.setExecutable(true)) {
                    LOGGER.warn("Could not set executable bit for '{}'", (Object)desktop.getName());
                }
            }
        }
        catch (IOException e) {
            LOGGER.warn("Could not create .desktop file - '{}'", (Object)e.getMessage());
        }
    }

    public static ProcessBuilder getPBforTMMrestart() {
        ProcessBuilder pb;
        Path tmmExecutable;
        if (SystemUtils.IS_OS_WINDOWS) {
            tmmExecutable = Paths.get("tinyMediaManager.exe", new String[0]);
            pb = new ProcessBuilder("cmd", "/c", "start", tmmExecutable.toAbsolutePath().getFileName().toString());
        } else if (SystemUtils.IS_OS_MAC) {
            tmmExecutable = Paths.get("../../MacOS/tinyMediaManager", new String[0]);
            pb = new ProcessBuilder("/usr/bin/nohup", "/bin/sh", "-c", "./" + tmmExecutable.toAbsolutePath().getFileName().toString());
        } else {
            tmmExecutable = Paths.get("tinyMediaManager", new String[0]);
            pb = new ProcessBuilder("/usr/bin/nohup", "/bin/sh", "-c", "./" + tmmExecutable.toAbsolutePath().getFileName().toString());
        }
        pb.directory(tmmExecutable.toAbsolutePath().getParent().toAbsolutePath().toFile());
        pb.redirectOutput(new File(SystemUtils.IS_OS_WINDOWS ? "NUL" : "/dev/null")).redirectErrorStream(true);
        return pb;
    }

    public static void loadNativeLibs() {
        String miv;
        String nativepath = TmmOsUtils.getNativeFolderName();
        Path tmmNativeDir = Paths.get(nativepath, new String[0]).toAbsolutePath();
        boolean loaded = false;
        if (SystemUtils.IS_OS_WINDOWS) {
            try {
                Path tmpDir = Paths.get(System.getProperty("java.io.tmpdir"), "tmm");
                Path nativeDir = tmpDir.resolve(nativepath).toAbsolutePath();
                Utils.copyDirectoryRecursive(tmmNativeDir, nativeDir);
                if (!Files.exists(nativeDir, new LinkOption[0]) || Utils.isFolderEmpty(nativeDir)) {
                    throw new FileNotFoundException(nativeDir.toString());
                }
                System.setProperty("jna.library.path", nativeDir.toString());
                LOGGER.debug("Loading native libs from: {}", (Object)nativeDir);
                loaded = true;
            }
            catch (Exception e) {
                LOGGER.warn("Could not copy native libs to the temp folder - '{}' -> try to load from install dir", (Object)e.getMessage());
            }
        }
        if (!loaded) {
            System.setProperty("jna.library.path", tmmNativeDir.toString());
            LOGGER.debug("Loading native libs from: {}", (Object)tmmNativeDir);
        }
        if (MediaInfoUtils.useMediaInfo() && !StringUtils.isEmpty((CharSequence)(miv = MediaInfo.version()))) {
            LOGGER.info("Using libmediainfo version '{}'", (Object)miv);
        }
    }

    public static String getNativeFolderName() {
        Object nativepath = "native/";
        if (SystemUtils.IS_OS_WINDOWS) {
            nativepath = (String)nativepath + "windows";
        } else if (SystemUtils.IS_OS_LINUX) {
            String arch = System.getProperty("os.arch", "").toLowerCase(Locale.ROOT);
            nativepath = arch.contains("arm") || arch.contains("aarch") ? (String)nativepath + "arm" : (String)nativepath + "linux";
        } else if (SystemUtils.IS_OS_MAC) {
            nativepath = (String)nativepath + "mac";
        }
        return nativepath;
    }

    public static Path getUserDir() {
        Path userDir;
        if (SystemUtils.IS_OS_WINDOWS) {
            userDir = Paths.get(System.getenv("APPDATA"), "tinyMediaManager");
        } else if (SystemUtils.IS_OS_LINUX) {
            userDir = Paths.get(System.getProperty("user.home"), ".local", "share", "tinyMediaManager");
            if (Globals.isDocker()) {
                userDir = Paths.get("/data", new String[0]);
            }
        } else {
            userDir = SystemUtils.IS_OS_MAC ? Paths.get(System.getProperty("user.home"), "Library", "Application Support", "tinyMediaManager") : Paths.get(System.getProperty("user.home"), ".tinyMediaManager");
        }
        return userDir;
    }

    public static boolean hasInvalidCharactersForFilesystem(String name) {
        try {
            Paths.get(name, new String[0]);
            return false;
        }
        catch (Exception e) {
            return true;
        }
    }
}

