/*
 * Decompiled with CFR 0.152.
 */
package com.github.kiulian.downloader.model.videos;

import com.github.kiulian.downloader.model.Filter;
import com.github.kiulian.downloader.model.subtitles.SubtitlesInfo;
import com.github.kiulian.downloader.model.videos.VideoDetails;
import com.github.kiulian.downloader.model.videos.formats.AudioFormat;
import com.github.kiulian.downloader.model.videos.formats.Format;
import com.github.kiulian.downloader.model.videos.formats.VideoFormat;
import com.github.kiulian.downloader.model.videos.formats.VideoWithAudioFormat;
import java.util.LinkedList;
import java.util.List;

public class VideoInfo {
    private final VideoDetails videoDetails;
    private final List<Format> formats;
    private final List<SubtitlesInfo> subtitlesInfo;

    public VideoInfo(VideoDetails videoDetails, List<Format> list, List<SubtitlesInfo> list2) {
        this.videoDetails = videoDetails;
        this.formats = list;
        this.subtitlesInfo = list2;
    }

    public VideoDetails details() {
        return this.videoDetails;
    }

    public List<Format> formats() {
        return this.formats;
    }

    public List<SubtitlesInfo> subtitlesInfo() {
        return this.subtitlesInfo;
    }

    public List<Format> findFormats(Filter<Format> filter) {
        return filter.select(this.formats);
    }

    public Format findFormatByItag(int n) {
        for (Format format : this.formats) {
            if (format.itag().id() != n) continue;
            return format;
        }
        return null;
    }

    public List<VideoWithAudioFormat> videoWithAudioFormats() {
        LinkedList<VideoWithAudioFormat> linkedList = new LinkedList<VideoWithAudioFormat>();
        for (Format format : this.formats) {
            if (!(format instanceof VideoWithAudioFormat)) continue;
            linkedList.add((VideoWithAudioFormat)format);
        }
        return linkedList;
    }

    public VideoFormat bestVideoWithAudioFormat() {
        VideoFormat videoFormat = null;
        for (Format format : this.formats) {
            if (!(format instanceof VideoWithAudioFormat)) continue;
            VideoFormat videoFormat2 = (VideoFormat)format;
            if (videoFormat != null && videoFormat2.videoQuality().compare(videoFormat.videoQuality()) <= 0) continue;
            videoFormat = videoFormat2;
        }
        return videoFormat;
    }

    public List<VideoFormat> videoFormats() {
        LinkedList<VideoFormat> linkedList = new LinkedList<VideoFormat>();
        for (Format format : this.formats) {
            if (!(format instanceof VideoFormat)) continue;
            linkedList.add((VideoFormat)format);
        }
        return linkedList;
    }

    public VideoFormat bestVideoFormat() {
        VideoFormat videoFormat = null;
        for (Format format : this.formats) {
            if (!(format instanceof VideoFormat)) continue;
            VideoFormat videoFormat2 = (VideoFormat)format;
            if (videoFormat != null && videoFormat2.videoQuality().compare(videoFormat.videoQuality()) <= 0) continue;
            videoFormat = videoFormat2;
        }
        return videoFormat;
    }

    public List<AudioFormat> audioFormats() {
        LinkedList<AudioFormat> linkedList = new LinkedList<AudioFormat>();
        for (Format format : this.formats) {
            if (!(format instanceof AudioFormat)) continue;
            linkedList.add((AudioFormat)format);
        }
        return linkedList;
    }

    public AudioFormat bestAudioFormat() {
        AudioFormat audioFormat = null;
        for (Format format : this.formats) {
            if (!(format instanceof AudioFormat)) continue;
            AudioFormat audioFormat2 = (AudioFormat)format;
            if (audioFormat != null && audioFormat2.audioQuality().compare(audioFormat.audioQuality()) <= 0) continue;
            audioFormat = audioFormat2;
        }
        return audioFormat;
    }
}

