/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.settings;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.PostProcess;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowSettings;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.components.button.DocsButton;
import org.tinymediamanager.ui.components.button.SquareIconButton;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.components.panel.CollapsiblePanel;
import org.tinymediamanager.ui.components.table.PostProcessTable;
import org.tinymediamanager.ui.components.table.TmmTable;
import org.tinymediamanager.ui.dialogs.PostProcessDialog;
import org.tinymediamanager.ui.dialogs.SettingsDialog;

public class TvShowPostProcessingSettingsPanel
extends JPanel {
    private final EventList<PostProcess> postProcessTvShowEventList;
    private final EventList<PostProcess> postProcessEpisodeEventList;
    private TmmTable tablePostProcessesTvShow;
    private TmmTable tablePostProcessesEpisode;
    private JButton btnAddProcessTvShow;
    private JButton btnRemoveProcessTvShow;
    private JButton btnMoveProcessUpTvShow;
    private JButton btnMoveProcessDownTvShow;
    private JButton btnAddProcessEpisode;
    private JButton btnRemoveProcessEpisode;
    private JButton btnMoveProcessUpEpisode;
    private JButton btnMoveProcessDownEpisode;

    TvShowPostProcessingSettingsPanel() {
        TvShowSettings settings = TvShowModuleManager.getInstance().getSettings();
        this.postProcessTvShowEventList = GlazedLists.eventList(settings.getPostProcessTvShow());
        GlazedLists.syncEventListToList(this.postProcessTvShowEventList, settings.getPostProcessTvShow());
        this.postProcessEpisodeEventList = GlazedLists.eventList(settings.getPostProcessEpisode());
        GlazedLists.syncEventListToList(this.postProcessEpisodeEventList, settings.getPostProcessEpisode());
        this.initComponents();
        this.tablePostProcessesTvShow.getSelectionModel().setSelectionMode(0);
        this.tablePostProcessesEpisode.getSelectionModel().setSelectionMode(0);
        this.btnAddProcessTvShow.addActionListener(e -> {
            TvShowPostProcessDialog dialog = new TvShowPostProcessDialog();
            dialog.pack();
            dialog.setLocationRelativeTo(SettingsDialog.getInstance());
            dialog.setVisible(true);
            this.tablePostProcessesTvShow.adjustColumnPreferredWidths(5);
        });
        this.btnRemoveProcessTvShow.addActionListener(e -> {
            int row = this.tablePostProcessesTvShow.convertRowIndexToModel(this.tablePostProcessesTvShow.getSelectedRow());
            if (row >= 0 && row < this.postProcessTvShowEventList.size()) {
                this.postProcessTvShowEventList.remove(row);
                TvShowModuleManager.getInstance().getSettings().forceSaveSettings();
            }
            this.tablePostProcessesTvShow.adjustColumnPreferredWidths(5);
        });
        this.btnMoveProcessUpTvShow.addActionListener(e -> {
            int row = this.tablePostProcessesTvShow.convertRowIndexToModel(this.tablePostProcessesTvShow.getSelectedRow());
            if (row != -1 && row != 0) {
                ListUtils.swap(this.postProcessTvShowEventList, row, row - 1);
                TvShowModuleManager.getInstance().getSettings().forceSaveSettings();
                this.tablePostProcessesTvShow.getSelectionModel().setSelectionInterval(row - 1, row - 1);
            }
        });
        this.btnMoveProcessDownTvShow.addActionListener(e -> {
            int row = this.tablePostProcessesTvShow.convertRowIndexToModel(this.tablePostProcessesTvShow.getSelectedRow());
            if (row != -1 && row != this.postProcessTvShowEventList.size() - 1) {
                ListUtils.swap(this.postProcessTvShowEventList, row, row + 1);
                TvShowModuleManager.getInstance().getSettings().forceSaveSettings();
                this.tablePostProcessesTvShow.getSelectionModel().setSelectionInterval(row + 1, row + 1);
            }
        });
        this.btnAddProcessEpisode.addActionListener(e -> {
            EpisodePostProcessDialog dialog = new EpisodePostProcessDialog();
            dialog.pack();
            dialog.setLocationRelativeTo(SettingsDialog.getInstance());
            dialog.setVisible(true);
            this.tablePostProcessesEpisode.adjustColumnPreferredWidths(5);
        });
        this.btnRemoveProcessEpisode.addActionListener(e -> {
            int row = this.tablePostProcessesEpisode.convertRowIndexToModel(this.tablePostProcessesEpisode.getSelectedRow());
            if (row >= 0 && row < this.postProcessEpisodeEventList.size()) {
                this.postProcessEpisodeEventList.remove(row);
                TvShowModuleManager.getInstance().getSettings().forceSaveSettings();
            }
            this.tablePostProcessesEpisode.adjustColumnPreferredWidths(5);
        });
        this.btnMoveProcessUpEpisode.addActionListener(e -> {
            int row = this.tablePostProcessesEpisode.convertRowIndexToModel(this.tablePostProcessesEpisode.getSelectedRow());
            if (row != -1 && row != 0) {
                ListUtils.swap(this.postProcessEpisodeEventList, row, row - 1);
                TvShowModuleManager.getInstance().getSettings().forceSaveSettings();
                this.tablePostProcessesEpisode.getSelectionModel().setSelectionInterval(row - 1, row - 1);
            }
        });
        this.btnMoveProcessDownEpisode.addActionListener(e -> {
            int row = this.tablePostProcessesEpisode.convertRowIndexToModel(this.tablePostProcessesEpisode.getSelectedRow());
            if (row != -1 && row != this.postProcessEpisodeEventList.size() - 1) {
                ListUtils.swap(this.postProcessEpisodeEventList, row, row + 1);
                TvShowModuleManager.getInstance().getSettings().forceSaveSettings();
                this.tablePostProcessesEpisode.getSelectionModel().setSelectionInterval(row + 1, row + 1);
            }
        });
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("", "[grow]", "[]"));
        JPanel panelProcess = new JPanel((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][300lp:600lp,grow][]", "[][grow][150lp:200lp,grow][][][grow][150lp:200lp,grow]"));
        TmmLabel lblProcess = new TmmLabel(TmmResourceBundle.getString("Settings.postprocessing"), 1.16667);
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel((JComponent)panelProcess, lblProcess, true);
        collapsiblePanel.addExtraTitleComponent(new DocsButton("/tvshows/settings#post-processing"));
        this.add((Component)collapsiblePanel, "growx,wmin 0");
        JScrollPane spTvShow = new JScrollPane();
        panelProcess.add((Component)spTvShow, "cell 1 2,grow");
        this.tablePostProcessesTvShow = new PostProcessTable(this.postProcessTvShowEventList){

            @Override
            protected void editButtonClicked(int row) {
                int index = this.convertRowIndexToModel(row);
                PostProcess postProcess = (PostProcess)this.postProcessList.get(index);
                if (postProcess != null) {
                    TvShowPostProcessDialog dialog = new TvShowPostProcessDialog();
                    dialog.setProcess(postProcess);
                    dialog.pack();
                    dialog.setLocationRelativeTo(SettingsDialog.getInstance());
                    dialog.setVisible(true);
                    TvShowPostProcessingSettingsPanel.this.tablePostProcessesTvShow.adjustColumnPreferredWidths(5);
                }
            }
        };
        this.tablePostProcessesTvShow.configureScrollPane(spTvShow);
        this.btnAddProcessTvShow = new SquareIconButton(IconManager.ADD_INV);
        panelProcess.add((Component)this.btnAddProcessTvShow, "flowy,cell 2 2,aligny top");
        this.btnRemoveProcessTvShow = new SquareIconButton(IconManager.REMOVE_INV);
        panelProcess.add((Component)this.btnRemoveProcessTvShow, "cell 2 2");
        this.btnMoveProcessUpTvShow = new SquareIconButton(IconManager.ARROW_UP_INV);
        panelProcess.add((Component)this.btnMoveProcessUpTvShow, "cell 2 2");
        this.btnMoveProcessDownTvShow = new SquareIconButton(IconManager.ARROW_DOWN_INV);
        panelProcess.add((Component)this.btnMoveProcessDownTvShow, "cell 2 2");
        JScrollPane spEpisode = new JScrollPane();
        panelProcess.add((Component)spEpisode, "cell 1 6,grow");
        this.tablePostProcessesEpisode = new PostProcessTable(this.postProcessEpisodeEventList){

            @Override
            protected void editButtonClicked(int row) {
                int index = this.convertRowIndexToModel(row);
                PostProcess postProcess = (PostProcess)this.postProcessList.get(index);
                if (postProcess != null) {
                    EpisodePostProcessDialog dialog = new EpisodePostProcessDialog();
                    dialog.setProcess(postProcess);
                    dialog.pack();
                    dialog.setLocationRelativeTo(SettingsDialog.getInstance());
                    dialog.setVisible(true);
                    TvShowPostProcessingSettingsPanel.this.tablePostProcessesEpisode.adjustColumnPreferredWidths(5);
                }
            }
        };
        this.tablePostProcessesEpisode.configureScrollPane(spEpisode);
        this.btnAddProcessEpisode = new SquareIconButton(IconManager.ADD_INV);
        panelProcess.add((Component)this.btnAddProcessEpisode, "flowy,cell 2 6,aligny top");
        this.btnRemoveProcessEpisode = new SquareIconButton(IconManager.REMOVE_INV);
        panelProcess.add((Component)this.btnRemoveProcessEpisode, "cell 2 6");
        this.btnMoveProcessUpEpisode = new SquareIconButton(IconManager.ARROW_UP_INV);
        panelProcess.add((Component)this.btnMoveProcessUpEpisode, "cell 2 6");
        this.btnMoveProcessDownEpisode = new SquareIconButton(IconManager.ARROW_DOWN_INV);
        panelProcess.add((Component)this.btnMoveProcessDownEpisode, "cell 2 6");
    }

    private class EpisodePostProcessDialog
    extends PostProcessDialog {
        @Override
        public void save() {
            if (StringUtils.isBlank((CharSequence)this.tfProcessName.getText()) || StringUtils.isBlank((CharSequence)this.tfCommand.getText()) && StringUtils.isBlank((CharSequence)this.tfPath.getText())) {
                this.showErrorToast(TmmResourceBundle.getString("message.missingitems"));
                return;
            }
            if (this.process == null) {
                this.process = new PostProcess();
                TvShowPostProcessingSettingsPanel.this.postProcessEpisodeEventList.add((Object)this.process);
            }
            this.process.setName(this.tfProcessName.getText());
            this.process.setCommand(this.tfCommand.getText());
            this.process.setPath(this.tfPath.getText());
            TvShowModuleManager.getInstance().getSettings().forceSaveSettings();
            this.setVisible(false);
        }
    }

    private class TvShowPostProcessDialog
    extends PostProcessDialog {
        @Override
        public void save() {
            if (StringUtils.isBlank((CharSequence)this.tfProcessName.getText()) || StringUtils.isBlank((CharSequence)this.tfCommand.getText()) && StringUtils.isBlank((CharSequence)this.tfPath.getText())) {
                this.showErrorToast(TmmResourceBundle.getString("message.missingitems"));
                return;
            }
            if (this.process == null) {
                this.process = new PostProcess();
                TvShowPostProcessingSettingsPanel.this.postProcessTvShowEventList.add((Object)this.process);
            }
            this.process.setName(this.tfProcessName.getText());
            this.process.setCommand(this.tfCommand.getText());
            this.process.setPath(this.tfPath.getText());
            TvShowModuleManager.getInstance().getSettings().forceSaveSettings();
            this.setVisible(false);
        }
    }
}

