/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.plaf;

import com.formdev.flatlaf.ui.FlatSliderUI;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.UIScale;
import java.awt.BasicStroke;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.RoundRectangle2D;
import java.lang.reflect.Field;
import java.util.Dictionary;
import java.util.Enumeration;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSliderUI;
import org.tinymediamanager.ui.components.slider.RangeSlider;

public class TmmRangeSliderUI
extends FlatSliderUI {
    protected boolean second;
    protected static final int MOUSE_HANDLE_NONE = 0;
    protected static final int MOUSE_HANDLE_MIN = 1;
    protected static final int MOUSE_HANDLE_MAX = 2;
    protected static final int MOUSE_HANDLE_MIDDLE = 4;
    protected static final int MOUSE_HANDLE_LOWER = 5;
    protected static final int MOUSE_HANDLE_UPPER = 6;
    protected static final int MOUSE_HANDLE_BOTH = 7;
    protected boolean hover;
    protected boolean rollover1;
    protected boolean pressed1;
    protected boolean rollover2;
    protected boolean pressed2;

    public static ComponentUI createUI(JComponent c) {
        return new TmmRangeSliderUI();
    }

    public void paint(Graphics g, JComponent c) {
        this.second = false;
        super.paint(g, c);
        Rectangle clip = g.getClipBounds();
        this.second = true;
        Point p = this.adjustThumbForHighValue();
        if (clip.intersects(this.thumbRect)) {
            Object[] oldRenderingHints = FlatUIUtils.setRenderingHints((Graphics)g);
            this.paintThumb(g);
            FlatUIUtils.resetRenderingHints((Graphics)g, (Object[])oldRenderingHints);
        }
        this.restoreThumbForLowValue(p);
        this.second = false;
    }

    protected Point adjustThumbForHighValue() {
        Point p = this.thumbRect.getLocation();
        if (this.slider.getOrientation() == 0) {
            int valuePosition = this.xPositionForValue(((RangeSlider)this.slider).getHighValue());
            this.thumbRect.x = valuePosition - this.thumbRect.width / 2;
        } else {
            int valuePosition = this.yPositionForValue(((RangeSlider)this.slider).getHighValue());
            this.thumbRect.y = valuePosition - this.thumbRect.height / 2;
        }
        return p;
    }

    protected void restoreThumbForLowValue(Point p) {
        this.thumbRect.x = p.x;
        this.thumbRect.y = p.y;
    }

    protected void adjustSnapHighValue() {
        int sliderValue = ((RangeSlider)this.slider).getHighValue();
        int snappedValue = this.snapToNearestLabeledTick(sliderValue);
        if (snappedValue != sliderValue) {
            ((RangeSlider)this.slider).setHighValue(snappedValue);
        }
    }

    protected void adjustSnapLowValue() {
        int sliderValue = ((RangeSlider)this.slider).getLowValue();
        int snappedValue = this.snapToNearestLabeledTick(sliderValue);
        if (snappedValue != sliderValue) {
            ((RangeSlider)this.slider).setLowValue(snappedValue);
        }
    }

    private int snapToNearestLabeledTick(int value) {
        int nearest = value;
        int minDistance = Integer.MAX_VALUE;
        Dictionary labels = this.slider.getLabelTable();
        if (labels != null && !labels.isEmpty()) {
            Enumeration keys = labels.keys();
            while (keys.hasMoreElements()) {
                int tickValue = (Integer)keys.nextElement();
                int distance = Math.abs(value - tickValue);
                if (distance >= minDistance) continue;
                minDistance = distance;
                nearest = tickValue;
            }
        }
        int majorTickSpacing = this.slider.getMajorTickSpacing();
        int minorTickSpacing = this.slider.getMinorTickSpacing();
        int tickSpacing = 0;
        if (minorTickSpacing > 0) {
            tickSpacing = minorTickSpacing;
        } else if (majorTickSpacing > 0) {
            tickSpacing = majorTickSpacing;
        }
        if (tickSpacing > 0) {
            float temp = (float)(value - this.slider.getMinimum()) / (float)tickSpacing;
            int whichTick = Math.round(temp);
            int snappedToSpacing = this.slider.getMinimum() + whichTick * tickSpacing;
            snappedToSpacing = Math.max(this.slider.getMinimum(), Math.min(this.slider.getMaximum(), snappedToSpacing));
            int distance = Math.abs(value - snappedToSpacing);
            if (distance < minDistance) {
                nearest = snappedToSpacing;
            }
        }
        return nearest;
    }

    public void paintTrack(Graphics g) {
        RoundRectangle2D.Float trackHigh;
        RoundRectangle2D.Float trackLow;
        boolean enabled = this.slider.isEnabled();
        float tw = UIScale.scale((float)this.trackWidth);
        RoundRectangle2D.Float coloredTrack = null;
        if (this.slider.getOrientation() == 0) {
            float y = (float)this.trackRect.y + ((float)this.trackRect.height - tw) / 2.0f;
            int lowThumbX = this.xPositionForValue(((RangeSlider)this.slider).getLowValue());
            int highThumbX = this.xPositionForValue(((RangeSlider)this.slider).getHighValue());
            if (enabled) {
                coloredTrack = new RoundRectangle2D.Float(lowThumbX, y, highThumbX - lowThumbX, tw, tw, tw);
                trackLow = new RoundRectangle2D.Float(this.trackRect.x, y, lowThumbX - this.trackRect.x, tw, tw, tw);
                trackHigh = new RoundRectangle2D.Float(highThumbX, y, this.trackRect.x + this.trackRect.width - highThumbX, tw, tw, tw);
            } else {
                trackLow = trackHigh = new RoundRectangle2D.Float(this.trackRect.x, y, this.trackRect.width, tw, tw, tw);
            }
        } else {
            float x = (float)this.trackRect.x + ((float)this.trackRect.width - tw) / 2.0f;
            trackLow = new RoundRectangle2D.Float(x, this.trackRect.y, tw, this.trackRect.height, tw, tw);
            trackHigh = new RoundRectangle2D.Float(x, this.trackRect.y, tw, this.trackRect.height, tw, tw);
        }
        if (coloredTrack != null) {
            g.setColor(this.getTrackValueColor());
            ((Graphics2D)g).fill(coloredTrack);
        }
        g.setColor(enabled ? this.getTrackColor() : this.disabledTrackColor);
        ((Graphics2D)g).fill(trackLow);
        ((Graphics2D)g).fill(trackHigh);
    }

    public void paintTicks(Graphics g) {
        super.paintTicks(g);
        Dictionary labels = this.slider.getLabelTable();
        if (labels == null || labels.isEmpty()) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.setColor(this.getTrackValueColor());
        g2d.setStroke(new BasicStroke(1.5f));
        if (this.slider.getOrientation() == 0) {
            int y1 = this.tickRect.y;
            int y2 = this.tickRect.y + this.tickRect.height;
            Enumeration keys = labels.keys();
            while (keys.hasMoreElements()) {
                int tickValue = (Integer)keys.nextElement();
                int x = this.xPositionForValue(tickValue);
                g2d.drawLine(x, y1, x, y2);
            }
        } else {
            int x1 = this.tickRect.x;
            int x2 = this.tickRect.x + this.tickRect.width;
            Enumeration keys = labels.keys();
            while (keys.hasMoreElements()) {
                int tickValue = (Integer)keys.nextElement();
                int y = this.yPositionForValue(tickValue);
                g2d.drawLine(x1, y, x2, y);
            }
        }
    }

    protected void calculateThumbLocation() {
        if (this.slider.getSnapToTicks()) {
            this.adjustSnapLowValue();
            this.adjustSnapHighValue();
        }
        if (this.slider.getOrientation() == 0) {
            int valuePosition = this.xPositionForValue(this.slider.getValue());
            this.thumbRect.x = valuePosition - this.thumbRect.width / 2;
            this.thumbRect.y = this.trackRect.y;
        } else {
            int valuePosition = this.yPositionForValue(this.slider.getValue());
            this.thumbRect.x = this.trackRect.x;
            this.thumbRect.y = valuePosition - this.thumbRect.height / 2;
        }
    }

    protected BasicSliderUI.TrackListener createTrackListener(JSlider slider) {
        return new RangeTrackListener(super.createTrackListener(slider));
    }

    protected int getMouseHandle(int x, int y) {
        int maxX;
        Rectangle rect = this.trackRect;
        this.slider.putClientProperty("RangeSlider.mousePosition", null);
        boolean inMin = false;
        boolean inMax = false;
        if (this.thumbRect.contains(x, y)) {
            inMin = true;
        }
        Point p = this.adjustThumbForHighValue();
        if (this.thumbRect.contains(x, y)) {
            inMax = true;
        }
        this.restoreThumbForLowValue(p);
        if (inMin && inMax) {
            return 7;
        }
        if (inMin) {
            return 1;
        }
        if (inMax) {
            return 2;
        }
        if (this.slider.getOrientation() == 1) {
            int maxY;
            int minY = this.yPositionForValue(((RangeSlider)this.slider).getLowValue());
            Rectangle midRect = new Rectangle(rect.x, Math.min(minY, maxY = this.yPositionForValue(((RangeSlider)this.slider).getHighValue())) + this.thumbRect.height / 2, rect.width, Math.abs(maxY - minY) - this.thumbRect.height);
            if (midRect.contains(x, y)) {
                return 4;
            }
            int sy = rect.y + Math.max(minY, maxY) + this.thumbRect.height / 2;
            Rectangle lowerRect = new Rectangle(rect.x, sy, rect.width, rect.y + rect.height - sy);
            if (lowerRect.contains(x, y)) {
                this.slider.putClientProperty("RangeSlider.mousePosition", true);
                return 5;
            }
            Rectangle upperRect = new Rectangle(rect.x, rect.y, rect.width, Math.min(maxY, minY) - this.thumbRect.height / 2);
            if (upperRect.contains(x, y)) {
                this.slider.putClientProperty("RangeSlider.mousePosition", false);
                return 6;
            }
            return 0;
        }
        int minX = this.xPositionForValue(((RangeSlider)this.slider).getLowValue());
        Rectangle midRect = new Rectangle(Math.min(minX, maxX = this.xPositionForValue(((RangeSlider)this.slider).getHighValue())) + this.thumbRect.width / 2, rect.y, Math.abs(maxX - minX) - this.thumbRect.width, rect.height);
        if (midRect.contains(x, y)) {
            return 4;
        }
        Rectangle lowerRect = new Rectangle(rect.x, rect.y, Math.min(minX, maxX) - this.thumbRect.width / 2 - rect.x, rect.height);
        if (lowerRect.contains(x, y)) {
            this.slider.putClientProperty("RangeSlider.mousePosition", true);
            return 5;
        }
        int sx = rect.x + Math.abs(maxX - minX) + this.thumbRect.width / 2;
        Rectangle upperRect = new Rectangle(sx, rect.y, rect.width - sx, rect.height);
        if (upperRect.contains(x, y)) {
            this.slider.putClientProperty("RangeSlider.mousePosition", false);
            return 6;
        }
        return 0;
    }

    public void paintThumb(Graphics g) {
        try {
            Field field = ((Object)((Object)this)).getClass().getSuperclass().getDeclaredField("rollover");
            field.setAccessible(true);
            field.set((Object)this, this.second ? this.rollover2 : this.rollover1);
            field = ((Object)((Object)this)).getClass().getSuperclass().getDeclaredField("pressed");
            field.setAccessible(true);
            field.set((Object)this, this.second ? this.pressed2 : this.pressed1);
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        super.paintThumb(g);
    }

    protected void setMouseRollover(int handle) {
        switch (handle) {
            case 1: {
                this.rollover1 = true;
                this.rollover2 = false;
                break;
            }
            case 2: {
                this.rollover2 = true;
                this.rollover1 = false;
                break;
            }
            case 4: 
            case 7: {
                this.rollover1 = true;
                this.rollover2 = true;
                break;
            }
            case 0: {
                this.rollover1 = false;
                this.rollover2 = false;
            }
        }
        this.slider.repaint(this.thumbRect);
        Point p = this.adjustThumbForHighValue();
        this.slider.repaint(this.thumbRect);
        this.restoreThumbForLowValue(p);
    }

    protected void setMousePressed(int handle) {
        switch (handle) {
            case 1: {
                this.pressed1 = true;
                this.pressed2 = false;
                break;
            }
            case 2: {
                this.pressed2 = true;
                this.pressed1 = false;
                break;
            }
            case 4: 
            case 7: {
                this.pressed1 = true;
                this.pressed2 = true;
                break;
            }
            case 0: {
                this.pressed1 = false;
                this.pressed2 = false;
            }
        }
        this.slider.repaint(this.thumbRect);
        Point p = this.adjustThumbForHighValue();
        this.slider.repaint(this.thumbRect);
        this.restoreThumbForLowValue(p);
    }

    protected void setMouseReleased(int handle) {
        this.pressed1 = false;
        this.pressed2 = false;
        this.slider.repaint(this.thumbRect);
        Point p = this.adjustThumbForHighValue();
        this.slider.repaint(this.thumbRect);
        this.restoreThumbForLowValue(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scrollByBlock(int direction) {
        JSlider jSlider = this.slider;
        synchronized (jSlider) {
            Object clientProperty = this.slider.getClientProperty("RangeSlider.mousePosition");
            int oldValue = clientProperty == null ? this.slider.getValue() : (Boolean.TRUE.equals(clientProperty) ? ((RangeSlider)this.slider).getLowValue() : ((RangeSlider)this.slider).getHighValue());
            int blockIncrement = (this.slider.getMaximum() - this.slider.getMinimum()) / 10;
            if (blockIncrement <= 0 && this.slider.getMaximum() > this.slider.getMinimum()) {
                blockIncrement = 1;
            }
            int delta = blockIncrement * (direction > 0 ? 1 : -1);
            this.slider.putClientProperty("RangeSlider.adjustAction", "scrollByBlock");
            if (clientProperty == null) {
                this.slider.setValue(Math.max(Math.min(oldValue + delta, this.slider.getMaximum()), this.slider.getMinimum()));
            } else if (Boolean.TRUE.equals(clientProperty)) {
                ((RangeSlider)this.slider).setLowValue(Math.max(Math.min(oldValue + delta, this.slider.getMaximum()), this.slider.getMinimum()));
            } else {
                ((RangeSlider)this.slider).setHighValue(Math.max(Math.min(oldValue + delta, this.slider.getMaximum()), this.slider.getMinimum()));
            }
            this.slider.putClientProperty("RangeSlider.adjustAction", null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scrollByUnit(int direction) {
        JSlider jSlider = this.slider;
        synchronized (jSlider) {
            Object clientProperty = this.slider.getClientProperty("RangeSlider.mousePosition");
            int oldValue = clientProperty == null ? this.slider.getValue() : (Boolean.TRUE.equals(clientProperty) ? ((RangeSlider)this.slider).getLowValue() : ((RangeSlider)this.slider).getHighValue());
            int delta = 1 * (direction > 0 ? 1 : -1);
            this.slider.putClientProperty("RangeSlider.adjustAction", "scrollByUnit");
            if (clientProperty == null) {
                this.slider.setValue(Math.max(Math.min(oldValue + delta, this.slider.getMaximum()), this.slider.getMinimum()));
            } else if (Boolean.TRUE.equals(clientProperty)) {
                ((RangeSlider)this.slider).setLowValue(Math.max(Math.min(oldValue + delta, this.slider.getMaximum()), this.slider.getMinimum()));
            } else {
                ((RangeSlider)this.slider).setHighValue(Math.max(Math.min(oldValue + delta, this.slider.getMaximum()), this.slider.getMinimum()));
            }
            this.slider.putClientProperty("RangeSlider.adjustAction", null);
        }
    }

    protected class RangeTrackListener
    extends BasicSliderUI.TrackListener {
        int handle;
        int handleOffset;
        int mouseStartLocation;
        BasicSliderUI.TrackListener _listener;

        public RangeTrackListener(BasicSliderUI.TrackListener listener) {
            super((BasicSliderUI)((Object)TmmRangeSliderUI.this));
            this._listener = listener;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!TmmRangeSliderUI.this.slider.isEnabled()) {
                return;
            }
            if (TmmRangeSliderUI.this.slider.isRequestFocusEnabled()) {
                TmmRangeSliderUI.this.slider.requestFocus();
            }
            this.handle = TmmRangeSliderUI.this.getMouseHandle(e.getX(), e.getY());
            TmmRangeSliderUI.this.setMousePressed(this.handle);
            if (this.handle == 2 || this.handle == 1 || this.handle == 4 || this.handle == 7) {
                this.handleOffset = TmmRangeSliderUI.this.slider.getOrientation() == 1 ? e.getY() - TmmRangeSliderUI.this.yPositionForValue(((RangeSlider)TmmRangeSliderUI.this.slider).getLowValue()) : e.getX() - TmmRangeSliderUI.this.xPositionForValue(((RangeSlider)TmmRangeSliderUI.this.slider).getLowValue());
                this.mouseStartLocation = TmmRangeSliderUI.this.slider.getOrientation() == 1 ? e.getY() : e.getX();
                TmmRangeSliderUI.this.slider.getModel().setValueIsAdjusting(true);
            } else if (this.handle == 5 || this.handle == 6) {
                this._listener.mousePressed(e);
                TmmRangeSliderUI.this.slider.putClientProperty("RangeSlider.mousePosition", null);
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            int newValue;
            if (!TmmRangeSliderUI.this.slider.isEnabled()) {
                return;
            }
            int newLocation = TmmRangeSliderUI.this.slider.getOrientation() == 1 ? e.getY() : e.getX();
            int n = newValue = TmmRangeSliderUI.this.slider.getOrientation() == 1 ? TmmRangeSliderUI.this.valueForYPosition(newLocation) : TmmRangeSliderUI.this.valueForXPosition(newLocation);
            if (newValue < TmmRangeSliderUI.this.slider.getModel().getMinimum()) {
                newValue = TmmRangeSliderUI.this.slider.getModel().getMinimum();
            }
            if (newValue > TmmRangeSliderUI.this.slider.getModel().getMaximum()) {
                newValue = TmmRangeSliderUI.this.slider.getModel().getMaximum();
            }
            if (this.handle == 7) {
                if (newLocation - this.mouseStartLocation >= 1) {
                    this.handle = 2;
                } else if (newLocation - this.mouseStartLocation <= -1) {
                    this.handle = 1;
                } else {
                    return;
                }
            }
            RangeSlider rangeSlider = (RangeSlider)TmmRangeSliderUI.this.slider;
            switch (this.handle) {
                case 1: {
                    rangeSlider.setLowValue(Math.min(newValue, rangeSlider.getHighValue()));
                    break;
                }
                case 2: {
                    rangeSlider.setHighValue(Math.max(rangeSlider.getLowValue(), newValue));
                    break;
                }
                case 4: {
                    int delta;
                    if (!((RangeSlider)TmmRangeSliderUI.this.slider).isRangeDraggable()) break;
                    int n2 = delta = TmmRangeSliderUI.this.slider.getOrientation() == 1 ? TmmRangeSliderUI.this.valueForYPosition(newLocation - this.handleOffset) - rangeSlider.getLowValue() : TmmRangeSliderUI.this.valueForXPosition(newLocation - this.handleOffset) - rangeSlider.getLowValue();
                    if (delta < 0 && rangeSlider.getLowValue() + delta < rangeSlider.getMinimum()) {
                        delta = rangeSlider.getMinimum() - rangeSlider.getLowValue();
                    }
                    if (delta > 0 && rangeSlider.getHighValue() + delta > rangeSlider.getMaximum()) {
                        delta = rangeSlider.getMaximum() - rangeSlider.getHighValue();
                    }
                    if (delta == 0) break;
                    rangeSlider.setLowValue(rangeSlider.getLowValue() + delta);
                    rangeSlider.setHighValue(rangeSlider.getHighValue() + delta);
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            TmmRangeSliderUI.this.slider.getModel().setValueIsAdjusting(false);
            TmmRangeSliderUI.this.setMouseReleased(this.handle);
            this._listener.mouseReleased(e);
        }

        private void setCursor(int c) {
            Cursor cursor = Cursor.getPredefinedCursor(c);
            if (TmmRangeSliderUI.this.slider.getCursor() != cursor) {
                TmmRangeSliderUI.this.slider.setCursor(cursor);
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (!TmmRangeSliderUI.this.slider.isEnabled()) {
                return;
            }
            int handle = TmmRangeSliderUI.this.getMouseHandle(e.getX(), e.getY());
            TmmRangeSliderUI.this.setMouseRollover(handle);
            switch (handle) {
                case 1: 
                case 2: 
                case 7: {
                    this.setCursor(0);
                    break;
                }
                case 4: {
                    if (TmmRangeSliderUI.this.slider instanceof RangeSlider && ((RangeSlider)TmmRangeSliderUI.this.slider).isRangeDraggable()) {
                        this.setCursor(13);
                        break;
                    }
                    this.setCursor(0);
                    break;
                }
                default: {
                    this.setCursor(0);
                }
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                TmmRangeSliderUI.this.slider.getModel().setValue(TmmRangeSliderUI.this.slider.getModel().getMinimum());
                TmmRangeSliderUI.this.slider.getModel().setExtent(TmmRangeSliderUI.this.slider.getModel().getMaximum() - TmmRangeSliderUI.this.slider.getModel().getMinimum());
                TmmRangeSliderUI.this.slider.repaint();
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            TmmRangeSliderUI.this.hover = true;
            TmmRangeSliderUI.this.slider.repaint();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            TmmRangeSliderUI.this.hover = false;
            TmmRangeSliderUI.this.slider.repaint();
            this.setCursor(0);
        }
    }
}

