/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.moviesets.settings;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieSettings;
import org.tinymediamanager.core.movie.filenaming.MovieSetBannerNaming;
import org.tinymediamanager.core.movie.filenaming.MovieSetClearartNaming;
import org.tinymediamanager.core.movie.filenaming.MovieSetClearlogoNaming;
import org.tinymediamanager.core.movie.filenaming.MovieSetDiscartNaming;
import org.tinymediamanager.core.movie.filenaming.MovieSetFanartNaming;
import org.tinymediamanager.core.movie.filenaming.MovieSetPosterNaming;
import org.tinymediamanager.core.movie.filenaming.MovieSetThumbNaming;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.components.panel.CollapsiblePanel;
import org.tinymediamanager.ui.components.textfield.ReadOnlyTextArea;

class MovieSetImageSettingsPanel
extends JPanel {
    private final MovieSettings settings = MovieModuleManager.getInstance().getSettings();
    private final ItemListener checkBoxListener;
    private final List<String> characterReplacement = new ArrayList<String>(Arrays.asList(" ", "_"));
    private JCheckBox chckbxPoster1;
    private JCheckBox chckbxPoster2;
    private JCheckBox chckbxPoster3;
    private JCheckBox chckbxPoster4;
    private JCheckBox chckbxFanart1;
    private JCheckBox chckbxFanart2;
    private JCheckBox chckbxFanart3;
    private JCheckBox chckbxFanart4;
    private JCheckBox chckbxBanner1;
    private JCheckBox chckbxBanner2;
    private JCheckBox chckbxBanner3;
    private JCheckBox chckbxBanner4;
    private JCheckBox chckbxLogo1;
    private JCheckBox chckbxLogo2;
    private JCheckBox chckbxLogo3;
    private JCheckBox chckbxLogo4;
    private JCheckBox chckbxClearlogo1;
    private JCheckBox chckbxClearlogo2;
    private JCheckBox chckbxClearlogo3;
    private JCheckBox chckbxClearlogo4;
    private JCheckBox chckbxClearart1;
    private JCheckBox chckbxClearart2;
    private JCheckBox chckbxClearart3;
    private JCheckBox chckbxClearart4;
    private JCheckBox chckbxThumb1;
    private JCheckBox chckbxThumb2;
    private JCheckBox chckbxThumb3;
    private JCheckBox chckbxThumb4;
    private JCheckBox chckbxThumb5;
    private JCheckBox chckbxThumb6;
    private JCheckBox chckbxThumb7;
    private JCheckBox chckbxThumb8;
    private JCheckBox chckbxDiscart1;
    private JCheckBox chckbxDiscart2;
    private JCheckBox chckbxDiscart3;
    private JCheckBox chckbxDiscart4;
    private JCheckBox chckbxDiscart5;
    private JCheckBox chckbxDiscart6;
    private JCheckBox chckbxDiscart7;
    private JCheckBox chckbxDiscart8;
    private JCheckBox chckbxAutomaticScrape;
    private JCheckBox chckbxAppendTmdbId;
    private JComboBox cbReplacement;

    MovieSetImageSettingsPanel() {
        this.checkBoxListener = e -> this.checkChanges();
        this.initComponents();
        this.initDataBindings();
        this.buildCheckBoxes();
        String replacement = this.settings.getMovieSetTitleCharacterReplacement();
        int index = this.characterReplacement.indexOf(replacement);
        if (index >= 0) {
            this.cbReplacement.setSelectedIndex(index);
        }
    }

    private void buildCheckBoxes() {
        this.clearSelection(this.chckbxFanart1, this.chckbxFanart2, this.chckbxFanart3, this.chckbxFanart4);
        this.clearSelection(this.chckbxPoster1, this.chckbxPoster2, this.chckbxPoster3, this.chckbxPoster4);
        this.clearSelection(this.chckbxBanner1, this.chckbxBanner2, this.chckbxBanner3, this.chckbxBanner4);
        this.clearSelection(this.chckbxClearart1, this.chckbxClearart2, this.chckbxClearart3, this.chckbxClearart4);
        this.clearSelection(this.chckbxClearlogo1, this.chckbxClearlogo2, this.chckbxClearlogo3, this.chckbxClearlogo4);
        this.clearSelection(this.chckbxLogo1, this.chckbxLogo2, this.chckbxLogo3, this.chckbxLogo4);
        this.clearSelection(this.chckbxThumb1, this.chckbxThumb2, this.chckbxThumb3, this.chckbxThumb4, this.chckbxThumb5, this.chckbxThumb6, this.chckbxThumb7, this.chckbxThumb8);
        this.clearSelection(this.chckbxDiscart1, this.chckbxDiscart2, this.chckbxDiscart3, this.chckbxDiscart4, this.chckbxDiscart5, this.chckbxDiscart6, this.chckbxDiscart7, this.chckbxDiscart8);
        for (MovieSetPosterNaming poster : this.settings.getMovieSetPosterFilenames()) {
            switch (poster) {
                case MOVIE_POSTER: {
                    this.chckbxPoster1.setSelected(true);
                    break;
                }
                case KODI_POSTER: {
                    this.chckbxPoster2.setSelected(true);
                    break;
                }
                case AUTOMATOR_POSTER: {
                    this.chckbxPoster3.setSelected(true);
                    break;
                }
                case MOVIESET_POSTER: {
                    this.chckbxPoster4.setSelected(true);
                }
            }
        }
        for (MovieSetFanartNaming fanart : this.settings.getMovieSetFanartFilenames()) {
            switch (fanart) {
                case MOVIE_FANART: {
                    this.chckbxFanart1.setSelected(true);
                    break;
                }
                case KODI_FANART: {
                    this.chckbxFanart2.setSelected(true);
                    break;
                }
                case AUTOMATOR_FANART: {
                    this.chckbxFanart3.setSelected(true);
                    break;
                }
                case MOVIESET_FANART: {
                    this.chckbxFanart4.setSelected(true);
                }
            }
        }
        for (MovieSetBannerNaming banner : this.settings.getMovieSetBannerFilenames()) {
            switch (banner) {
                case MOVIE_BANNER: {
                    this.chckbxBanner1.setSelected(true);
                    break;
                }
                case KODI_BANNER: {
                    this.chckbxBanner2.setSelected(true);
                    break;
                }
                case AUTOMATOR_BANNER: {
                    this.chckbxBanner3.setSelected(true);
                    break;
                }
                case MOVIESET_BANNER: {
                    this.chckbxBanner4.setSelected(true);
                }
            }
        }
        for (MovieSetClearartNaming clearart : this.settings.getMovieSetClearartFilenames()) {
            switch (clearart) {
                case MOVIE_CLEARART: {
                    this.chckbxClearart1.setSelected(true);
                    break;
                }
                case KODI_CLEARART: {
                    this.chckbxClearart2.setSelected(true);
                    break;
                }
                case AUTOMATOR_CLEARART: {
                    this.chckbxClearart3.setSelected(true);
                    break;
                }
                case MOVIESET_CLEARART: {
                    this.chckbxClearart4.setSelected(true);
                }
            }
        }
        for (MovieSetThumbNaming thumb : this.settings.getMovieSetThumbFilenames()) {
            switch (thumb) {
                case MOVIE_THUMB: {
                    this.chckbxThumb1.setSelected(true);
                    break;
                }
                case KODI_THUMB: {
                    this.chckbxThumb2.setSelected(true);
                    break;
                }
                case AUTOMATOR_THUMB: {
                    this.chckbxThumb3.setSelected(true);
                    break;
                }
                case MOVIE_LANDSCAPE: {
                    this.chckbxThumb4.setSelected(true);
                    break;
                }
                case KODI_LANDSCAPE: {
                    this.chckbxThumb5.setSelected(true);
                    break;
                }
                case AUTOMATOR_LANDSCAPE: {
                    this.chckbxThumb6.setSelected(true);
                    break;
                }
                case MOVIESET_THUMB: {
                    this.chckbxThumb7.setSelected(true);
                    break;
                }
                case MOVIESET_LANDSCAPE: {
                    this.chckbxThumb8.setSelected(true);
                }
            }
        }
        for (MovieSetClearlogoNaming clearlogo : this.settings.getMovieSetClearlogoFilenames()) {
            switch (clearlogo) {
                case MOVIE_CLEARLOGO: {
                    this.chckbxClearlogo1.setSelected(true);
                    break;
                }
                case KODI_CLEARLOGO: {
                    this.chckbxClearlogo2.setSelected(true);
                    break;
                }
                case AUTOMATOR_CLEARLOGO: {
                    this.chckbxClearlogo3.setSelected(true);
                    break;
                }
                case MOVIESET_CLEARLOGO: {
                    this.chckbxClearlogo4.setSelected(true);
                    break;
                }
                case MOVIE_LOGO: {
                    this.chckbxLogo1.setSelected(true);
                    break;
                }
                case KODI_LOGO: {
                    this.chckbxLogo2.setSelected(true);
                    break;
                }
                case AUTOMATOR_LOGO: {
                    this.chckbxLogo3.setSelected(true);
                    break;
                }
                case MOVIESET_LOGO: {
                    this.chckbxLogo4.setSelected(true);
                }
            }
        }
        for (MovieSetDiscartNaming disc : this.settings.getMovieSetDiscartFilenames()) {
            switch (disc) {
                case MOVIE_DISC: {
                    this.chckbxDiscart1.setSelected(true);
                    break;
                }
                case KODI_DISC: {
                    this.chckbxDiscart2.setSelected(true);
                    break;
                }
                case AUTOMATOR_DISC: {
                    this.chckbxDiscart3.setSelected(true);
                    break;
                }
                case MOVIE_DISCART: {
                    this.chckbxDiscart4.setSelected(true);
                    break;
                }
                case KODI_DISCART: {
                    this.chckbxDiscart5.setSelected(true);
                    break;
                }
                case AUTOMATOR_DISCART: {
                    this.chckbxDiscart6.setSelected(true);
                    break;
                }
                case MOVIESET_DISC: {
                    this.chckbxDiscart7.setSelected(true);
                    break;
                }
                case MOVIESET_DISCART: {
                    this.chckbxDiscart8.setSelected(true);
                }
            }
        }
        this.chckbxPoster1.addItemListener(this.checkBoxListener);
        this.chckbxPoster2.addItemListener(this.checkBoxListener);
        this.chckbxPoster3.addItemListener(this.checkBoxListener);
        this.chckbxPoster4.addItemListener(this.checkBoxListener);
        this.chckbxFanart1.addItemListener(this.checkBoxListener);
        this.chckbxFanart2.addItemListener(this.checkBoxListener);
        this.chckbxFanart3.addItemListener(this.checkBoxListener);
        this.chckbxFanart4.addItemListener(this.checkBoxListener);
        this.chckbxBanner1.addItemListener(this.checkBoxListener);
        this.chckbxBanner2.addItemListener(this.checkBoxListener);
        this.chckbxBanner3.addItemListener(this.checkBoxListener);
        this.chckbxBanner4.addItemListener(this.checkBoxListener);
        this.chckbxClearart1.addItemListener(this.checkBoxListener);
        this.chckbxClearart2.addItemListener(this.checkBoxListener);
        this.chckbxClearart3.addItemListener(this.checkBoxListener);
        this.chckbxClearart4.addItemListener(this.checkBoxListener);
        this.chckbxClearlogo1.addItemListener(this.checkBoxListener);
        this.chckbxClearlogo2.addItemListener(this.checkBoxListener);
        this.chckbxClearlogo3.addItemListener(this.checkBoxListener);
        this.chckbxClearlogo4.addItemListener(this.checkBoxListener);
        this.chckbxLogo1.addItemListener(this.checkBoxListener);
        this.chckbxLogo2.addItemListener(this.checkBoxListener);
        this.chckbxLogo3.addItemListener(this.checkBoxListener);
        this.chckbxLogo4.addItemListener(this.checkBoxListener);
        this.chckbxThumb1.addItemListener(this.checkBoxListener);
        this.chckbxThumb2.addItemListener(this.checkBoxListener);
        this.chckbxThumb3.addItemListener(this.checkBoxListener);
        this.chckbxThumb4.addItemListener(this.checkBoxListener);
        this.chckbxThumb5.addItemListener(this.checkBoxListener);
        this.chckbxThumb6.addItemListener(this.checkBoxListener);
        this.chckbxThumb7.addItemListener(this.checkBoxListener);
        this.chckbxThumb8.addItemListener(this.checkBoxListener);
        this.chckbxDiscart1.addItemListener(this.checkBoxListener);
        this.chckbxDiscart2.addItemListener(this.checkBoxListener);
        this.chckbxDiscart3.addItemListener(this.checkBoxListener);
        this.chckbxDiscart4.addItemListener(this.checkBoxListener);
        this.chckbxDiscart5.addItemListener(this.checkBoxListener);
        this.chckbxDiscart6.addItemListener(this.checkBoxListener);
        this.chckbxDiscart7.addItemListener(this.checkBoxListener);
        this.chckbxDiscart8.addItemListener(this.checkBoxListener);
    }

    private void clearSelection(JCheckBox ... checkBoxes) {
        for (JCheckBox checkBox : checkBoxes) {
            checkBox.removeItemListener(this.checkBoxListener);
            checkBox.setSelected(false);
        }
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("", "[900lp,grow]", "[]"));
        JPanel panelMovieSet = new JPanel((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][16lp!][][20lp!][][20lp!][][20lp!][grow]", "[][][][10lp!][][10lp!][][10lp!][][20lp!][10lp!][][][10lp!][][][10lp!][][][10lp!][][][10lp!][][][10lp!][][][][][10lp!][][][][][10lp!][][][][][20lp!][]"));
        TmmLabel lblTitle = new TmmLabel(TmmResourceBundle.getString("Settings.movieset"), 1.16667);
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel((JComponent)panelMovieSet, lblTitle, true);
        this.add((Component)collapsiblePanel, "cell 0 0,growx,wmin 0");
        this.chckbxAutomaticScrape = new JCheckBox(TmmResourceBundle.getString("Settings.default.autoscrape"));
        panelMovieSet.add((Component)this.chckbxAutomaticScrape, "cell 1 0 8 1");
        JLabel lblReplacementT = new JLabel(TmmResourceBundle.getString("Settings.movieset.replacement"));
        panelMovieSet.add((Component)lblReplacementT, "cell 1 1 8 1");
        this.cbReplacement = new JComboBox<Object>(this.characterReplacement.toArray());
        panelMovieSet.add((Component)this.cbReplacement, "cell 1 1 8 1");
        this.chckbxAppendTmdbId = new JCheckBox(TmmResourceBundle.getString("Settings.movieset.appendtmdbid"));
        panelMovieSet.add((Component)this.chckbxAppendTmdbId, "cell 1 2 8 1");
        ReadOnlyTextArea readOnlyTextArea = new ReadOnlyTextArea(TmmResourceBundle.getString("Settings.movieset.artwork.desc"));
        panelMovieSet.add((Component)readOnlyTextArea, "cell 1 4 8 1,wmin 0,grow");
        JPanel panelFolderSettings = new JPanel();
        panelMovieSet.add((Component)panelFolderSettings, "cell 1 6 8 1,grow");
        panelFolderSettings.setLayout((LayoutManager)new MigLayout("insets 0", "[][grow]", "[][][]"));
        TmmLabel lblMovieFolderT = new TmmLabel(TmmResourceBundle.getString("Settings.movieset.moviefolder") + ":");
        panelFolderSettings.add((Component)lblMovieFolderT, "cell 0 0");
        JLabel lblMovieFolder = new JLabel(TmmResourceBundle.getString("Settings.movieset.moviefolder.example"));
        panelFolderSettings.add((Component)lblMovieFolder, "cell 1 0");
        TmmLabel lblKodiFolderT = new TmmLabel(TmmResourceBundle.getString("Settings.movieset.foldername.kodi") + ":");
        panelFolderSettings.add((Component)lblKodiFolderT, "cell 0 1");
        JLabel lblKodiFolder = new JLabel(TmmResourceBundle.getString("Settings.movieset.foldername.kodi.example"));
        panelFolderSettings.add((Component)lblKodiFolder, "cell 1 1");
        TmmLabel lblAutomatorFolderT = new TmmLabel(TmmResourceBundle.getString("Settings.movieset.foldername.automator") + ":");
        panelFolderSettings.add((Component)lblAutomatorFolderT, "cell 0 2");
        JLabel lblAutomatorFolder = new JLabel(TmmResourceBundle.getString("Settings.movieset.foldername.automator.example"));
        panelFolderSettings.add((Component)lblAutomatorFolder, "cell 1 2");
        JLabel lblHintIcon = new JLabel(IconManager.HINT);
        panelMovieSet.add((Component)lblHintIcon, "cell 1 8");
        ReadOnlyTextArea taHint = new ReadOnlyTextArea(TmmResourceBundle.getString("Settings.movieset.artwork.hint"));
        panelMovieSet.add((Component)taHint, "cell 2 8 7 1,wmin 0,grow");
        TmmLabel lblMovieFolderT2 = new TmmLabel(TmmResourceBundle.getString("Settings.movieset.moviefolder"));
        panelMovieSet.add((Component)lblMovieFolderT2, "cell 4 11");
        TmmLabel lblKodiStyleT = new TmmLabel("Kodi/Artwork Beef style");
        panelMovieSet.add((Component)lblKodiStyleT, "cell 6 11");
        TmmLabel lblMovieSetAutomatorT = new TmmLabel("Movie Set Artwork Automator style");
        panelMovieSet.add((Component)lblMovieSetAutomatorT, "cell 8 11");
        JLabel lblMovieFolder2T = new JLabel(TmmResourceBundle.getString("Settings.moviefolder"));
        panelMovieSet.add((Component)lblMovieFolder2T, "flowx,cell 4 12");
        JLabel lblArtworkFolder2T = new JLabel(TmmResourceBundle.getString("Settings.movieset.moviesetartworkfolder"));
        panelMovieSet.add((Component)lblArtworkFolder2T, "cell 6 12");
        JLabel lblArtworkFolder3T = new JLabel(TmmResourceBundle.getString("Settings.movieset.moviesetartworkfolder"));
        panelMovieSet.add((Component)lblArtworkFolder3T, "cell 8 12");
        TmmLabel lblPosterFilenameT = new TmmLabel(TmmResourceBundle.getString("mediafiletype.poster"));
        panelMovieSet.add((Component)lblPosterFilenameT, "cell 1 14 2 1");
        this.chckbxPoster1 = new JCheckBox("movieset-poster." + TmmResourceBundle.getString("Settings.artwork.extension"));
        panelMovieSet.add((Component)this.chckbxPoster1, "cell 4 14");
        this.chckbxPoster2 = new JCheckBox(TmmResourceBundle.getString("Settings.movieset.moviesetname") + "/poster." + TmmResourceBundle.getString("Settings.artwork.extension"));
        panelMovieSet.add((Component)this.chckbxPoster2, "cell 6 14");
        this.chckbxPoster3 = new JCheckBox(TmmResourceBundle.getString("Settings.movieset.moviesetname") + "-poster." + TmmResourceBundle.getString("Settings.artwork.extension"));
        panelMovieSet.add((Component)this.chckbxPoster3, "cell 8 14");
        this.chckbxPoster4 = new JCheckBox(TmmResourceBundle.getString("Settings.movieset.moviesetname") + "-poster." + TmmResourceBundle.getString("Settings.artwork.extension"));
        panelMovieSet.add((Component)this.chckbxPoster4, "cell 4 15");
        TmmLabel lblFanartFilenameT = new TmmLabel(TmmResourceBundle.getString("mediafiletype.fanart"));
        panelMovieSet.add((Component)lblFanartFilenameT, "cell 1 17 2 1");
        this.chckbxFanart1 = new JCheckBox("movieset-fanart." + TmmResourceBundle.getString("Settings.artwork.extension"));
        panelMovieSet.add((Component)this.chckbxFanart1, "cell 4 17");
        this.chckbxFanart2 = new JCheckBox(TmmResourceBundle.getString("Settings.movieset.moviesetname") + "/fanart." + TmmResourceBundle.getString("Settings.artwork.extension"));
        panelMovieSet.add((Component)this.chckbxFanart2, "cell 6 17");
        this.chckbxFanart3 = new JCheckBox(TmmResourceBundle.getString("Settings.movieset.moviesetname") + "-fanart." + TmmResourceBundle.getString("Settings.artwork.extension"));
        panelMovieSet.add((Component)this.chckbxFanart3, "cell 8 17");
        this.chckbxFanart4 = new JCheckBox(TmmResourceBundle.getString("Settings.movieset.moviesetname") + "-fanart." + TmmResourceBundle.getString("Settings.artwork.extension"));
        panelMovieSet.add((Component)this.chckbxFanart4, "cell 4 18");
        TmmLabel lblBannerT = new TmmLabel(TmmResourceBundle.getString("mediafiletype.banner"));
        panelMovieSet.add((Component)lblBannerT, "cell 1 20 2 1");
        this.chckbxBanner1 = new JCheckBox("movieset-banner." + TmmResourceBundle.getString("Settings.artwork.extension"));
        panelMovieSet.add((Component)this.chckbxBanner1, "cell 4 20");
        this.chckbxBanner2 = new JCheckBox(TmmResourceBundle.getString("Settings.movieset.moviesetname") + "/banner." + TmmResourceBundle.getString("Settings.artwork.extension"));
        panelMovieSet.add((Component)this.chckbxBanner2, "cell 6 20");
        this.chckbxBanner3 = new JCheckBox(TmmResourceBundle.getString("Settings.movieset.moviesetname") + "-banner." + TmmResourceBundle.getString("Settings.artwork.extension"));
        panelMovieSet.add((Component)this.chckbxBanner3, "cell 8 20");
        this.chckbxBanner4 = new JCheckBox(TmmResourceBundle.getString("Settings.movieset.moviesetname") + "-banner." + TmmResourceBundle.getString("Settings.artwork.extension"));
        panelMovieSet.add((Component)this.chckbxBanner4, "cell 4 21");
        TmmLabel lblClearartT = new TmmLabel(TmmResourceBundle.getString("mediafiletype.clearart"));
        panelMovieSet.add((Component)lblClearartT, "cell 1 23 2 1");
        this.chckbxClearart1 = new JCheckBox("movieset-clearart." + TmmResourceBundle.getString("Settings.artwork.extension"));
        panelMovieSet.add((Component)this.chckbxClearart1, "cell 4 23");
        this.chckbxClearart2 = new JCheckBox(TmmResourceBundle.getString("Settings.movieset.moviesetname") + "/clearart." + TmmResourceBundle.getString("Settings.artwork.extension"));
        panelMovieSet.add((Component)this.chckbxClearart2, "cell 6 23");
        this.chckbxClearart3 = new JCheckBox(TmmResourceBundle.getString("Settings.movieset.moviesetname") + "-clearart." + TmmResourceBundle.getString("Settings.artwork.extension"));
        panelMovieSet.add((Component)this.chckbxClearart3, "cell 8 23");
        this.chckbxClearart4 = new JCheckBox(TmmResourceBundle.getString("Settings.movieset.moviesetname") + "-clearart." + TmmResourceBundle.getString("Settings.artwork.extension"));
        panelMovieSet.add((Component)this.chckbxClearart4, "cell 4 24");
        TmmLabel lblThumbT = new TmmLabel(TmmResourceBundle.getString("mediafiletype.thumb"));
        panelMovieSet.add((Component)lblThumbT, "cell 1 26 2 1");
        this.chckbxThumb1 = new JCheckBox("movieset-thumb." + TmmResourceBundle.getString("Settings.artwork.extension"));
        panelMovieSet.add((Component)this.chckbxThumb1, "cell 4 26");
        this.chckbxThumb2 = new JCheckBox(TmmResourceBundle.getString("Settings.movieset.moviesetname") + "/thumb." + TmmResourceBundle.getString("Settings.artwork.extension"));
        panelMovieSet.add((Component)this.chckbxThumb2, "cell 6 26");
        this.chckbxThumb3 = new JCheckBox(TmmResourceBundle.getString("Settings.movieset.moviesetname") + "-thumb." + TmmResourceBundle.getString("Settings.artwork.extension"));
        panelMovieSet.add((Component)this.chckbxThumb3, "cell 8 26");
        this.chckbxThumb4 = new JCheckBox("movieset-landscape." + TmmResourceBundle.getString("Settings.artwork.extension"));
        panelMovieSet.add((Component)this.chckbxThumb4, "cell 4 27");
        this.chckbxThumb5 = new JCheckBox(TmmResourceBundle.getString("Settings.movieset.moviesetname") + "/landscape." + TmmResourceBundle.getString("Settings.artwork.extension"));
        panelMovieSet.add((Component)this.chckbxThumb5, "cell 6 27");
        this.chckbxThumb6 = new JCheckBox(TmmResourceBundle.getString("Settings.movieset.moviesetname") + "-landscape." + TmmResourceBundle.getString("Settings.artwork.extension"));
        panelMovieSet.add((Component)this.chckbxThumb6, "cell 8 27");
        this.chckbxThumb7 = new JCheckBox(TmmResourceBundle.getString("Settings.movieset.moviesetname") + "-thumb." + TmmResourceBundle.getString("Settings.artwork.extension"));
        panelMovieSet.add((Component)this.chckbxThumb7, "cell 4 28");
        this.chckbxThumb8 = new JCheckBox(TmmResourceBundle.getString("Settings.movieset.moviesetname") + "-landscape." + TmmResourceBundle.getString("Settings.artwork.extension"));
        panelMovieSet.add((Component)this.chckbxThumb8, "cell 4 29");
        this.chckbxLogo1 = new JCheckBox("movieset-logo." + TmmResourceBundle.getString("Settings.artwork.extension"));
        panelMovieSet.add((Component)this.chckbxLogo1, "cell 4 33");
        this.chckbxLogo2 = new JCheckBox(TmmResourceBundle.getString("Settings.movieset.moviesetname") + "/logo." + TmmResourceBundle.getString("Settings.artwork.extension"));
        panelMovieSet.add((Component)this.chckbxLogo2, "cell 6 33");
        this.chckbxLogo3 = new JCheckBox(TmmResourceBundle.getString("Settings.movieset.moviesetname") + "-logo." + TmmResourceBundle.getString("Settings.artwork.extension"));
        panelMovieSet.add((Component)this.chckbxLogo3, "cell 8 33");
        this.chckbxLogo4 = new JCheckBox(TmmResourceBundle.getString("Settings.movieset.moviesetname") + "-logo." + TmmResourceBundle.getString("Settings.artwork.extension"));
        panelMovieSet.add((Component)this.chckbxLogo4, "cell 4 34");
        TmmLabel lblClearlogoT = new TmmLabel(TmmResourceBundle.getString("mediafiletype.clearlogo"));
        panelMovieSet.add((Component)lblClearlogoT, "cell 1 31 2 1");
        this.chckbxClearlogo1 = new JCheckBox("movieset-clearlogo." + TmmResourceBundle.getString("Settings.artwork.extension"));
        panelMovieSet.add((Component)this.chckbxClearlogo1, "cell 4 31");
        this.chckbxClearlogo2 = new JCheckBox(TmmResourceBundle.getString("Settings.movieset.moviesetname") + "/clearlogo." + TmmResourceBundle.getString("Settings.artwork.extension"));
        panelMovieSet.add((Component)this.chckbxClearlogo2, "cell 6 31");
        this.chckbxClearlogo3 = new JCheckBox(TmmResourceBundle.getString("Settings.movieset.moviesetname") + "-clearlogo." + TmmResourceBundle.getString("Settings.artwork.extension"));
        panelMovieSet.add((Component)this.chckbxClearlogo3, "cell 8 31");
        this.chckbxClearlogo4 = new JCheckBox(TmmResourceBundle.getString("Settings.movieset.moviesetname") + "-clearlogo." + TmmResourceBundle.getString("Settings.artwork.extension"));
        panelMovieSet.add((Component)this.chckbxClearlogo4, "cell 4 32,aligny center");
        TmmLabel lblDiscartT = new TmmLabel(TmmResourceBundle.getString("mediafiletype.disc"));
        panelMovieSet.add((Component)lblDiscartT, "cell 1 36 2 1");
        this.chckbxDiscart1 = new JCheckBox("movieset-disc." + TmmResourceBundle.getString("Settings.artwork.extension"));
        panelMovieSet.add((Component)this.chckbxDiscart1, "cell 4 36");
        this.chckbxDiscart2 = new JCheckBox(TmmResourceBundle.getString("Settings.movieset.moviesetname") + "/disc." + TmmResourceBundle.getString("Settings.artwork.extension"));
        panelMovieSet.add((Component)this.chckbxDiscart2, "cell 6 36");
        this.chckbxDiscart3 = new JCheckBox(TmmResourceBundle.getString("Settings.movieset.moviesetname") + "-disc." + TmmResourceBundle.getString("Settings.artwork.extension"));
        panelMovieSet.add((Component)this.chckbxDiscart3, "cell 8 36");
        this.chckbxDiscart4 = new JCheckBox("movieset-discart." + TmmResourceBundle.getString("Settings.artwork.extension"));
        panelMovieSet.add((Component)this.chckbxDiscart4, "cell 4 37");
        this.chckbxDiscart5 = new JCheckBox(TmmResourceBundle.getString("Settings.movieset.moviesetname") + "/discart." + TmmResourceBundle.getString("Settings.artwork.extension"));
        panelMovieSet.add((Component)this.chckbxDiscart5, "cell 6 37");
        this.chckbxDiscart6 = new JCheckBox(TmmResourceBundle.getString("Settings.movieset.moviesetname") + "-discart." + TmmResourceBundle.getString("Settings.artwork.extension"));
        panelMovieSet.add((Component)this.chckbxDiscart6, "cell 8 37");
        this.chckbxDiscart7 = new JCheckBox(TmmResourceBundle.getString("Settings.movieset.moviesetname") + "-disc." + TmmResourceBundle.getString("Settings.artwork.extension"));
        panelMovieSet.add((Component)this.chckbxDiscart7, "cell 4 38");
        this.chckbxDiscart8 = new JCheckBox(TmmResourceBundle.getString("Settings.movieset.moviesetname") + "-discart." + TmmResourceBundle.getString("Settings.artwork.extension"));
        panelMovieSet.add((Component)this.chckbxDiscart8, "cell 4 39");
        ReadOnlyTextArea tpFileNamingHint = new ReadOnlyTextArea(TmmResourceBundle.getString("Settings.naming.info"));
        panelMovieSet.add((Component)tpFileNamingHint, "cell 2 41 7 1,growx,wmin 0");
        TmmFontHelper.changeFont((JComponent)tpFileNamingHint, 0.833);
    }

    private void checkChanges() {
        this.settings.clearMovieSetPosterFilenames();
        if (this.chckbxPoster1.isSelected()) {
            this.settings.addMovieSetPosterFilename(MovieSetPosterNaming.MOVIE_POSTER);
        }
        if (this.chckbxPoster2.isSelected()) {
            this.settings.addMovieSetPosterFilename(MovieSetPosterNaming.KODI_POSTER);
        }
        if (this.chckbxPoster3.isSelected()) {
            this.settings.addMovieSetPosterFilename(MovieSetPosterNaming.AUTOMATOR_POSTER);
        }
        if (this.chckbxPoster4.isSelected()) {
            this.settings.addMovieSetPosterFilename(MovieSetPosterNaming.MOVIESET_POSTER);
        }
        this.settings.clearMovieSetFanartFilenames();
        if (this.chckbxFanart1.isSelected()) {
            this.settings.addMovieSetFanartFilename(MovieSetFanartNaming.MOVIE_FANART);
        }
        if (this.chckbxFanart2.isSelected()) {
            this.settings.addMovieSetFanartFilename(MovieSetFanartNaming.KODI_FANART);
        }
        if (this.chckbxFanart3.isSelected()) {
            this.settings.addMovieSetFanartFilename(MovieSetFanartNaming.AUTOMATOR_FANART);
        }
        if (this.chckbxFanart4.isSelected()) {
            this.settings.addMovieSetFanartFilename(MovieSetFanartNaming.MOVIESET_FANART);
        }
        this.settings.clearMovieSetBannerFilenames();
        if (this.chckbxBanner1.isSelected()) {
            this.settings.addMovieSetBannerFilename(MovieSetBannerNaming.MOVIE_BANNER);
        }
        if (this.chckbxBanner2.isSelected()) {
            this.settings.addMovieSetBannerFilename(MovieSetBannerNaming.KODI_BANNER);
        }
        if (this.chckbxBanner3.isSelected()) {
            this.settings.addMovieSetBannerFilename(MovieSetBannerNaming.AUTOMATOR_BANNER);
        }
        if (this.chckbxBanner4.isSelected()) {
            this.settings.addMovieSetBannerFilename(MovieSetBannerNaming.MOVIESET_BANNER);
        }
        this.settings.clearMovieSetClearartFilenames();
        if (this.chckbxClearart1.isSelected()) {
            this.settings.addMovieSetClearartFilename(MovieSetClearartNaming.MOVIE_CLEARART);
        }
        if (this.chckbxClearart2.isSelected()) {
            this.settings.addMovieSetClearartFilename(MovieSetClearartNaming.KODI_CLEARART);
        }
        if (this.chckbxClearart3.isSelected()) {
            this.settings.addMovieSetClearartFilename(MovieSetClearartNaming.AUTOMATOR_CLEARART);
        }
        if (this.chckbxClearart4.isSelected()) {
            this.settings.addMovieSetClearartFilename(MovieSetClearartNaming.MOVIESET_CLEARART);
        }
        this.settings.clearMovieSetThumbFilenames();
        if (this.chckbxThumb1.isSelected()) {
            this.settings.addMovieSetThumbFilename(MovieSetThumbNaming.MOVIE_THUMB);
        }
        if (this.chckbxThumb2.isSelected()) {
            this.settings.addMovieSetThumbFilename(MovieSetThumbNaming.KODI_THUMB);
        }
        if (this.chckbxThumb3.isSelected()) {
            this.settings.addMovieSetThumbFilename(MovieSetThumbNaming.AUTOMATOR_THUMB);
        }
        if (this.chckbxThumb4.isSelected()) {
            this.settings.addMovieSetThumbFilename(MovieSetThumbNaming.MOVIE_LANDSCAPE);
        }
        if (this.chckbxThumb5.isSelected()) {
            this.settings.addMovieSetThumbFilename(MovieSetThumbNaming.KODI_LANDSCAPE);
        }
        if (this.chckbxThumb6.isSelected()) {
            this.settings.addMovieSetThumbFilename(MovieSetThumbNaming.AUTOMATOR_LANDSCAPE);
        }
        if (this.chckbxThumb7.isSelected()) {
            this.settings.addMovieSetThumbFilename(MovieSetThumbNaming.MOVIESET_THUMB);
        }
        if (this.chckbxThumb8.isSelected()) {
            this.settings.addMovieSetThumbFilename(MovieSetThumbNaming.MOVIESET_LANDSCAPE);
        }
        this.settings.clearMovieSetClearlogoFilenames();
        if (this.chckbxClearlogo1.isSelected()) {
            this.settings.addMovieSetClearlogoFilename(MovieSetClearlogoNaming.MOVIE_CLEARLOGO);
        }
        if (this.chckbxClearlogo2.isSelected()) {
            this.settings.addMovieSetClearlogoFilename(MovieSetClearlogoNaming.KODI_CLEARLOGO);
        }
        if (this.chckbxClearlogo3.isSelected()) {
            this.settings.addMovieSetClearlogoFilename(MovieSetClearlogoNaming.AUTOMATOR_CLEARLOGO);
        }
        if (this.chckbxClearlogo4.isSelected()) {
            this.settings.addMovieSetClearlogoFilename(MovieSetClearlogoNaming.MOVIESET_CLEARLOGO);
        }
        if (this.chckbxLogo1.isSelected()) {
            this.settings.addMovieSetClearlogoFilename(MovieSetClearlogoNaming.MOVIE_LOGO);
        }
        if (this.chckbxLogo2.isSelected()) {
            this.settings.addMovieSetClearlogoFilename(MovieSetClearlogoNaming.KODI_LOGO);
        }
        if (this.chckbxLogo3.isSelected()) {
            this.settings.addMovieSetClearlogoFilename(MovieSetClearlogoNaming.AUTOMATOR_LOGO);
        }
        if (this.chckbxLogo4.isSelected()) {
            this.settings.addMovieSetClearlogoFilename(MovieSetClearlogoNaming.MOVIESET_LOGO);
        }
        this.settings.clearMovieSetDiscartFilenames();
        if (this.chckbxDiscart1.isSelected()) {
            this.settings.addMovieSetDiscartFilename(MovieSetDiscartNaming.MOVIE_DISC);
        }
        if (this.chckbxDiscart2.isSelected()) {
            this.settings.addMovieSetDiscartFilename(MovieSetDiscartNaming.KODI_DISC);
        }
        if (this.chckbxDiscart3.isSelected()) {
            this.settings.addMovieSetDiscartFilename(MovieSetDiscartNaming.AUTOMATOR_DISC);
        }
        if (this.chckbxDiscart4.isSelected()) {
            this.settings.addMovieSetDiscartFilename(MovieSetDiscartNaming.MOVIE_DISCART);
        }
        if (this.chckbxDiscart5.isSelected()) {
            this.settings.addMovieSetDiscartFilename(MovieSetDiscartNaming.KODI_DISCART);
        }
        if (this.chckbxDiscart6.isSelected()) {
            this.settings.addMovieSetDiscartFilename(MovieSetDiscartNaming.AUTOMATOR_DISCART);
        }
        if (this.chckbxDiscart7.isSelected()) {
            this.settings.addMovieSetDiscartFilename(MovieSetDiscartNaming.MOVIESET_DISC);
        }
        if (this.chckbxDiscart8.isSelected()) {
            this.settings.addMovieSetDiscartFilename(MovieSetDiscartNaming.MOVIESET_DISCART);
        }
    }

    protected void initDataBindings() {
        BeanProperty movieSettingsBeanProperty = BeanProperty.create((String)"scrapeBestImageMovieSet");
        BeanProperty jCheckBoxBeanProperty = BeanProperty.create((String)"selected");
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)movieSettingsBeanProperty, (Object)this.chckbxAutomaticScrape, (Property)jCheckBoxBeanProperty);
        autoBinding.bind();
        BeanProperty movieSettingsBeanProperty_1 = BeanProperty.create((String)"movieSetTitleCharacterReplacement");
        BeanProperty jComboBoxBeanProperty = BeanProperty.create((String)"selectedItem");
        AutoBinding autoBinding_1 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)movieSettingsBeanProperty_1, (Object)this.cbReplacement, (Property)jComboBoxBeanProperty);
        autoBinding_1.bind();
        BeanProperty movieSettingsBeanProperty_2 = BeanProperty.create((String)"movieSetAppendTmdbId");
        BeanProperty jCheckBoxBeanProperty_2 = BeanProperty.create((String)"selected");
        AutoBinding autoBinding_2 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)movieSettingsBeanProperty_2, (Object)this.chckbxAppendTmdbId, (Property)jCheckBoxBeanProperty_2);
        autoBinding_2.bind();
    }
}

