/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.moviesets.dialogs;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.AbstractSettings;
import org.tinymediamanager.core.TmmProperties;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.components.NoBorderScrollPane;
import org.tinymediamanager.ui.components.button.FlatButton;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.components.tabbedpane.TmmTabbedPane;
import org.tinymediamanager.ui.components.tree.TmmTreeNode;
import org.tinymediamanager.ui.components.treetable.TmmTreeTable;
import org.tinymediamanager.ui.dialogs.TmmDialog;
import org.tinymediamanager.ui.moviesets.filters.IMovieSetUIFilter;
import org.tinymediamanager.ui.moviesets.filters.MovieSetDatasourceFilter;
import org.tinymediamanager.ui.moviesets.filters.MovieSetMissingMoviesFilter;
import org.tinymediamanager.ui.moviesets.filters.MovieSetNewMoviesFilter;
import org.tinymediamanager.ui.moviesets.filters.MovieSetWithMoreThanOneMovieFilter;
import org.tinymediamanager.ui.panels.FilterSavePanel;
import org.tinymediamanager.ui.panels.ModalPopupPanel;

public class MovieSetFilterDialog
extends TmmDialog {
    private static final String PANEL_COL_CONSTRAINTS = "[][][][200lp:250lp,grow]";
    private final TmmTreeTable treeTable;
    private final Map<JPanel, Set<IMovieSetUIFilter<?>>> filterMap;
    private final Set<IMovieSetUIFilter<?>> filters;
    private final JTabbedPane tabbedPane;
    private JComboBox<String> cbPreset;

    public MovieSetFilterDialog(TmmTreeTable treeTable) {
        super(TmmResourceBundle.getString("movieextendedsearch.options") + " - " + TmmResourceBundle.getString("tmm.moviesets"), "movieSetFilter");
        this.setModalityType(Dialog.ModalityType.MODELESS);
        this.treeTable = treeTable;
        this.filterMap = new HashMap();
        this.filters = new HashSet();
        this.treeTable.addPropertyChangeListener("filterChanged", evt -> this.filterChanged());
        ActionListener actionListener = e -> {
            String filterName = (String)this.cbPreset.getSelectedItem();
            if (StringUtils.isNotBlank((CharSequence)filterName)) {
                treeTable.setFilterValues(MovieModuleManager.getInstance().getSettings().getMovieSetUiFilterPresets().get(filterName));
                treeTable.storeFilters();
            } else {
                treeTable.clearFilter();
            }
        };
        this.tabbedPane = new TmmTabbedPane();
        this.getContentPane().add((Component)this.tabbedPane, "Center");
        JPanel panelMain = new JPanel((LayoutManager)new MigLayout("", PANEL_COL_CONSTRAINTS, "[]"));
        this.tabbedPane.addTab(TmmResourceBundle.getString("metatag.details"), this.createTabPanel(panelMain));
        this.addFilter(new MovieSetNewMoviesFilter(), panelMain);
        this.addFilter(new MovieSetWithMoreThanOneMovieFilter(), panelMain);
        this.addFilter(new MovieSetDatasourceFilter(), panelMain);
        this.addFilter(new MovieSetMissingMoviesFilter(), panelMain);
        JPanel panelFilterPreset = new JPanel();
        panelFilterPreset.setLayout((LayoutManager)new MigLayout("insets n 0 n 0", "[5lp!][10lp][150lp,grow][5lp!]", "[]"));
        JSeparator separator = new JSeparator();
        panelFilterPreset.add((Component)separator, "cell 0 1 4 1,growx,aligny top");
        TmmLabel lblEnableAllT = new TmmLabel(TmmResourceBundle.getString("filter.enableall"));
        panelFilterPreset.add((Component)lblEnableAllT, "cell 1 2, alignx trailing");
        JCheckBox chkbxEnableAll = new JCheckBox();
        chkbxEnableAll.setSelected(true);
        chkbxEnableAll.addActionListener(e -> treeTable.setFiltersActive(chkbxEnableAll.isSelected()));
        panelFilterPreset.add((Component)chkbxEnableAll, "cell 2 2");
        TmmLabel lblFilterPresetT = new TmmLabel(TmmResourceBundle.getString("filter.presets"));
        panelFilterPreset.add((Component)lblFilterPresetT, "cell 1 3, alignx trailing");
        this.cbPreset = new JComboBox();
        panelFilterPreset.add(this.cbPreset, "cell 2 3");
        FlatButton btnSavePreset = new FlatButton(IconManager.SAVE);
        btnSavePreset.setToolTipText(TmmResourceBundle.getString("filter.savepreset"));
        btnSavePreset.addActionListener(e -> {
            Set<AbstractSettings.UIFilters> activeUiFilters = this.getActiveUiFilters();
            if (!activeUiFilters.isEmpty()) {
                HashMap<String, List<AbstractSettings.UIFilters>> uiFilters = new HashMap<String, List<AbstractSettings.UIFilters>>(MovieModuleManager.getInstance().getSettings().getMovieSetUiFilterPresets());
                ModalPopupPanel popupPanel = this.createModalPopupPanel();
                popupPanel.setTitle(TmmResourceBundle.getString("filter.savepreset"));
                FilterSavePanel filterSavePanel = new FilterSavePanel(activeUiFilters, uiFilters);
                popupPanel.setOnCloseHandler(() -> {
                    String savedPreset = filterSavePanel.getSavedPreset();
                    if (StringUtils.isNotBlank((CharSequence)savedPreset)) {
                        this.cbPreset.removeActionListener(actionListener);
                        MovieModuleManager.getInstance().getSettings().setMovieSetUiFilterPresets(uiFilters);
                        MovieModuleManager.getInstance().getSettings().saveSettings();
                        this.loadPresets();
                        this.cbPreset.setSelectedItem(savedPreset);
                        this.cbPreset.addActionListener(actionListener);
                    }
                });
                popupPanel.setContent(filterSavePanel);
                this.showModalPopupPanel(popupPanel);
            }
        });
        panelFilterPreset.add((Component)btnSavePreset, "cell 2 3");
        FlatButton btnDeletePreset = new FlatButton(IconManager.DELETE_GRAY);
        btnDeletePreset.setToolTipText(TmmResourceBundle.getString("filter.remove"));
        btnDeletePreset.addActionListener(e -> {
            HashMap<String, List<AbstractSettings.UIFilters>> uiFilters;
            String filterName = (String)this.cbPreset.getSelectedItem();
            if (StringUtils.isBlank((CharSequence)filterName)) {
                return;
            }
            if (!TmmProperties.getInstance().getPropertyAsBoolean("movieset.hidefilterhint")) {
                JCheckBox checkBox = new JCheckBox(TmmResourceBundle.getString("tmm.donotshowagain"));
                TmmFontHelper.changeFont((JComponent)checkBox, 0.91667);
                checkBox.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
                Object[] options = new Object[]{TmmResourceBundle.getString("Button.yes"), TmmResourceBundle.getString("Button.no")};
                Object[] params = new Object[]{TmmResourceBundle.getString("filter.remove"), checkBox};
                int answer = JOptionPane.showOptionDialog(MainWindow.getInstance(), params, TmmResourceBundle.getString("filter.remove"), 0, 3, null, options, null);
                if (checkBox.isSelected()) {
                    TmmProperties.getInstance().putProperty("movieset.hidefilterhint", String.valueOf(checkBox.isSelected()));
                }
                if (answer != 0) {
                    return;
                }
            }
            if ((uiFilters = new HashMap<String, List<AbstractSettings.UIFilters>>(MovieModuleManager.getInstance().getSettings().getMovieSetUiFilterPresets())).remove(filterName) != null) {
                this.cbPreset.removeActionListener(actionListener);
                MovieModuleManager.getInstance().getSettings().setMovieSetUiFilterPresets(uiFilters);
                MovieModuleManager.getInstance().getSettings().saveSettings();
                this.loadPresets();
                this.cbPreset.addActionListener(actionListener);
            }
        });
        panelFilterPreset.add((Component)btnDeletePreset, "cell 2 3");
        this.getContentPane().add((Component)panelFilterPreset, "South");
        this.loadPresets();
        this.cbPreset.addActionListener(actionListener);
    }

    private JPanel createTabPanel(JPanel content) {
        JPanel panel = new JPanel((LayoutManager)new MigLayout("insets 0", "[grow][]", "[][][]"));
        panel.add((Component)new TmmLabel(TmmResourceBundle.getString("movieextendedsearch.filterby")), "cell 0 0");
        panel.add((Component)new JLabel(TmmResourceBundle.getString("filter.reset")), "cell 1 0, right");
        panel.add((Component)new FlatButton(IconManager.DELETE, e -> SwingUtilities.invokeLater(this.treeTable::clearFilter)), "cell 1 0, right");
        NoBorderScrollPane scrollPane = new NoBorderScrollPane(content);
        scrollPane.setHorizontalScrollBarPolicy(31);
        scrollPane.getVerticalScrollBar().setUnitIncrement(4);
        panel.add((Component)scrollPane, "cell 0 2 2 1, grow, wrap");
        return panel;
    }

    private Set<AbstractSettings.UIFilters> getActiveUiFilters() {
        return new HashSet<AbstractSettings.UIFilters>(IMovieSetUIFilter.morphToUiFilters(this.filters));
    }

    private void loadPresets() {
        String preset = (String)this.cbPreset.getSelectedItem();
        this.cbPreset.removeAllItems();
        this.cbPreset.addItem("");
        MovieModuleManager.getInstance().getSettings().getMovieSetUiFilterPresets().keySet().stream().sorted().forEach(key -> this.cbPreset.addItem((String)key));
        if (StringUtils.isNotBlank((CharSequence)preset)) {
            this.cbPreset.setSelectedItem(preset);
        }
    }

    private void addFilter(IMovieSetUIFilter<TmmTreeNode> filter, JPanel panel) {
        panel.add((Component)filter.getCheckBox(), "");
        panel.add((Component)filter.getLabel(), "");
        if (filter.getFilterOptionComboBox() != null) {
            panel.add(filter.getFilterOptionComboBox(), "");
        } else {
            panel.add(Box.createGlue(), "");
        }
        if (filter.getFilterComponent() != null) {
            panel.add((Component)filter.getFilterComponent(), "wmin 100, grow, wrap");
        } else {
            panel.add(Box.createGlue(), "wrap");
        }
        this.filterMap.computeIfAbsent(panel, k -> new HashSet()).add(filter);
        this.filters.add(filter);
        this.treeTable.addFilter(filter);
    }

    private void filterChanged() {
        block3: for (Map.Entry<JPanel, Set<IMovieSetUIFilter<?>>> entry : this.filterMap.entrySet()) {
            boolean active = false;
            if (this.treeTable.isFiltersActive()) {
                for (IMovieSetUIFilter<?> filter : entry.getValue()) {
                    switch (filter.getFilterState()) {
                        case ACTIVE: 
                        case ACTIVE_NEGATIVE: {
                            active = true;
                            break;
                        }
                    }
                    if (!active) continue;
                    break;
                }
            }
            for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
                if (!SwingUtilities.isDescendingFrom(entry.getKey(), this.tabbedPane.getComponentAt(i))) continue;
                if (active) {
                    this.tabbedPane.setIconAt(i, IconManager.FILTER_ACTIVE);
                    continue block3;
                }
                this.tabbedPane.setIconAt(i, null);
                continue block3;
            }
        }
    }

    @Override
    protected void initBottomPanel() {
    }
}

