/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.moviesets.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.movie.MovieSetArtworkHelper;
import org.tinymediamanager.core.movie.entities.MovieSet;
import org.tinymediamanager.core.threading.TmmTask;
import org.tinymediamanager.core.threading.TmmTaskHandle;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.moviesets.MovieSetUIModule;

public class MovieSetCleanupArtworkAction
extends TmmAction {
    public MovieSetCleanupArtworkAction() {
        this.putValue("Name", TmmResourceBundle.getString("movieset.cleanupartwork"));
        this.putValue("ShortDescription", TmmResourceBundle.getString("movieset.cleanupartwork.desc"));
        this.putValue("SmallIcon", IconManager.IMAGE);
        this.putValue("SwingLargeIconKey", IconManager.IMAGE);
    }

    @Override
    protected void processAction(ActionEvent e) {
        final ArrayList<MovieSet> selectedMovieSets = new ArrayList<MovieSet>(MovieSetUIModule.getInstance().getSelectionModel().getSelectedMovieSets());
        if (selectedMovieSets.isEmpty()) {
            return;
        }
        TmmTaskManager.getInstance().addUnnamedTask(new TmmTask(TmmResourceBundle.getString("movieset.cleanupartwork"), selectedMovieSets.size(), TmmTaskHandle.TaskType.BACKGROUND_TASK){

            @Override
            protected void doInBackground() {
                int i = 0;
                for (MovieSet movieSet : selectedMovieSets) {
                    MovieSetArtworkHelper.cleanupArtwork(movieSet);
                    this.publishState(++i);
                    if (!this.cancel) continue;
                    break;
                }
            }
        });
    }
}

