/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.dialogs;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.ObservableElementList;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayer;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.observablecollections.ObservableCollections;
import org.jdesktop.swingbinding.JListBinding;
import org.jdesktop.swingbinding.SwingBindings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.MediaFileHelper;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.entities.MediaGenres;
import org.tinymediamanager.core.entities.MediaRating;
import org.tinymediamanager.core.entities.MediaSource;
import org.tinymediamanager.core.entities.MediaTrailer;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.core.movie.MovieEdition;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.entities.MovieSet;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.scraper.ScraperType;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaCertification;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.thirdparty.trakttv.MovieSyncTraktTvTask;
import org.tinymediamanager.ui.ArtworkDragAndDropListener;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.ShadowLayerUI;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.components.button.FlatButton;
import org.tinymediamanager.ui.components.button.SquareIconButton;
import org.tinymediamanager.ui.components.combobox.AutocompleteComboBox;
import org.tinymediamanager.ui.components.combobox.AutocompleteSupport;
import org.tinymediamanager.ui.components.datepicker.DatePicker;
import org.tinymediamanager.ui.components.datepicker.YearSpinner;
import org.tinymediamanager.ui.components.label.ImageLabel;
import org.tinymediamanager.ui.components.label.LinkLabel;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.components.tabbedpane.TmmTabbedPane;
import org.tinymediamanager.ui.components.table.MediaIdTable;
import org.tinymediamanager.ui.components.table.MediaRatingTable;
import org.tinymediamanager.ui.components.table.MediaTrailerTable;
import org.tinymediamanager.ui.components.table.PersonTable;
import org.tinymediamanager.ui.components.table.TmmTable;
import org.tinymediamanager.ui.components.textfield.TmmObligatoryTextArea;
import org.tinymediamanager.ui.components.textfield.TmmRoundTextArea;
import org.tinymediamanager.ui.dialogs.AbstractEditorDialog;
import org.tinymediamanager.ui.dialogs.ImageChooserDialog;
import org.tinymediamanager.ui.panels.IdEditorPanel;
import org.tinymediamanager.ui.panels.MediaFileEditorPanel;
import org.tinymediamanager.ui.panels.ModalPopupPanel;
import org.tinymediamanager.ui.panels.RatingEditorPanel;

public class MovieEditorDialog
extends AbstractEditorDialog {
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieEditorDialog.class);
    private static final String ORIGINAL_IMAGE_SIZE = "originalImageSize";
    private final Movie movieToEdit;
    private final MovieList movieList = MovieModuleManager.getInstance().getMovieList();
    private final JTabbedPane tabbedPane = new TmmTabbedPane();
    private final List<MediaGenres> genres = ObservableCollections.observableList(new ArrayList());
    private final EventList<MediaTrailer> trailers;
    private final List<String> tags = ObservableCollections.observableList(new ArrayList());
    private final List<String> showlinks = ObservableCollections.observableList(new ArrayList());
    private final EventList<MediaIdTable.MediaId> ids;
    private final EventList<MediaRatingTable.Rating> ratings;
    private final List<MediaFile> mediaFiles = new ArrayList<MediaFile>();
    private final EventList<Person> cast;
    private final EventList<Person> crew;
    private List<String> extrathumbs = null;
    private List<String> extrafanarts = null;
    private JTextArea tfTitle;
    private JTextArea tfOriginalTitle;
    private JTextArea tfEnglishTitle;
    private YearSpinner spYear;
    private JTextArea taPlot;
    private ImageLabel lblPoster;
    private ImageLabel lblFanart;
    private JSpinner spRuntime;
    private JTextArea tfProductionCompanies;
    private JList<MediaGenres> listGenres;
    private AutocompleteComboBox cbGenres;
    private JSpinner spRating;
    private JComboBox<MediaCertification> cbCertification;
    private JCheckBox cbWatched;
    private JTextArea tfTagline;
    private JTextArea taNote;
    private JCheckBox chckbxVideo3D;
    private AutocompleteComboBox cbTags;
    private JList<String> listTags;
    private JList<String> listShowlink;
    private JSpinner spDateAdded;
    private JComboBox cbMovieSet;
    private JTextArea tfSorttitle;
    private JTextArea tfSpokenLanguages;
    private JTextArea tfCountry;
    private DatePicker dpReleaseDate;
    private JSpinner spTop250;
    private AutocompleteComboBox cbSource;
    private MediaFileEditorPanel mediaFilesPanel;
    private AutocompleteComboBox cbEdition;
    private JComboBox cbShowlink;
    private JTextField tfPoster;
    private JTextField tfFanart;
    private JTextField tfClearLogo;
    private JTextField tfBanner;
    private JTextField tfClearArt;
    private JTextField tfThumb;
    private JTextField tfDisc;
    private JTextField tfKeyart;
    private ImageLabel lblClearlogo;
    private ImageLabel lblBanner;
    private ImageLabel lblClearart;
    private ImageLabel lblThumb;
    private ImageLabel lblDisc;
    private ImageLabel lblKeyart;
    private TmmTable tableIds;
    private TmmTable tableRatings;
    private MediaTrailerTable tableTrailer;
    private PersonTable tableActors;
    private PersonTable tableCrew;

    public MovieEditorDialog(Movie movie, int queueIndex, int queueSize, int selectedTab) {
        super(TmmResourceBundle.getString("movie.edit") + (String)(queueSize > 1 ? " " + (queueIndex + 1) + "/" + queueSize : "") + "  < " + movie.getPathNIO() + " >", "movieEditor", movie);
        this.setMinimumSize(new Dimension(800, 600));
        this.cast = new ObservableElementList((EventList)GlazedLists.threadSafeList((EventList)new BasicEventList()), GlazedLists.beanConnector(Person.class));
        this.crew = new ObservableElementList((EventList)GlazedLists.threadSafeList((EventList)new BasicEventList()), GlazedLists.beanConnector(Person.class));
        this.trailers = new ObservableElementList((EventList)GlazedLists.threadSafeList((EventList)new BasicEventList()), GlazedLists.beanConnector(MediaTrailer.class));
        this.movieToEdit = movie;
        this.queueIndex = queueIndex;
        this.queueSize = queueSize;
        this.ids = MediaIdTable.convertIdMapToEventList(this.movieToEdit.getIds());
        this.ratings = MediaRatingTable.convertRatingMapToEventList(this.movieToEdit.getRatings(), false);
        MediaRating userMediaRating = this.movieToEdit.getRating("user");
        for (MediaFile mf : movie.getMediaFiles()) {
            this.mediaFiles.add(new MediaFile(mf));
        }
        for (Person origCast : this.movieToEdit.getActors()) {
            this.cast.add((Object)new Person(origCast));
        }
        for (Person origCrew : this.movieToEdit.getCrew()) {
            this.crew.add((Object)new Person(origCrew));
        }
        this.genres.addAll(this.movieToEdit.getGenres());
        this.trailers.addAll(this.movieToEdit.getTrailer());
        for (String tag : this.movieToEdit.getTags()) {
            if (!StringUtils.isNotBlank((CharSequence)tag)) continue;
            this.tags.add(tag);
        }
        this.initComponents();
        this.bindingGroup = this.initDataBindings();
        int year = this.movieToEdit.getYear();
        List<MediaCertification> availableCertifications = MediaCertification.getCertificationsforCountry(MovieModuleManager.getInstance().getSettings().getCertificationCountry());
        if (!availableCertifications.contains((Object)this.movieToEdit.getCertification())) {
            availableCertifications.add(0, this.movieToEdit.getCertification());
        }
        for (MediaCertification cert : availableCertifications) {
            this.cbCertification.addItem(cert);
        }
        this.tfTitle.setText(this.movieToEdit.getTitle());
        this.tfOriginalTitle.setText(this.movieToEdit.getOriginalTitle());
        this.tfEnglishTitle.setText(this.movieToEdit.getEnglishTitle());
        this.tfSorttitle.setText(this.movieToEdit.getSortTitle());
        this.spYear.setValue(year);
        this.spDateAdded.setValue(this.movieToEdit.getDateAdded());
        this.tfPoster.setText(this.movieToEdit.getArtworkUrl(MediaFileType.POSTER));
        this.tfFanart.setText(this.movieToEdit.getArtworkUrl(MediaFileType.FANART));
        this.tfClearLogo.setText(this.movieToEdit.getArtworkUrl(MediaFileType.CLEARLOGO));
        this.tfClearArt.setText(this.movieToEdit.getArtworkUrl(MediaFileType.CLEARART));
        this.tfThumb.setText(this.movieToEdit.getArtworkUrl(MediaFileType.THUMB));
        this.tfDisc.setText(this.movieToEdit.getArtworkUrl(MediaFileType.DISC));
        this.tfBanner.setText(this.movieToEdit.getArtworkUrl(MediaFileType.BANNER));
        this.tfKeyart.setText(this.movieToEdit.getArtworkUrl(MediaFileType.KEYART));
        this.lblPoster.setImagePath(this.movieToEdit.getArtworkFilename(MediaFileType.POSTER));
        this.lblFanart.setImagePath(this.movieToEdit.getArtworkFilename(MediaFileType.FANART));
        this.lblClearlogo.setImagePath(this.movieToEdit.getArtworkFilename(MediaFileType.CLEARLOGO));
        this.lblClearart.setImagePath(this.movieToEdit.getArtworkFilename(MediaFileType.CLEARART));
        this.lblThumb.setImagePath(this.movieToEdit.getArtworkFilename(MediaFileType.THUMB));
        this.lblDisc.setImagePath(this.movieToEdit.getArtworkFilename(MediaFileType.DISC));
        this.lblBanner.setImagePath(this.movieToEdit.getArtworkFilename(MediaFileType.BANNER));
        this.lblKeyart.setImagePath(this.movieToEdit.getArtworkFilename(MediaFileType.KEYART));
        this.cbEdition.setSelectedItem(this.movieToEdit.getEdition());
        this.cbCertification.setSelectedItem((Object)this.movieToEdit.getCertification());
        this.chckbxVideo3D.setSelected(this.movieToEdit.isVideoIn3D());
        this.cbSource.setSelectedItem(this.movieToEdit.getMediaSource());
        this.cbWatched.setSelected(this.movieToEdit.isWatched());
        this.tfTagline.setText(this.movieToEdit.getTagline());
        this.taPlot.setText(this.movieToEdit.getPlot());
        this.taPlot.setCaretPosition(0);
        this.spRuntime.setValue(this.movieToEdit.getRuntime());
        this.spTop250.setValue(movie.getTop250());
        this.tfProductionCompanies.setText(this.movieToEdit.getProductionCompany());
        this.tfSpokenLanguages.setText(this.movieToEdit.getSpokenLanguages());
        this.tfCountry.setText(this.movieToEdit.getCountry());
        this.spRating.setModel(new SpinnerNumberModel(userMediaRating.getRating(), 0.0, 10.0, 1.0));
        this.taNote.setText(this.movieToEdit.getNote());
        this.showlinks.addAll(this.movieToEdit.getShowlinks());
        this.showlinks.sort(Comparator.naturalOrder());
        if (MovieModuleManager.getInstance().getSettings().isImageExtraThumbs()) {
            this.extrathumbs = new ArrayList<String>(this.movieToEdit.getExtraThumbs());
        }
        if (MovieModuleManager.getInstance().getSettings().isImageExtraFanart()) {
            this.extrafanarts = new ArrayList<String>(this.movieToEdit.getExtraFanarts());
        }
        for (MovieSet movieSet : this.movieList.getSortedMovieSetList()) {
            this.cbMovieSet.addItem(movieSet);
            if (this.movieToEdit.getMovieSet() != movieSet) continue;
            this.cbMovieSet.setSelectedItem(movieSet);
        }
        for (String showTitle : this.movieList.getTvShowTitles()) {
            this.cbShowlink.addItem(showTitle);
        }
        this.tableTrailer.getModel().addTableModelListener(arg0 -> {
            int row;
            MediaTrailer changedTrailer;
            if (arg0.getColumn() == 0 && (changedTrailer = (MediaTrailer)this.trailers.get(row = arg0.getFirstRow())).getInNfo().booleanValue()) {
                for (MediaTrailer trailer : this.trailers) {
                    if (trailer == changedTrailer) continue;
                    trailer.setInNfo(Boolean.FALSE);
                }
            }
        });
        this.registerDropTarget(this.lblPoster, this.tfPoster);
        this.registerDropTarget(this.lblFanart, this.tfFanart);
        this.registerDropTarget(this.lblBanner, this.tfBanner);
        this.registerDropTarget(this.lblClearart, this.tfClearArt);
        this.registerDropTarget(this.lblClearlogo, this.tfClearLogo);
        this.registerDropTarget(this.lblThumb, this.tfThumb);
        this.registerDropTarget(this.lblDisc, this.tfDisc);
        this.registerDropTarget(this.lblKeyart, this.tfKeyart);
        this.tabbedPane.setSelectedIndex(selectedTab);
    }

    public int getSelectedTab() {
        return this.tabbedPane.getSelectedIndex();
    }

    private void initComponents() {
        JLayer<JComponent> rootLayer = new JLayer<JComponent>(this.tabbedPane, new ShadowLayerUI());
        this.getContentPane().add(rootLayer, "Center");
        JPanel details1Panel = new JPanel();
        this.tabbedPane.addTab(TmmResourceBundle.getString("metatag.details"), details1Panel);
        details1Panel.setLayout((LayoutManager)new MigLayout("", "[][75lp:n][50lp:75lp][][60lp:75lp][100lp:n][50lp:75lp,grow][25lp:n][200lp:250lp,grow]", "[][][][][][75lp:25%:25%,grow][][pref!][][][][][75lp:20%:20%,grow][50lp:50lp:100lp,grow 50]"));
        TmmLabel lblTitle = new TmmLabel(TmmResourceBundle.getString("metatag.title"));
        details1Panel.add((Component)lblTitle, "cell 0 0,alignx right");
        this.tfTitle = new TmmObligatoryTextArea();
        details1Panel.add((Component)this.tfTitle, "flowx,cell 1 0 6 1,growx,wmin 0");
        this.lblPoster = new ImageLabel();
        this.lblPoster.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ImageChooserDialog dialog = new ImageChooserDialog(MovieEditorDialog.this, MovieEditorDialog.this.createIdsForImageChooser(), MediaArtwork.MediaArtworkType.POSTER, MovieEditorDialog.this.movieList.getDefaultArtworkScrapers(), MovieEditorDialog.this.lblPoster, MediaType.MOVIE);
                if (Settings.getInstance().isImageChooserUseEntityFolder()) {
                    dialog.setOpenFolderPath(MovieEditorDialog.this.movieToEdit.getPathNIO().toAbsolutePath().toString());
                }
                dialog.setLocationRelativeTo(MainWindow.getInstance());
                dialog.setVisible(true);
                MovieEditorDialog.this.updateArtworkUrl(MovieEditorDialog.this.lblPoster, MovieEditorDialog.this.tfPoster);
            }
        });
        this.lblPoster.setCursor(Cursor.getPredefinedCursor(12));
        details1Panel.add((Component)new TmmLabel(TmmResourceBundle.getString("mediafiletype.poster")), "cell 8 0");
        LinkLabel lblPosterSize = new LinkLabel();
        details1Panel.add((Component)lblPosterSize, "cell 8 0");
        FlatButton btnDeletePoster = new FlatButton(IconManager.DELETE_GRAY);
        btnDeletePoster.setToolTipText(TmmResourceBundle.getString("Button.deleteartwork.desc"));
        btnDeletePoster.addActionListener(e -> {
            this.lblPoster.clearImage();
            this.tfPoster.setText("");
        });
        details1Panel.add((Component)btnDeletePoster, "cell 8 0");
        details1Panel.add((Component)this.lblPoster, "cell 8 1 1 7,grow");
        this.lblPoster.addPropertyChangeListener(ORIGINAL_IMAGE_SIZE, e -> this.setImageSizeAndCreateLink(lblPosterSize, this.lblPoster, btnDeletePoster, MediaFileType.POSTER));
        TmmLabel lblOriginalTitle = new TmmLabel(TmmResourceBundle.getString("metatag.originaltitle"));
        details1Panel.add((Component)lblOriginalTitle, "cell 0 1,alignx right");
        this.tfOriginalTitle = new TmmRoundTextArea();
        details1Panel.add((Component)this.tfOriginalTitle, "cell 1 1 6 1,growx,wmin 0");
        TmmLabel lblTitleEnglish = new TmmLabel(TmmResourceBundle.getString("metatag.title.english"));
        details1Panel.add((Component)lblTitleEnglish, "cell 0 2,alignx right");
        this.tfEnglishTitle = new TmmRoundTextArea();
        details1Panel.add((Component)this.tfEnglishTitle, "cell 1 2 6 1,growx,wmin 0");
        TmmLabel lblSorttitle = new TmmLabel(TmmResourceBundle.getString("metatag.sorttitle"));
        details1Panel.add((Component)lblSorttitle, "cell 0 3,alignx right");
        this.tfSorttitle = new TmmRoundTextArea();
        details1Panel.add((Component)this.tfSorttitle, "cell 1 3 6 1,growx,wmin 0");
        TmmLabel lblTagline = new TmmLabel(TmmResourceBundle.getString("metatag.tagline"));
        details1Panel.add((Component)lblTagline, "cell 0 4,alignx right");
        this.tfTagline = new TmmRoundTextArea();
        details1Panel.add((Component)this.tfTagline, "cell 1 4 6 1,growx,wmin 0");
        TmmLabel lblPlot = new TmmLabel(TmmResourceBundle.getString("metatag.plot"));
        details1Panel.add((Component)lblPlot, "cell 0 5,alignx right,aligny top");
        JScrollPane scrollPanePlot = new JScrollPane();
        details1Panel.add((Component)scrollPanePlot, "cell 1 5 6 1,wmin 0,grow");
        this.taPlot = new JTextArea();
        this.taPlot.setLineWrap(true);
        this.taPlot.setWrapStyleWord(true);
        this.taPlot.setForeground(UIManager.getColor("TextField.foreground"));
        this.taPlot.setFocusTraversalKeys(0, null);
        this.taPlot.setFocusTraversalKeys(1, null);
        scrollPanePlot.setViewportView(this.taPlot);
        TmmLabel lblYear = new TmmLabel(TmmResourceBundle.getString("metatag.year"));
        details1Panel.add((Component)lblYear, "cell 0 6,alignx right");
        this.spYear = new YearSpinner();
        details1Panel.add((Component)this.spYear, "cell 1 6,growx");
        TmmLabel lblReleaseDate = new TmmLabel(TmmResourceBundle.getString("metatag.releasedate"));
        details1Panel.add((Component)lblReleaseDate, "cell 3 6,alignx right");
        this.dpReleaseDate = new DatePicker(this.movieToEdit.getReleaseDate());
        details1Panel.add((Component)this.dpReleaseDate, "cell 4 6 2 1,growx");
        TmmLabel lblCompany = new TmmLabel(TmmResourceBundle.getString("metatag.production"));
        details1Panel.add((Component)lblCompany, "cell 0 7,alignx right");
        this.tfProductionCompanies = new TmmRoundTextArea();
        details1Panel.add((Component)this.tfProductionCompanies, "cell 1 7 6 1,growx,wmin 0");
        TmmLabel lblCountry = new TmmLabel(TmmResourceBundle.getString("metatag.country"));
        details1Panel.add((Component)lblCountry, "cell 0 8,alignx right");
        this.tfCountry = new TmmRoundTextArea();
        details1Panel.add((Component)this.tfCountry, "cell 1 8 6 1,growx,wmin 0");
        TmmLabel lblSpokenLanguages = new TmmLabel(TmmResourceBundle.getString("metatag.spokenlanguages"));
        details1Panel.add((Component)lblSpokenLanguages, "cell 0 9,alignx right");
        this.tfSpokenLanguages = new TmmRoundTextArea();
        details1Panel.add((Component)this.tfSpokenLanguages, "cell 1 9 6 1,growx,wmin 0");
        TmmLabel lblCertification = new TmmLabel(TmmResourceBundle.getString("metatag.certification"));
        details1Panel.add((Component)lblCertification, "cell 0 10,alignx right");
        this.cbCertification = new JComboBox();
        details1Panel.add(this.cbCertification, "cell 1 10,growx");
        this.cbCertification.setSelectedItem((Object)this.movieToEdit.getCertification());
        TmmLabel lblRating = new TmmLabel(TmmResourceBundle.getString("metatag.userrating"));
        details1Panel.add((Component)lblRating, "cell 0 11,alignx right");
        this.spRating = new JSpinner();
        details1Panel.add((Component)this.spRating, "cell 1 11,growx");
        JLabel lblUserRatingHint = new JLabel(IconManager.HINT);
        lblUserRatingHint.setToolTipText(TmmResourceBundle.getString("edit.userrating.hint"));
        details1Panel.add((Component)lblUserRatingHint, "cell 2 11");
        TmmLabel lblRatingsT = new TmmLabel(TmmResourceBundle.getString("metatag.ratings"));
        details1Panel.add((Component)lblRatingsT, "flowy,cell 0 12,alignx right,aligny top");
        JScrollPane scrollPaneRatings = new JScrollPane();
        details1Panel.add((Component)scrollPaneRatings, "cell 1 12 5 1,wmin 0,grow");
        this.tableRatings = new MediaRatingTable(this.ratings);
        this.tableRatings.configureScrollPane(scrollPaneRatings);
        TmmLabel lblTop = new TmmLabel(TmmResourceBundle.getString("metatag.top250"));
        details1Panel.add((Component)lblTop, "cell 3 11,alignx right");
        this.spTop250 = new JSpinner();
        details1Panel.add((Component)this.spTop250, "cell 4 11,growx");
        this.lblFanart = new ImageLabel();
        this.lblFanart.setCursor(Cursor.getPredefinedCursor(12));
        this.lblFanart.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ImageChooserDialog dialog = new ImageChooserDialog(MovieEditorDialog.this, MovieEditorDialog.this.createIdsForImageChooser(), MediaArtwork.MediaArtworkType.BACKGROUND, MovieEditorDialog.this.movieList.getDefaultArtworkScrapers(), MovieEditorDialog.this.lblFanart, MediaType.MOVIE);
                dialog.bindExtraFanarts(MovieEditorDialog.this.extrafanarts);
                dialog.bindExtraThumbs(MovieEditorDialog.this.extrathumbs);
                if (Settings.getInstance().isImageChooserUseEntityFolder()) {
                    dialog.setOpenFolderPath(MovieEditorDialog.this.movieToEdit.getPathNIO().toAbsolutePath().toString());
                }
                dialog.setLocationRelativeTo(MainWindow.getInstance());
                dialog.setVisible(true);
                MovieEditorDialog.this.updateArtworkUrl(MovieEditorDialog.this.lblFanart, MovieEditorDialog.this.tfFanart);
            }
        });
        details1Panel.add((Component)new TmmLabel(TmmResourceBundle.getString("mediafiletype.fanart")), "cell 8 9");
        LinkLabel lblFanartSize = new LinkLabel();
        details1Panel.add((Component)lblFanartSize, "cell 8 9");
        FlatButton btnDeleteFanart = new FlatButton(IconManager.DELETE_GRAY);
        btnDeleteFanart.setToolTipText(TmmResourceBundle.getString("Button.deleteartwork.desc"));
        btnDeleteFanart.addActionListener(e -> {
            this.lblFanart.clearImage();
            this.tfFanart.setText("");
        });
        details1Panel.add((Component)btnDeleteFanart, "cell 8 9");
        details1Panel.add((Component)this.lblFanart, "cell 8 10 1 4,grow");
        this.lblFanart.addPropertyChangeListener(ORIGINAL_IMAGE_SIZE, e -> this.setImageSizeAndCreateLink(lblFanartSize, this.lblFanart, btnDeleteFanart, MediaFileType.FANART));
        SquareIconButton btnAddRating = new SquareIconButton(new AddRatingAction());
        details1Panel.add((Component)btnAddRating, "cell 0 12,alignx right,aligny top");
        SquareIconButton btnRemoveRating = new SquareIconButton(new RemoveRatingAction());
        details1Panel.add((Component)btnRemoveRating, "cell 0 12,alignx right,aligny top");
        SquareIconButton btnPlay = new SquareIconButton(IconManager.PLAY_INV);
        btnPlay.addActionListener(e -> {
            MediaFile mf = this.movieToEdit.getMainVideoFile();
            try {
                TmmUIHelper.openFile(MediaFileHelper.getMainVideoFile(mf));
            }
            catch (Exception ex) {
                LOGGER.error("Could not open file manager - '{}'", (Object)ex.getMessage());
                MessageManager.getInstance().pushMessage(new Message(Message.MessageLevel.ERROR, (Object)mf, "message.erroropenfile", new String[]{":", ex.getLocalizedMessage()}));
            }
        });
        details1Panel.add((Component)btnPlay, "cell 1 0 6 1");
        TmmLabel lblNoteT = new TmmLabel(TmmResourceBundle.getString("metatag.note"));
        details1Panel.add((Component)lblNoteT, "cell 0 13,alignx right,aligny top");
        JScrollPane scrollPane = new JScrollPane();
        details1Panel.add((Component)scrollPane, "cell 1 13 6 1,wmin 0,grow");
        this.taNote = new JTextArea();
        this.taNote.setLineWrap(true);
        this.taNote.setWrapStyleWord(true);
        this.taNote.setForeground(UIManager.getColor("TextField.foreground"));
        this.taNote.setFocusTraversalKeys(0, null);
        this.taNote.setFocusTraversalKeys(1, null);
        scrollPane.setViewportView(this.taNote);
        JPanel details2Panel = new JPanel();
        this.tabbedPane.addTab(TmmResourceBundle.getString("metatag.details2"), details2Panel);
        details2Panel.setLayout((LayoutManager)new MigLayout("", "[][150lp:n][20lp:50lp][][50lp:100lp][20lp:n][grow][300lp:300lp,grow]", "[][][][][][75lp][pref!][20lp:n][100lp:150lp,grow][][grow]"));
        TmmLabel lblDateAdded = new TmmLabel(TmmResourceBundle.getString("metatag.dateadded"));
        details2Panel.add((Component)lblDateAdded, "cell 0 0,alignx right");
        this.spDateAdded = new JSpinner(new SpinnerDateModel());
        details2Panel.add((Component)this.spDateAdded, "cell 1 0,growx");
        TmmLabel lblWatched = new TmmLabel(TmmResourceBundle.getString("metatag.watched"));
        details2Panel.add((Component)lblWatched, "flowx,cell 3 0");
        this.cbWatched = new JCheckBox("");
        details2Panel.add((Component)this.cbWatched, "cell 3 0");
        TmmLabel label = new TmmLabel("3D");
        details2Panel.add((Component)label, "flowx,cell 3 1");
        this.chckbxVideo3D = new JCheckBox("");
        details2Panel.add((Component)this.chckbxVideo3D, "cell 3 1");
        TmmLabel lblIds = new TmmLabel(TmmResourceBundle.getString("metatag.ids"));
        details2Panel.add((Component)lblIds, "flowy,cell 6 0 1 3,alignx right,aligny top");
        JScrollPane scrollPaneIds = new JScrollPane();
        details2Panel.add((Component)scrollPaneIds, "cell 7 0 1 7,growx");
        this.tableIds = new MediaIdTable(this.ids, ScraperType.MOVIE);
        this.tableIds.configureScrollPane(scrollPaneIds);
        SquareIconButton btnAddId = new SquareIconButton(new AddIdAction());
        details2Panel.add((Component)btnAddId, "cell 6 0 1 3,alignx right,aligny top");
        SquareIconButton btnRemoveId = new SquareIconButton(new RemoveIdAction());
        details2Panel.add((Component)btnRemoveId, "cell 6 0 1 3,alignx right,aligny top");
        TmmLabel lblSourceT = new TmmLabel(TmmResourceBundle.getString("metatag.source"));
        details2Panel.add((Component)lblSourceT, "cell 0 1,alignx right");
        this.cbSource = new AutocompleteComboBox<MediaSource>(MediaSource.values());
        details2Panel.add((Component)this.cbSource, "cell 1 1,growx");
        TmmLabel lblEditionT = new TmmLabel(TmmResourceBundle.getString("metatag.edition"));
        details2Panel.add((Component)lblEditionT, "cell 0 2,alignx right");
        this.cbEdition = new AutocompleteComboBox<MovieEdition>(MovieEdition.values());
        this.cbEdition.getAutoCompleteSupport().setCorrectsCase(false);
        details2Panel.add((Component)this.cbEdition, "cell 1 2,growx");
        TmmLabel lblRuntime = new TmmLabel(TmmResourceBundle.getString("metatag.runtime"));
        details2Panel.add((Component)lblRuntime, "cell 0 3,alignx right");
        this.spRuntime = new JSpinner();
        details2Panel.add((Component)this.spRuntime, "flowx,cell 1 3,growx");
        JLabel lblMin = new JLabel(TmmResourceBundle.getString("metatag.minutes"));
        details2Panel.add((Component)lblMin, "cell 1 3");
        TmmLabel lblMovieSet = new TmmLabel(TmmResourceBundle.getString("metatag.movieset"));
        details2Panel.add((Component)lblMovieSet, "cell 0 4,alignx right");
        this.cbMovieSet = new JComboBox();
        this.cbMovieSet.addItem("");
        details2Panel.add((Component)this.cbMovieSet, "cell 1 4 4 1, growx, wmin 0");
        SquareIconButton btnAddMovieSet = new SquareIconButton(IconManager.ADD_INV);
        btnAddMovieSet.addActionListener(listener -> {
            String name = JOptionPane.showInputDialog(MainWindow.getInstance(), TmmResourceBundle.getString("movieset.title"), "", 3);
            if (StringUtils.isNotEmpty((CharSequence)name)) {
                MovieSet movieSet = new MovieSet(name);
                movieSet.saveToDb();
                MovieModuleManager.getInstance().getMovieList().addMovieSet(movieSet);
                this.cbMovieSet.addItem(movieSet);
                this.cbMovieSet.setSelectedItem(movieSet);
            }
        });
        details2Panel.add((Component)btnAddMovieSet, "cell 1 4 4 1");
        TmmLabel lblShowlinkT = new TmmLabel(TmmResourceBundle.getString("metatag.showlink"));
        details2Panel.add((Component)lblShowlinkT, "flowy,cell 0 5,alignx right,aligny top");
        this.listShowlink = new JList();
        JScrollPane scrollPaneShowlink = new JScrollPane();
        scrollPaneShowlink.setViewportView(this.listShowlink);
        details2Panel.add((Component)scrollPaneShowlink, "cell 1 5 4 1,grow");
        this.cbShowlink = new JComboBox();
        details2Panel.add((Component)this.cbShowlink, "cell 1 6 4 1, growx, wmin 0");
        TmmLabel lblGenres = new TmmLabel(TmmResourceBundle.getString("metatag.genre"));
        details2Panel.add((Component)lblGenres, "flowy,cell 0 8,alignx right,aligny top");
        JScrollPane scrollPaneGenres = new JScrollPane();
        details2Panel.add((Component)scrollPaneGenres, "cell 1 8 4 1,grow");
        this.listGenres = new JList();
        scrollPaneGenres.setViewportView(this.listGenres);
        this.cbGenres = new AutocompleteComboBox<MediaGenres>(MediaGenres.values());
        InputMap im = this.cbGenres.getInputMap(1);
        Object enterAction = im.get(KeyStroke.getKeyStroke(10, 0));
        this.cbGenres.getActionMap().put(enterAction, new AddGenreAction());
        details2Panel.add((Component)this.cbGenres, "cell 1 9 4 1,growx,wmin 0");
        SquareIconButton btnAddGenre = new SquareIconButton(new AddGenreAction());
        details2Panel.add((Component)btnAddGenre, "cell 0 8,alignx right,aligny top");
        SquareIconButton btnRemoveGenre = new SquareIconButton(new RemoveGenreAction());
        details2Panel.add((Component)btnRemoveGenre, "cell 0 8,alignx right,aligny top");
        SquareIconButton btnMoveGenreUp = new SquareIconButton(new MoveGenreUpAction());
        details2Panel.add((Component)btnMoveGenreUp, "cell 0 8,alignx right,aligny top");
        SquareIconButton btnMoveGenreDown = new SquareIconButton(new MoveGenreDownAction());
        details2Panel.add((Component)btnMoveGenreDown, "cell 0 8,alignx right,aligny top");
        TmmLabel lblTags = new TmmLabel(TmmResourceBundle.getString("metatag.tags"));
        details2Panel.add((Component)lblTags, "flowy,cell 6 8,alignx right,aligny top");
        JScrollPane scrollPaneTags = new JScrollPane();
        details2Panel.add((Component)scrollPaneTags, "cell 7 8,grow");
        this.listTags = new JList();
        scrollPaneTags.setViewportView(this.listTags);
        this.cbTags = new AutocompleteComboBox<String>(this.movieList.getTagsInMovies());
        im = this.cbTags.getInputMap(1);
        enterAction = im.get(KeyStroke.getKeyStroke(10, 0));
        this.cbTags.getActionMap().put(enterAction, new AddTagAction());
        details2Panel.add((Component)this.cbTags, "cell 7 9,growx,wmin 0");
        SquareIconButton btnAddTag = new SquareIconButton(new AddTagAction());
        details2Panel.add((Component)btnAddTag, "cell 6 8,alignx right,aligny top");
        SquareIconButton btnRemoveTag = new SquareIconButton(new RemoveTagAction());
        details2Panel.add((Component)btnRemoveTag, "cell 6 8,alignx right,aligny top");
        SquareIconButton btnMoveTagUp = new SquareIconButton(new MoveTagUpAction());
        details2Panel.add((Component)btnMoveTagUp, "cell 6 8,alignx right,aligny top");
        SquareIconButton btnMoveTagDown = new SquareIconButton(new MoveTagDownAction());
        details2Panel.add((Component)btnMoveTagDown, "cell 6 8,alignx right,aligny top");
        SquareIconButton btnAddShowlink = new SquareIconButton(new AddShowlinkAction());
        details2Panel.add((Component)btnAddShowlink, "cell 0 5,alignx right");
        SquareIconButton btnRemoveShowlink = new SquareIconButton(new RemoveShowlinkAction());
        details2Panel.add((Component)btnRemoveShowlink, "cell 0 5,alignx right");
        JPanel crewPanel = new JPanel();
        this.tabbedPane.addTab(TmmResourceBundle.getString("movie.edit.castandcrew"), null, crewPanel, null);
        crewPanel.setLayout((LayoutManager)new MigLayout("", "[][150lp:300lp,grow][20lp:n][][150lp:300lp,grow]", "[200lp:400lp,grow]"));
        TmmLabel lblActors = new TmmLabel(TmmResourceBundle.getString("metatag.actors"));
        crewPanel.add((Component)lblActors, "flowy,cell 0 0,alignx right,aligny top");
        this.tableActors = new PersonTable(this.cast);
        this.tableActors.setAddTitle(TmmResourceBundle.getString("cast.actor.add"));
        this.tableActors.setEditTitle(TmmResourceBundle.getString("cast.actor.edit"));
        this.tableActors.setAllowedEditorTypes(new Person.Type[]{Person.Type.ACTOR});
        scrollPane = new JScrollPane();
        this.tableActors.configureScrollPane(scrollPane);
        crewPanel.add((Component)scrollPane, "cell 1 0,grow");
        TmmLabel lblProducers = new TmmLabel(TmmResourceBundle.getString("metatag.crew"));
        crewPanel.add((Component)lblProducers, "flowy,cell 3 0,alignx right,aligny top");
        this.tableCrew = new PersonTable(this.crew);
        this.tableCrew.setAddTitle(TmmResourceBundle.getString("cast.crew.add"));
        this.tableCrew.setEditTitle(TmmResourceBundle.getString("cast.crew.edit"));
        this.tableCrew.setAllowedEditorTypes(new Person.Type[]{Person.Type.DIRECTOR, Person.Type.WRITER, Person.Type.PRODUCER, Person.Type.COMPOSER, Person.Type.EDITOR, Person.Type.CAMERA, Person.Type.OTHER});
        scrollPane = new JScrollPane();
        this.tableCrew.configureScrollPane(scrollPane);
        crewPanel.add((Component)scrollPane, "cell 4 0,grow");
        SquareIconButton btnAddActor = new SquareIconButton(new AddActorAction());
        crewPanel.add((Component)btnAddActor, "cell 0 0,alignx right");
        SquareIconButton btnRemoveActor = new SquareIconButton(new RemoveActorAction());
        crewPanel.add((Component)btnRemoveActor, "cell 0 0,alignx right");
        SquareIconButton btnMoveActorUp = new SquareIconButton(new MoveActorUpAction());
        crewPanel.add((Component)btnMoveActorUp, "cell 0 0,alignx right");
        SquareIconButton btnMoveActorDown = new SquareIconButton(new MoveActorDownAction());
        crewPanel.add((Component)btnMoveActorDown, "cell 0 0,alignx right,aligny top");
        SquareIconButton btnAddCrew = new SquareIconButton(new AddCrewAction());
        crewPanel.add((Component)btnAddCrew, "cell 3 0,alignx right");
        SquareIconButton btnRemoveCrew = new SquareIconButton(new RemoveCrewAction());
        crewPanel.add((Component)btnRemoveCrew, "cell 3 0,alignx right");
        SquareIconButton btnMoveCrewUp = new SquareIconButton(new MoveCrewUpAction());
        crewPanel.add((Component)btnMoveCrewUp, "cell 3 0,alignx right");
        SquareIconButton btnMoveCrewDown = new SquareIconButton(new MoveCrewDownAction());
        crewPanel.add((Component)btnMoveCrewDown, "cell 3 0,alignx right,aligny top");
        JPanel artworkPanel = new JPanel();
        this.tabbedPane.addTab(TmmResourceBundle.getString("metatag.extraartwork"), null, artworkPanel, null);
        artworkPanel.setLayout((LayoutManager)new MigLayout("", "[20%:35%:35%,grow][20lp:n][20%:35%:35%,grow][20lp:n][15%:30%:30%,grow]", "[][100lp:30%:30%,grow][20lp:n][][100lp:30%:30%,grow][20lp:n][][150lp:30%:30%,grow]"));
        TmmLabel lblKeyartT = new TmmLabel(TmmResourceBundle.getString("mediafiletype.keyart"));
        artworkPanel.add((Component)lblKeyartT, "cell 4 0");
        LinkLabel lblKeyartSize = new LinkLabel();
        artworkPanel.add((Component)lblKeyartSize, "cell 4 0");
        FlatButton btnDeleteKeyart = new FlatButton(IconManager.DELETE_GRAY);
        btnDeleteKeyart.setToolTipText(TmmResourceBundle.getString("Button.deleteartwork.desc"));
        btnDeleteKeyart.addActionListener(e -> {
            this.lblKeyart.clearImage();
            this.tfKeyart.setText("");
        });
        artworkPanel.add((Component)btnDeleteKeyart, "cell 4 0");
        this.lblKeyart = new ImageLabel();
        this.lblKeyart.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ImageChooserDialog dialog = new ImageChooserDialog(MovieEditorDialog.this, MovieEditorDialog.this.createIdsForImageChooser(), MediaArtwork.MediaArtworkType.KEYART, MovieEditorDialog.this.movieList.getDefaultArtworkScrapers(), MovieEditorDialog.this.lblKeyart, MediaType.MOVIE);
                if (Settings.getInstance().isImageChooserUseEntityFolder()) {
                    dialog.setOpenFolderPath(MovieEditorDialog.this.movieToEdit.getPathNIO().toAbsolutePath().toString());
                }
                dialog.setLocationRelativeTo(MainWindow.getInstance());
                dialog.setVisible(true);
                MovieEditorDialog.this.updateArtworkUrl(MovieEditorDialog.this.lblKeyart, MovieEditorDialog.this.tfKeyart);
            }
        });
        artworkPanel.add((Component)this.lblKeyart, "cell 4 1 1 4,grow");
        this.lblKeyart.addPropertyChangeListener(ORIGINAL_IMAGE_SIZE, e -> this.setImageSizeAndCreateLink(lblKeyartSize, this.lblKeyart, btnDeleteKeyart, MediaFileType.KEYART));
        this.lblKeyart.setCursor(Cursor.getPredefinedCursor(12));
        TmmLabel lblClearlogoT = new TmmLabel(TmmResourceBundle.getString("mediafiletype.clearlogo"));
        artworkPanel.add((Component)lblClearlogoT, "cell 0 0");
        LinkLabel lblClearlogoSize = new LinkLabel();
        artworkPanel.add((Component)lblClearlogoSize, "flowx,cell 0 0");
        FlatButton btnDeleteClearLogo = new FlatButton(IconManager.DELETE_GRAY);
        btnDeleteClearLogo.setToolTipText(TmmResourceBundle.getString("Button.deleteartwork.desc"));
        btnDeleteClearLogo.addActionListener(e -> {
            this.lblClearlogo.clearImage();
            this.tfClearLogo.setText("");
        });
        artworkPanel.add((Component)btnDeleteClearLogo, "cell 0 0");
        this.lblClearlogo = new ImageLabel();
        this.lblClearlogo.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ImageChooserDialog dialog = new ImageChooserDialog(MovieEditorDialog.this, MovieEditorDialog.this.createIdsForImageChooser(), MediaArtwork.MediaArtworkType.CLEARLOGO, MovieEditorDialog.this.movieList.getDefaultArtworkScrapers(), MovieEditorDialog.this.lblClearlogo, MediaType.MOVIE);
                if (Settings.getInstance().isImageChooserUseEntityFolder()) {
                    dialog.setOpenFolderPath(MovieEditorDialog.this.movieToEdit.getPathNIO().toAbsolutePath().toString());
                }
                dialog.setLocationRelativeTo(MainWindow.getInstance());
                dialog.setVisible(true);
                MovieEditorDialog.this.updateArtworkUrl(MovieEditorDialog.this.lblClearlogo, MovieEditorDialog.this.tfClearLogo);
            }
        });
        this.lblClearlogo.setCursor(Cursor.getPredefinedCursor(12));
        artworkPanel.add((Component)this.lblClearlogo, "cell 0 1,grow");
        this.lblClearlogo.addPropertyChangeListener(ORIGINAL_IMAGE_SIZE, e -> this.setImageSizeAndCreateLink(lblClearlogoSize, this.lblClearlogo, btnDeleteClearLogo, MediaFileType.CLEARLOGO));
        TmmLabel lblClearartT = new TmmLabel(TmmResourceBundle.getString("mediafiletype.clearart"));
        artworkPanel.add((Component)lblClearartT, "cell 2 0");
        LinkLabel lblClearartSize = new LinkLabel();
        artworkPanel.add((Component)lblClearartSize, "cell 2 0");
        FlatButton btnDeleteClearart = new FlatButton(IconManager.DELETE_GRAY);
        btnDeleteClearart.setToolTipText(TmmResourceBundle.getString("Button.deleteartwork.desc"));
        btnDeleteClearart.addActionListener(e -> {
            this.lblClearart.clearImage();
            this.tfClearArt.setText("");
        });
        artworkPanel.add((Component)btnDeleteClearart, "cell 2 0");
        this.lblClearart = new ImageLabel();
        this.lblClearart.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ImageChooserDialog dialog = new ImageChooserDialog(MovieEditorDialog.this, MovieEditorDialog.this.createIdsForImageChooser(), MediaArtwork.MediaArtworkType.CLEARART, MovieEditorDialog.this.movieList.getDefaultArtworkScrapers(), MovieEditorDialog.this.lblClearart, MediaType.MOVIE);
                if (Settings.getInstance().isImageChooserUseEntityFolder()) {
                    dialog.setOpenFolderPath(MovieEditorDialog.this.movieToEdit.getPathNIO().toAbsolutePath().toString());
                }
                dialog.setLocationRelativeTo(MainWindow.getInstance());
                dialog.setVisible(true);
                MovieEditorDialog.this.updateArtworkUrl(MovieEditorDialog.this.lblClearart, MovieEditorDialog.this.tfClearArt);
            }
        });
        this.lblClearart.setCursor(Cursor.getPredefinedCursor(12));
        artworkPanel.add((Component)this.lblClearart, "cell 2 1,grow");
        this.lblClearart.addPropertyChangeListener(ORIGINAL_IMAGE_SIZE, e -> this.setImageSizeAndCreateLink(lblClearartSize, this.lblClearart, btnDeleteClearart, MediaFileType.CLEARART));
        TmmLabel lblBannerT = new TmmLabel(TmmResourceBundle.getString("mediafiletype.banner"));
        artworkPanel.add((Component)lblBannerT, "cell 0 3");
        LinkLabel lblBannerSize = new LinkLabel();
        artworkPanel.add((Component)lblBannerSize, "cell 0 3");
        FlatButton btnDeleteBanner = new FlatButton(IconManager.DELETE_GRAY);
        btnDeleteBanner.setToolTipText(TmmResourceBundle.getString("Button.deleteartwork.desc"));
        btnDeleteBanner.addActionListener(e -> {
            this.lblBanner.clearImage();
            this.tfBanner.setText("");
        });
        artworkPanel.add((Component)btnDeleteBanner, "cell 0 3");
        this.lblBanner = new ImageLabel();
        this.lblBanner.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ImageChooserDialog dialog = new ImageChooserDialog(MovieEditorDialog.this, MovieEditorDialog.this.createIdsForImageChooser(), MediaArtwork.MediaArtworkType.BANNER, MovieEditorDialog.this.movieList.getDefaultArtworkScrapers(), MovieEditorDialog.this.lblBanner, MediaType.MOVIE);
                if (Settings.getInstance().isImageChooserUseEntityFolder()) {
                    dialog.setOpenFolderPath(MovieEditorDialog.this.movieToEdit.getPathNIO().toAbsolutePath().toString());
                }
                dialog.setLocationRelativeTo(MainWindow.getInstance());
                dialog.setVisible(true);
                MovieEditorDialog.this.updateArtworkUrl(MovieEditorDialog.this.lblBanner, MovieEditorDialog.this.tfBanner);
            }
        });
        this.lblBanner.setCursor(Cursor.getPredefinedCursor(12));
        artworkPanel.add((Component)this.lblBanner, "cell 0 4 3 1,grow");
        this.lblBanner.addPropertyChangeListener(ORIGINAL_IMAGE_SIZE, e -> this.setImageSizeAndCreateLink(lblBannerSize, this.lblBanner, btnDeleteBanner, MediaFileType.BANNER));
        TmmLabel lblThumbT = new TmmLabel(TmmResourceBundle.getString("mediafiletype.thumb"));
        artworkPanel.add((Component)lblThumbT, "cell 0 6");
        LinkLabel lblThumbSize = new LinkLabel();
        artworkPanel.add((Component)lblThumbSize, "cell 0 6");
        FlatButton btnDeleteThumb = new FlatButton(IconManager.DELETE_GRAY);
        btnDeleteThumb.setToolTipText(TmmResourceBundle.getString("Button.deleteartwork.desc"));
        btnDeleteThumb.addActionListener(e -> {
            this.lblThumb.clearImage();
            this.tfThumb.setText("");
        });
        artworkPanel.add((Component)btnDeleteThumb, "cell 0 6");
        this.lblThumb = new ImageLabel();
        this.lblThumb.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ImageChooserDialog dialog = new ImageChooserDialog(MovieEditorDialog.this, MovieEditorDialog.this.createIdsForImageChooser(), MediaArtwork.MediaArtworkType.THUMB, MovieEditorDialog.this.movieList.getDefaultArtworkScrapers(), MovieEditorDialog.this.lblThumb, MediaType.MOVIE);
                dialog.bindExtraThumbs(MovieEditorDialog.this.extrathumbs);
                if (Settings.getInstance().isImageChooserUseEntityFolder()) {
                    dialog.setOpenFolderPath(MovieEditorDialog.this.movieToEdit.getPathNIO().toAbsolutePath().toString());
                }
                dialog.setLocationRelativeTo(MainWindow.getInstance());
                dialog.setVisible(true);
                MovieEditorDialog.this.updateArtworkUrl(MovieEditorDialog.this.lblThumb, MovieEditorDialog.this.tfThumb);
            }
        });
        this.lblThumb.setCursor(Cursor.getPredefinedCursor(12));
        artworkPanel.add((Component)this.lblThumb, "cell 0 7,grow");
        this.lblThumb.addPropertyChangeListener(ORIGINAL_IMAGE_SIZE, e -> this.setImageSizeAndCreateLink(lblThumbSize, this.lblThumb, btnDeleteThumb, MediaFileType.THUMB));
        TmmLabel lblDiscT = new TmmLabel(TmmResourceBundle.getString("mediafiletype.disc"));
        artworkPanel.add((Component)lblDiscT, "cell 2 6");
        LinkLabel lblDiscSize = new LinkLabel();
        artworkPanel.add((Component)lblDiscSize, "cell 2 6");
        FlatButton btnDeleteDisc = new FlatButton(IconManager.DELETE_GRAY);
        btnDeleteDisc.setToolTipText(TmmResourceBundle.getString("Button.deleteartwork.desc"));
        btnDeleteDisc.addActionListener(e -> {
            this.lblDisc.clearImage();
            this.tfDisc.setText("");
        });
        artworkPanel.add((Component)btnDeleteDisc, "cell 2 6");
        this.lblDisc = new ImageLabel();
        this.lblDisc.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ImageChooserDialog dialog = new ImageChooserDialog(MovieEditorDialog.this, MovieEditorDialog.this.createIdsForImageChooser(), MediaArtwork.MediaArtworkType.DISC, MovieEditorDialog.this.movieList.getDefaultArtworkScrapers(), MovieEditorDialog.this.lblDisc, MediaType.MOVIE);
                if (Settings.getInstance().isImageChooserUseEntityFolder()) {
                    dialog.setOpenFolderPath(MovieEditorDialog.this.movieToEdit.getPathNIO().toAbsolutePath().toString());
                }
                dialog.setLocationRelativeTo(MainWindow.getInstance());
                dialog.setVisible(true);
                MovieEditorDialog.this.updateArtworkUrl(MovieEditorDialog.this.lblDisc, MovieEditorDialog.this.tfDisc);
            }
        });
        this.lblDisc.setCursor(Cursor.getPredefinedCursor(12));
        artworkPanel.add((Component)this.lblDisc, "cell 2 7,grow");
        this.lblDisc.addPropertyChangeListener(ORIGINAL_IMAGE_SIZE, e -> this.setImageSizeAndCreateLink(lblDiscSize, this.lblDisc, btnDeleteDisc, MediaFileType.DISC));
        JPanel artworkAndTrailerPanel = new JPanel();
        this.tabbedPane.addTab(TmmResourceBundle.getString("edit.artworkandtrailer"), null, artworkAndTrailerPanel, null);
        artworkAndTrailerPanel.setLayout((LayoutManager)new MigLayout("", "[][grow]", "[][][][][][][][][20lp:n][100lp:200lp,grow][grow]"));
        TmmLabel lblPosterT = new TmmLabel(TmmResourceBundle.getString("mediafiletype.poster"));
        artworkAndTrailerPanel.add((Component)lblPosterT, "cell 0 0,alignx right");
        this.tfPoster = new JTextField();
        artworkAndTrailerPanel.add((Component)this.tfPoster, "cell 1 0,growx");
        TmmLabel lblFanartT = new TmmLabel(TmmResourceBundle.getString("mediafiletype.fanart"));
        artworkAndTrailerPanel.add((Component)lblFanartT, "cell 0 1,alignx right");
        this.tfFanart = new JTextField();
        artworkAndTrailerPanel.add((Component)this.tfFanart, "cell 1 1,growx");
        TmmLabel lblClearLogoT = new TmmLabel(TmmResourceBundle.getString("mediafiletype.clearlogo"));
        artworkAndTrailerPanel.add((Component)lblClearLogoT, "cell 0 2,alignx right");
        this.tfClearLogo = new JTextField();
        artworkAndTrailerPanel.add((Component)this.tfClearLogo, "cell 1 2,growx");
        lblBannerT = new TmmLabel(TmmResourceBundle.getString("mediafiletype.banner"));
        artworkAndTrailerPanel.add((Component)lblBannerT, "cell 0 3,alignx right");
        this.tfBanner = new JTextField();
        artworkAndTrailerPanel.add((Component)this.tfBanner, "cell 1 3,growx");
        TmmLabel lblClearArtT = new TmmLabel(TmmResourceBundle.getString("mediafiletype.clearart"));
        artworkAndTrailerPanel.add((Component)lblClearArtT, "cell 0 4,alignx right");
        this.tfClearArt = new JTextField();
        artworkAndTrailerPanel.add((Component)this.tfClearArt, "cell 1 4,growx");
        lblThumbT = new TmmLabel(TmmResourceBundle.getString("mediafiletype.thumb"));
        artworkAndTrailerPanel.add((Component)lblThumbT, "cell 0 5,alignx right");
        this.tfThumb = new JTextField();
        artworkAndTrailerPanel.add((Component)this.tfThumb, "cell 1 5,growx");
        lblDiscT = new TmmLabel(TmmResourceBundle.getString("mediafiletype.disc"));
        artworkAndTrailerPanel.add((Component)lblDiscT, "cell 0 6,alignx trailing");
        this.tfDisc = new JTextField();
        artworkAndTrailerPanel.add((Component)this.tfDisc, "cell 1 6,growx");
        lblKeyartT = new TmmLabel(TmmResourceBundle.getString("mediafiletype.keyart"));
        artworkAndTrailerPanel.add((Component)lblKeyartT, "cell 0 7,alignx trailing");
        this.tfKeyart = new JTextField();
        artworkAndTrailerPanel.add((Component)this.tfKeyart, "cell 1 7,growx");
        TmmLabel lblTrailer = new TmmLabel(TmmResourceBundle.getString("metatag.trailer"));
        artworkAndTrailerPanel.add((Component)lblTrailer, "flowy,cell 0 9,alignx right,aligny top");
        SquareIconButton btnAddTrailer = new SquareIconButton(new AddTrailerAction());
        artworkAndTrailerPanel.add((Component)btnAddTrailer, "cell 0 9,alignx right,aligny top");
        SquareIconButton btnRemoveTrailer = new SquareIconButton(new RemoveTrailerAction());
        artworkAndTrailerPanel.add((Component)btnRemoveTrailer, "cell 0 9,alignx right,aligny top");
        SquareIconButton btnPlayTrailer = new SquareIconButton(new PlayTrailerAction());
        artworkAndTrailerPanel.add((Component)btnPlayTrailer, "cell 0 9,alignx right,aligny top");
        this.tableTrailer = new MediaTrailerTable(this.trailers, true);
        artworkAndTrailerPanel.add((Component)this.tableTrailer, "cell 1 9 7 1,grow");
        JScrollPane scrollPaneTrailer = new JScrollPane();
        artworkAndTrailerPanel.add((Component)scrollPaneTrailer, "cell 1 9 7 1,grow");
        this.tableTrailer.configureScrollPane(scrollPaneTrailer);
        this.mediaFilesPanel = new MediaFileEditorPanel(this.mediaFiles);
        this.tabbedPane.addTab(TmmResourceBundle.getString("metatag.mediafiles"), null, this.mediaFilesPanel, null);
        this.mediaFilesPanel.setLayout((LayoutManager)new MigLayout("", "[400lp:500lp,grow,fill]", "[300lp:400lp,grow,fill]"));
        if (this.queueSize > 1) {
            JButton btnAbort = new JButton(new AbstractEditorDialog.AbortQueueAction(this, TmmResourceBundle.getString("movie.edit.abortqueue.desc")));
            this.addButton(btnAbort);
            if (this.queueIndex > 0) {
                JButton backButton = new JButton(new AbstractEditorDialog.NavigateBackAction(this));
                this.addButton(backButton);
            }
        }
        JButton cancelButton = new JButton(new DiscardAction());
        cancelButton.addActionListener(e -> this.mediaFilesPanel.cancelTask());
        this.addButton(cancelButton);
        JButton okButton = new JButton(new ChangeMovieAction());
        okButton.addActionListener(e -> this.mediaFilesPanel.cancelTask());
        this.getRootPane().registerKeyboardAction(new ChangeMovieAction(), KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()), 2);
        this.getRootPane().registerKeyboardAction(new ChangeMovieAction(), KeyStroke.getKeyStroke(10, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()), 2);
        this.addButton(okButton);
    }

    private void registerDropTarget(final ImageLabel imageLabel, final JTextField textField) {
        new DropTarget(imageLabel, new ArtworkDragAndDropListener(imageLabel){

            @Override
            public void drop(DropTargetDropEvent dtde) {
                super.drop(dtde);
                MovieEditorDialog.this.updateArtworkUrl(imageLabel, textField);
            }
        });
    }

    private Map<String, Object> createIdsForImageChooser() {
        HashMap<String, Object> newIds = new HashMap<String, Object>(this.movieToEdit.getIds());
        if (this.movieToEdit.isStacked()) {
            ArrayList<MediaFile> mfs = new ArrayList<MediaFile>();
            mfs.addAll(this.movieToEdit.getMediaFiles(MediaFileType.VIDEO));
            newIds.put("mediaFile", mfs);
        } else {
            newIds.put("mediaFile", this.movieToEdit.getMainFile());
        }
        return newIds;
    }

    private void updateArtworkUrl(ImageLabel imageLabel, JTextField textField) {
        if (StringUtils.isNotBlank((CharSequence)imageLabel.getImageUrl())) {
            textField.setText(imageLabel.getImageUrl());
        }
    }

    private void processArtwork(MediaFileType type, ImageLabel imageLabel, JTextField textField) {
        if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{imageLabel.getImagePath(), imageLabel.getImageUrl()}) && StringUtils.isNotBlank((CharSequence)this.movieToEdit.getArtworkFilename(type))) {
            this.movieToEdit.deleteMediaFiles(type);
        }
        if (StringUtils.isNotEmpty((CharSequence)textField.getText()) && !textField.getText().equals(this.movieToEdit.getArtworkUrl(type))) {
            this.movieToEdit.setArtworkUrl(textField.getText(), type);
            this.movieToEdit.downloadArtwork(type);
        } else if (StringUtils.isEmpty((CharSequence)textField.getText())) {
            this.movieToEdit.removeArtworkUrl(type);
        } else if (StringUtils.isBlank((CharSequence)this.movieToEdit.getArtworkFilename(type))) {
            this.movieToEdit.downloadArtwork(type);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.mediaFilesPanel != null) {
            this.mediaFilesPanel.unbindBindings();
        }
        if (this.dpReleaseDate != null) {
            this.dpReleaseDate.cleanup();
        }
    }

    protected BindingGroup initDataBindings() {
        JListBinding jListBinding = SwingBindings.createJListBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, this.genres, this.listGenres);
        jListBinding.bind();
        JListBinding jListBinding_1 = SwingBindings.createJListBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, this.tags, this.listTags);
        jListBinding_1.bind();
        JListBinding jListBinding_2 = SwingBindings.createJListBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, this.showlinks, this.listShowlink);
        jListBinding_2.bind();
        BindingGroup bindingGroup = new BindingGroup();
        bindingGroup.addBinding((Binding)jListBinding);
        bindingGroup.addBinding((Binding)jListBinding_1);
        return bindingGroup;
    }

    private class AddRatingAction
    extends AbstractAction {
        public AddRatingAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("rating.add"));
            this.putValue("SmallIcon", IconManager.ADD_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MediaRatingTable.Rating rating = new MediaRatingTable.Rating("");
            rating.maxValue = 10;
            rating.votes = 1;
            ModalPopupPanel popupPanel = MovieEditorDialog.this.createModalPopupPanel();
            popupPanel.setTitle(TmmResourceBundle.getString("rating.add"));
            popupPanel.setOnCloseHandler(() -> {
                if (StringUtils.isNotBlank((CharSequence)rating.key) && rating.value > 0.0f && rating.maxValue > 0 && rating.votes > 0) {
                    MovieEditorDialog.this.ratings.add((Object)rating);
                }
            });
            RatingEditorPanel ratingEditorPanel = new RatingEditorPanel(rating);
            popupPanel.setContent(ratingEditorPanel);
            MovieEditorDialog.this.showModalPopupPanel(popupPanel);
        }
    }

    private class RemoveRatingAction
    extends AbstractAction {
        public RemoveRatingAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("rating.remove"));
            this.putValue("SmallIcon", IconManager.REMOVE_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TmmUIHelper.removeSelectedRowsFromJTable(MovieEditorDialog.this.tableRatings, MovieEditorDialog.this.ratings);
        }
    }

    private class AddIdAction
    extends AbstractAction {
        public AddIdAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("id.add"));
            this.putValue("SmallIcon", IconManager.ADD_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MediaIdTable.MediaId mediaId = new MediaIdTable.MediaId();
            ModalPopupPanel popupPanel = MovieEditorDialog.this.createModalPopupPanel();
            popupPanel.setTitle(TmmResourceBundle.getString("id.add"));
            popupPanel.setOnCloseHandler(() -> {
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{mediaId.key, mediaId.value})) {
                    MovieEditorDialog.this.ids.add((Object)mediaId);
                }
            });
            IdEditorPanel idEditorPanel = new IdEditorPanel(mediaId, ScraperType.MOVIE);
            popupPanel.setContent(idEditorPanel);
            MovieEditorDialog.this.showModalPopupPanel(popupPanel);
        }
    }

    private class RemoveIdAction
    extends AbstractAction {
        public RemoveIdAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("id.remove"));
            this.putValue("SmallIcon", IconManager.REMOVE_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TmmUIHelper.removeSelectedRowsFromJTable(MovieEditorDialog.this.tableIds, MovieEditorDialog.this.ids);
        }
    }

    private class AddGenreAction
    extends AbstractAction {
        public AddGenreAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("genre.add"));
            this.putValue("SmallIcon", IconManager.ADD_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextField textField;
            String selectedText;
            MediaGenres newGenre = null;
            Object item = MovieEditorDialog.this.cbGenres.getSelectedItem();
            Component editorComponent = MovieEditorDialog.this.cbGenres.getEditor().getEditorComponent();
            if (editorComponent instanceof JTextField && (selectedText = (textField = (JTextField)editorComponent).getSelectedText()) != null) {
                textField.setSelectionStart(0);
                textField.setSelectionEnd(0);
                textField.setCaretPosition(textField.getText().length());
                return;
            }
            if (item instanceof MediaGenres) {
                newGenre = (MediaGenres)item;
            }
            if (item instanceof String) {
                newGenre = MediaGenres.getGenre((String)item);
            }
            if (newGenre != null && !MovieEditorDialog.this.genres.contains(newGenre)) {
                MovieEditorDialog.this.genres.add(newGenre);
                if (editorComponent instanceof JTextField) {
                    AutocompleteSupport autoCompleteSupport = MovieEditorDialog.this.cbGenres.getAutoCompleteSupport();
                    autoCompleteSupport.setFirstItem(null);
                    MovieEditorDialog.this.cbGenres.setSelectedIndex(0);
                    autoCompleteSupport.removeFirstItem();
                }
            }
        }
    }

    private class RemoveGenreAction
    extends AbstractAction {
        public RemoveGenreAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("genre.remove"));
            this.putValue("SmallIcon", IconManager.REMOVE_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List<MediaGenres> selectedGenres = MovieEditorDialog.this.listGenres.getSelectedValuesList();
            for (MediaGenres genre : selectedGenres) {
                MovieEditorDialog.this.genres.remove(genre);
            }
        }
    }

    private class MoveGenreUpAction
    extends AbstractAction {
        public MoveGenreUpAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("movie.edit.movegenreup"));
            this.putValue("SmallIcon", IconManager.ARROW_UP_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = MovieEditorDialog.this.listGenres.getSelectedIndex();
            if (row > 0) {
                Collections.rotate(MovieEditorDialog.this.genres.subList(row - 1, row + 1), 1);
                MovieEditorDialog.this.listGenres.getSelectionModel().setSelectionInterval(row - 1, row - 1);
            }
        }
    }

    private class MoveGenreDownAction
    extends AbstractAction {
        public MoveGenreDownAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("movie.edit.movegenredown"));
            this.putValue("SmallIcon", IconManager.ARROW_DOWN_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = MovieEditorDialog.this.listGenres.getSelectedIndex();
            if (row < MovieEditorDialog.this.genres.size() - 1) {
                Collections.rotate(MovieEditorDialog.this.genres.subList(row, row + 2), -1);
                MovieEditorDialog.this.listGenres.getSelectionModel().setSelectionInterval(row + 1, row + 1);
            }
        }
    }

    private class AddTagAction
    extends AbstractAction {
        public AddTagAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("tag.add"));
            this.putValue("SmallIcon", IconManager.ADD_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextField tf;
            String selectedText;
            Object selectedItem = MovieEditorDialog.this.cbTags.getSelectedItem();
            if (selectedItem == null) {
                return;
            }
            String newTag = (String)selectedItem;
            if (StringUtils.isBlank((CharSequence)newTag)) {
                return;
            }
            Component editorComponent = MovieEditorDialog.this.cbTags.getEditor().getEditorComponent();
            if (editorComponent instanceof JTextField && (selectedText = (tf = (JTextField)editorComponent).getSelectedText()) != null) {
                tf.setSelectionStart(0);
                tf.setSelectionEnd(0);
                tf.setCaretPosition(tf.getText().length());
                return;
            }
            if (!MovieEditorDialog.this.tags.contains(newTag)) {
                MovieEditorDialog.this.tags.add(newTag);
                if (editorComponent instanceof JTextField) {
                    AutocompleteSupport cbTagsAutocompleteSupport = MovieEditorDialog.this.cbTags.getAutoCompleteSupport();
                    cbTagsAutocompleteSupport.setFirstItem(null);
                    MovieEditorDialog.this.cbTags.setSelectedIndex(0);
                    cbTagsAutocompleteSupport.removeFirstItem();
                }
            }
        }
    }

    private class RemoveTagAction
    extends AbstractAction {
        public RemoveTagAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("tag.remove"));
            this.putValue("SmallIcon", IconManager.REMOVE_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List<String> selectedTags = MovieEditorDialog.this.listTags.getSelectedValuesList();
            for (String tag : selectedTags) {
                MovieEditorDialog.this.tags.remove(tag);
            }
        }
    }

    private class MoveTagUpAction
    extends AbstractAction {
        public MoveTagUpAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("movie.edit.movetagup"));
            this.putValue("SmallIcon", IconManager.ARROW_UP_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = MovieEditorDialog.this.listTags.getSelectedIndex();
            if (row > 0) {
                Collections.rotate(MovieEditorDialog.this.tags.subList(row - 1, row + 1), 1);
                MovieEditorDialog.this.listTags.getSelectionModel().setSelectionInterval(row - 1, row - 1);
            }
        }
    }

    private class MoveTagDownAction
    extends AbstractAction {
        public MoveTagDownAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("movie.edit.movetagdown"));
            this.putValue("SmallIcon", IconManager.ARROW_DOWN_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = MovieEditorDialog.this.listTags.getSelectedIndex();
            if (row < MovieEditorDialog.this.tags.size() - 1) {
                Collections.rotate(MovieEditorDialog.this.tags.subList(row, row + 2), -1);
                MovieEditorDialog.this.listTags.getSelectionModel().setSelectionInterval(row + 1, row + 1);
            }
        }
    }

    private class AddShowlinkAction
    extends AbstractAction {
        public AddShowlinkAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("showlink.add"));
            this.putValue("SmallIcon", IconManager.ADD_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String newShowlink = (String)MovieEditorDialog.this.cbShowlink.getSelectedItem();
            if (StringUtils.isBlank((CharSequence)newShowlink)) {
                return;
            }
            if (!MovieEditorDialog.this.showlinks.contains(newShowlink)) {
                MovieEditorDialog.this.showlinks.add(newShowlink);
            }
        }
    }

    private class RemoveShowlinkAction
    extends AbstractAction {
        public RemoveShowlinkAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("showlink.remove"));
            this.putValue("SmallIcon", IconManager.REMOVE_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List<String> selectedShowlinks = MovieEditorDialog.this.listShowlink.getSelectedValuesList();
            for (String showlink : selectedShowlinks) {
                MovieEditorDialog.this.showlinks.remove(showlink);
            }
        }
    }

    private class AddActorAction
    extends AbstractAction {
        public AddActorAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("cast.actor.add"));
            this.putValue("SmallIcon", IconManager.ADD_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MovieEditorDialog.this.tableActors.addPerson();
        }
    }

    private class RemoveActorAction
    extends AbstractAction {
        public RemoveActorAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("cast.actor.remove"));
            this.putValue("SmallIcon", IconManager.REMOVE_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MovieEditorDialog.this.cast.removeAll(MovieEditorDialog.this.tableActors.getSelectedPersons());
        }
    }

    private class MoveActorUpAction
    extends AbstractAction {
        public MoveActorUpAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("movie.edit.moveactorup"));
            this.putValue("SmallIcon", IconManager.ARROW_UP_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = MovieEditorDialog.this.tableActors.getSelectedRow();
            if (row > 0) {
                Collections.rotate(MovieEditorDialog.this.cast.subList(row - 1, row + 1), 1);
                MovieEditorDialog.this.tableActors.getSelectionModel().setSelectionInterval(row - 1, row - 1);
            }
        }
    }

    private class MoveActorDownAction
    extends AbstractAction {
        public MoveActorDownAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("movie.edit.moveactordown"));
            this.putValue("SmallIcon", IconManager.ARROW_DOWN_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = MovieEditorDialog.this.tableActors.getSelectedRow();
            if (row < MovieEditorDialog.this.cast.size() - 1) {
                Collections.rotate(MovieEditorDialog.this.cast.subList(row, row + 2), -1);
                MovieEditorDialog.this.tableActors.getSelectionModel().setSelectionInterval(row + 1, row + 1);
            }
        }
    }

    private class AddCrewAction
    extends AbstractAction {
        public AddCrewAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("cast.crew.add"));
            this.putValue("SmallIcon", IconManager.ADD_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MovieEditorDialog.this.tableCrew.addPerson();
        }
    }

    private class RemoveCrewAction
    extends AbstractAction {
        public RemoveCrewAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("cast.crew.remove"));
            this.putValue("SmallIcon", IconManager.REMOVE_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MovieEditorDialog.this.crew.removeAll(MovieEditorDialog.this.tableCrew.getSelectedPersons());
        }
    }

    private class MoveCrewUpAction
    extends AbstractAction {
        public MoveCrewUpAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("movie.edit.movecrewup"));
            this.putValue("SmallIcon", IconManager.ARROW_UP_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = MovieEditorDialog.this.tableCrew.getSelectedRow();
            if (row > 0) {
                Collections.rotate(MovieEditorDialog.this.crew.subList(row - 1, row + 1), 1);
                MovieEditorDialog.this.tableCrew.getSelectionModel().setSelectionInterval(row - 1, row - 1);
            }
        }
    }

    private class MoveCrewDownAction
    extends AbstractAction {
        public MoveCrewDownAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("movie.edit.movecrewdown"));
            this.putValue("SmallIcon", IconManager.ARROW_DOWN_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = MovieEditorDialog.this.tableCrew.getSelectedRow();
            if (row < MovieEditorDialog.this.crew.size() - 1) {
                Collections.rotate(MovieEditorDialog.this.crew.subList(row, row + 2), -1);
                MovieEditorDialog.this.tableCrew.getSelectionModel().setSelectionInterval(row + 1, row + 1);
            }
        }
    }

    private class AddTrailerAction
    extends AbstractAction {
        public AddTrailerAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("trailer.add"));
            this.putValue("SmallIcon", IconManager.ADD_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MovieEditorDialog.this.tableTrailer.addTrailer();
        }
    }

    private class RemoveTrailerAction
    extends AbstractAction {
        public RemoveTrailerAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("trailer.remove"));
            this.putValue("SmallIcon", IconManager.REMOVE_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TmmUIHelper.removeSelectedRowsFromJTable(MovieEditorDialog.this.tableTrailer, MovieEditorDialog.this.trailers);
        }
    }

    private class PlayTrailerAction
    extends AbstractAction {
        public PlayTrailerAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("trailer.play"));
            this.putValue("SmallIcon", IconManager.PLAY_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = MovieEditorDialog.this.tableTrailer.getSelectedRow();
            if (row > -1) {
                row = MovieEditorDialog.this.tableTrailer.convertRowIndexToModel(row);
                MediaTrailer selectedTrailer = (MediaTrailer)MovieEditorDialog.this.trailers.get(row);
                String url = selectedTrailer.getUrl();
                try {
                    TmmUIHelper.browseUrl(url);
                }
                catch (Exception ex) {
                    LOGGER.error("Could not open '{}' in browser - '{}'", (Object)url, (Object)ex.getMessage());
                    MessageManager.getInstance().pushMessage(new Message(Message.MessageLevel.ERROR, (Object)url, "message.erroropenurl", new String[]{":", ex.getLocalizedMessage()}));
                }
            } else {
                JOptionPane.showMessageDialog(MainWindow.getInstance(), TmmResourceBundle.getString("tmm.nothingselected"));
            }
        }
    }

    private class DiscardAction
    extends AbstractAction {
        public DiscardAction() {
            this.putValue("Name", TmmResourceBundle.getString("Button.cancel"));
            this.putValue("ShortDescription", TmmResourceBundle.getString("edit.discard"));
            this.putValue("SmallIcon", IconManager.CANCEL_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MovieEditorDialog.this.setVisible(false);
        }
    }

    private class ChangeMovieAction
    extends AbstractAction {
        public ChangeMovieAction() {
            this.putValue("Name", TmmResourceBundle.getString("Button.ok"));
            this.putValue("ShortDescription", TmmResourceBundle.getString("movie.change"));
            this.putValue("SmallIcon", IconManager.APPLY_INV);
            this.putValue("SwingLargeIconKey", IconManager.APPLY_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (StringUtils.isBlank((CharSequence)MovieEditorDialog.this.tfTitle.getText())) {
                MovieEditorDialog.this.tfTitle.requestFocusInWindow();
                return;
            }
            MovieEditorDialog.this.commitChanges();
            MovieEditorDialog.this.movieToEdit.setTitle(MovieEditorDialog.this.tfTitle.getText());
            MovieEditorDialog.this.movieToEdit.setOriginalTitle(MovieEditorDialog.this.tfOriginalTitle.getText());
            MovieEditorDialog.this.movieToEdit.setEnglishTitle(MovieEditorDialog.this.tfEnglishTitle.getText());
            MovieEditorDialog.this.movieToEdit.setTagline(MovieEditorDialog.this.tfTagline.getText());
            MovieEditorDialog.this.movieToEdit.setPlot(MovieEditorDialog.this.taPlot.getText());
            MovieEditorDialog.this.movieToEdit.setYear((Integer)MovieEditorDialog.this.spYear.getValue());
            MovieEditorDialog.this.movieToEdit.setReleaseDate(MovieEditorDialog.this.dpReleaseDate.getDate());
            MovieEditorDialog.this.movieToEdit.setRuntime((Integer)MovieEditorDialog.this.spRuntime.getValue());
            MovieEditorDialog.this.movieToEdit.setTop250((Integer)MovieEditorDialog.this.spTop250.getValue());
            MovieEditorDialog.this.movieToEdit.setWatched(MovieEditorDialog.this.cbWatched.isSelected());
            MovieEditorDialog.this.movieToEdit.setSpokenLanguages(MovieEditorDialog.this.tfSpokenLanguages.getText());
            MovieEditorDialog.this.movieToEdit.setCountry(MovieEditorDialog.this.tfCountry.getText());
            MovieEditorDialog.this.movieToEdit.setVideoIn3D(MovieEditorDialog.this.chckbxVideo3D.isSelected());
            MovieEditorDialog.this.movieToEdit.setNote(MovieEditorDialog.this.taNote.getText());
            Object movieEdition = MovieEditorDialog.this.cbEdition.getSelectedItem();
            if (movieEdition instanceof MovieEdition) {
                MovieEdition edition = (MovieEdition)movieEdition;
                MovieEditorDialog.this.movieToEdit.setEdition(edition);
            } else if (movieEdition instanceof String) {
                String str = (String)movieEdition;
                MovieEditorDialog.this.movieToEdit.setEdition(MovieEdition.getMovieEditionStrict(str));
            } else {
                MovieEditorDialog.this.movieToEdit.setEdition(MovieEdition.NONE);
            }
            Object mediaSource = MovieEditorDialog.this.cbSource.getSelectedItem();
            if (mediaSource instanceof MediaSource) {
                MediaSource source = (MediaSource)mediaSource;
                MovieEditorDialog.this.movieToEdit.setMediaSource(source);
            } else if (mediaSource instanceof String) {
                String str = (String)mediaSource;
                MovieEditorDialog.this.movieToEdit.setMediaSource(MediaSource.getMediaSource(str));
            } else {
                MovieEditorDialog.this.movieToEdit.setMediaSource(MediaSource.UNKNOWN);
            }
            for (Iterator id : MovieEditorDialog.this.ids) {
                try {
                    Integer value = Integer.parseInt(((MediaIdTable.MediaId)((Object)id)).value);
                    MovieEditorDialog.this.movieToEdit.setId(((MediaIdTable.MediaId)((Object)id)).key, value);
                }
                catch (NumberFormatException ex) {
                    MovieEditorDialog.this.movieToEdit.setId(((MediaIdTable.MediaId)((Object)id)).key, ((MediaIdTable.MediaId)((Object)id)).value);
                }
            }
            ArrayList<String> removeIds = new ArrayList<String>();
            for (Map.Entry entry : MovieEditorDialog.this.movieToEdit.getIds().entrySet()) {
                MediaIdTable.MediaId id = new MediaIdTable.MediaId((String)entry.getKey());
                if (MovieEditorDialog.this.ids.contains((Object)id)) continue;
                removeIds.add((String)entry.getKey());
            }
            for (String id : removeIds) {
                MovieEditorDialog.this.movieToEdit.setId(id, null);
            }
            Object certification = MovieEditorDialog.this.cbCertification.getSelectedItem();
            if (certification instanceof MediaCertification) {
                MovieEditorDialog.this.movieToEdit.setCertification((MediaCertification)((Object)certification));
            }
            MediaFileEditorPanel.syncMediaFiles(MovieEditorDialog.this.mediaFiles, MovieEditorDialog.this.movieToEdit.getMediaFiles());
            MovieEditorDialog.this.movieToEdit.fireEventForChangedMediaInformation();
            MovieEditorDialog.this.processArtwork(MediaFileType.POSTER, MovieEditorDialog.this.lblPoster, MovieEditorDialog.this.tfPoster);
            MovieEditorDialog.this.processArtwork(MediaFileType.FANART, MovieEditorDialog.this.lblFanart, MovieEditorDialog.this.tfFanart);
            MovieEditorDialog.this.processArtwork(MediaFileType.CLEARLOGO, MovieEditorDialog.this.lblClearlogo, MovieEditorDialog.this.tfClearLogo);
            MovieEditorDialog.this.processArtwork(MediaFileType.BANNER, MovieEditorDialog.this.lblBanner, MovieEditorDialog.this.tfBanner);
            MovieEditorDialog.this.processArtwork(MediaFileType.CLEARART, MovieEditorDialog.this.lblClearart, MovieEditorDialog.this.tfClearArt);
            MovieEditorDialog.this.processArtwork(MediaFileType.THUMB, MovieEditorDialog.this.lblThumb, MovieEditorDialog.this.tfThumb);
            MovieEditorDialog.this.processArtwork(MediaFileType.DISC, MovieEditorDialog.this.lblDisc, MovieEditorDialog.this.tfDisc);
            MovieEditorDialog.this.processArtwork(MediaFileType.KEYART, MovieEditorDialog.this.lblKeyart, MovieEditorDialog.this.tfKeyart);
            if (!(MovieEditorDialog.this.extrathumbs == null || MovieEditorDialog.this.extrathumbs.isEmpty() || MovieEditorDialog.this.extrathumbs.size() == MovieEditorDialog.this.movieToEdit.getExtraThumbs().size() && MovieEditorDialog.this.extrathumbs.containsAll(MovieEditorDialog.this.movieToEdit.getExtraThumbs()) && MovieEditorDialog.this.movieToEdit.getExtraThumbs().containsAll(MovieEditorDialog.this.extrathumbs))) {
                MovieEditorDialog.this.movieToEdit.setExtraThumbs(MovieEditorDialog.this.extrathumbs);
                MovieEditorDialog.this.movieToEdit.downloadArtwork(MediaFileType.EXTRATHUMB);
            }
            if (!(MovieEditorDialog.this.extrafanarts == null || MovieEditorDialog.this.extrafanarts.isEmpty() || MovieEditorDialog.this.extrafanarts.size() == MovieEditorDialog.this.movieToEdit.getExtraFanarts().size() && MovieEditorDialog.this.extrafanarts.containsAll(MovieEditorDialog.this.movieToEdit.getExtraFanarts()) && MovieEditorDialog.this.movieToEdit.getExtraFanarts().containsAll(MovieEditorDialog.this.extrafanarts))) {
                MovieEditorDialog.this.movieToEdit.setExtraFanarts(MovieEditorDialog.this.extrafanarts);
                MovieEditorDialog.this.movieToEdit.downloadArtwork(MediaFileType.EXTRAFANART);
            }
            MovieEditorDialog.this.movieToEdit.setProductionCompany(MovieEditorDialog.this.tfProductionCompanies.getText());
            MovieEditorDialog.this.movieToEdit.removeActors();
            MovieEditorDialog.this.movieToEdit.setActors((List<Person>)MovieEditorDialog.this.cast);
            MovieEditorDialog.this.movieToEdit.removeCrew();
            MovieEditorDialog.this.movieToEdit.setCrew((List<Person>)MovieEditorDialog.this.crew);
            MovieEditorDialog.this.movieToEdit.removeAllGenres();
            MovieEditorDialog.this.movieToEdit.setGenres(MovieEditorDialog.this.genres);
            MovieEditorDialog.this.movieToEdit.removeAllTrailers();
            MovieEditorDialog.this.movieToEdit.addToTrailer((Collection<MediaTrailer>)MovieEditorDialog.this.trailers);
            MovieEditorDialog.this.movieToEdit.removeAllTags();
            MovieEditorDialog.this.movieToEdit.setTags(MovieEditorDialog.this.tags);
            MovieEditorDialog.this.movieToEdit.removeAllShowlinks();
            MovieEditorDialog.this.movieToEdit.setShowlinks(MovieEditorDialog.this.showlinks);
            MovieEditorDialog.this.movieToEdit.setDateAdded((Date)MovieEditorDialog.this.spDateAdded.getValue());
            MovieEditorDialog.this.movieToEdit.setSortTitle(MovieEditorDialog.this.tfSorttitle.getText());
            Object obj = MovieEditorDialog.this.cbMovieSet.getSelectedItem();
            if (obj instanceof String) {
                MovieEditorDialog.this.movieToEdit.removeFromMovieSet();
            }
            if (obj instanceof MovieSet) {
                MovieSet movieSet = (MovieSet)obj;
                if (MovieEditorDialog.this.movieToEdit.getMovieSet() != movieSet) {
                    MovieEditorDialog.this.movieToEdit.removeFromMovieSet();
                    MovieEditorDialog.this.movieToEdit.setMovieSet(movieSet);
                    movieSet.insertMovie(MovieEditorDialog.this.movieToEdit);
                    movieSet.saveToDb();
                }
            }
            HashMap<String, MediaRating> newRatings = new HashMap<String, MediaRating>();
            double userRating = (Double)MovieEditorDialog.this.spRating.getValue();
            if (userRating > 0.0) {
                newRatings.put("user", new MediaRating("user", userRating, 1, 10));
            }
            for (MediaRatingTable.Rating rating : MovieEditorDialog.this.ratings) {
                if (!StringUtils.isNotBlank((CharSequence)rating.key) || !(rating.value > 0.0f)) continue;
                newRatings.put(rating.key, new MediaRating(rating.key, rating.value, rating.votes, rating.maxValue));
            }
            MovieEditorDialog.this.movieToEdit.setRatings(newRatings);
            if (userRating == 0.0) {
                MovieEditorDialog.this.movieToEdit.removeRating("user");
            }
            MovieEditorDialog.this.movieToEdit.writeNFO();
            MovieEditorDialog.this.movieToEdit.saveToDb();
            if (MovieModuleManager.getInstance().getSettings().getSyncTrakt()) {
                MovieSyncTraktTvTask task = new MovieSyncTraktTvTask(Collections.singletonList(MovieEditorDialog.this.movieToEdit));
                task.setSyncCollection(MovieModuleManager.getInstance().getSettings().getSyncTraktCollection());
                task.setSyncWatched(MovieModuleManager.getInstance().getSettings().getSyncTraktWatched());
                task.setSyncRating(MovieModuleManager.getInstance().getSettings().getSyncTraktRating());
                TmmTaskManager.getInstance().addUnnamedTask(task);
            }
            MovieEditorDialog.this.setVisible(false);
        }
    }
}

