/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components.table;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import org.tinymediamanager.ui.components.table.TmmTable;

public class TmmTableColumnModel
extends DefaultTableColumnModel {
    protected List<TableColumn> hiddenColumns = new ArrayList<TableColumn>();
    protected boolean disableColumnEvents = false;
    List<Integer> hiddenColumnsPosition = new ArrayList<Integer>();

    private void addColumn(TableColumn aColumn, int index) {
        if (aColumn == null) {
            throw new IllegalArgumentException("Object is null");
        }
        this.tableColumns.insertElementAt(aColumn, index);
        aColumn.addPropertyChangeListener(this);
        this.totalColumnWidth = -1;
        this.fireColumnAdded(new TableColumnModelEvent(this, 0, index));
    }

    @Override
    public void moveColumn(int ci1, int ci2) {
        int index;
        int i;
        super.moveColumn(ci1, ci2);
        int n = this.hiddenColumns.size();
        for (i = 0; i < n; ++i) {
            index = this.hiddenColumnsPosition.get(i);
            if (ci1 >= index) {
                ++ci1;
            }
            if (ci2 < index) continue;
            ++ci2;
        }
        if (ci1 < ci2) {
            for (i = 0; i < n; ++i) {
                index = this.hiddenColumnsPosition.get(i);
                if (ci1 >= index || index > ci2) continue;
                this.hiddenColumnsPosition.set(i, --index);
            }
        }
        if (ci2 < ci1) {
            for (i = 0; i < n; ++i) {
                index = this.hiddenColumnsPosition.get(i);
                if (ci2 > index || index >= ci1) continue;
                this.hiddenColumnsPosition.set(i, ++index);
            }
        }
    }

    @Override
    public void removeColumn(TableColumn column) {
        int columnIndex = this.removeColumn(column, true);
        if (columnIndex != -1) {
            this.fireColumnRemoved(new TableColumnModelEvent(this, columnIndex, 0));
        }
    }

    private int removeColumn(TableColumn column, boolean doShift) {
        if (this.removeHiddenColumn(column, doShift) < 0) {
            int origColumnIndex;
            int columnIndex = origColumnIndex = this.tableColumns.indexOf(column);
            this.removeColumnOrig(column);
            if (doShift) {
                int n = this.hiddenColumnsPosition.size();
                for (Integer aHiddenColumnsPosition : this.hiddenColumnsPosition) {
                    if (aHiddenColumnsPosition > columnIndex) continue;
                    ++columnIndex;
                }
                for (int i = 0; i < n; ++i) {
                    int index = this.hiddenColumnsPosition.get(i);
                    if (index <= columnIndex) continue;
                    this.hiddenColumnsPosition.set(i, --index);
                }
            }
            return origColumnIndex;
        }
        return -1;
    }

    public void removeColumnOrig(TableColumn column) {
        int columnIndex = this.tableColumns.indexOf(column);
        if (columnIndex != -1) {
            if (this.selectionModel != null) {
                this.selectionModel.removeIndexInterval(columnIndex, columnIndex);
            }
            column.removePropertyChangeListener(this);
            this.tableColumns.removeElementAt(columnIndex);
            this.totalColumnWidth = -1;
        }
    }

    private int removeHiddenColumn(TableColumn column, boolean doShift) {
        int hiddenIndex = -1;
        for (int i = 0; i < this.hiddenColumns.size(); ++i) {
            if (!column.equals(this.hiddenColumns.get(i))) continue;
            hiddenIndex = i;
            break;
        }
        if (hiddenIndex >= 0) {
            this.hiddenColumns.remove(hiddenIndex);
            int hi = this.hiddenColumnsPosition.remove(hiddenIndex);
            if (doShift) {
                int n = this.hiddenColumnsPosition.size();
                for (int i = 0; i < n; ++i) {
                    int index = this.hiddenColumnsPosition.get(i);
                    if (index <= hi) continue;
                    this.hiddenColumnsPosition.set(i, --index);
                }
            }
            return hi;
        }
        return -1;
    }

    public void setColumnHidden(TableColumn column, boolean hidden) {
        int index;
        if (hidden) {
            int columnIndex;
            int index2;
            if (!this.hiddenColumns.contains(column) && (index2 = (columnIndex = this.tableColumns.indexOf(column))) >= 0) {
                this.removeColumn(column, false);
                this.hiddenColumns.add(column);
                for (Integer pos : this.hiddenColumnsPosition) {
                    if (pos > index2) continue;
                    ++index2;
                }
                while (this.hiddenColumnsPosition.contains(index2)) {
                    ++index2;
                }
                this.hiddenColumnsPosition.add(index2);
                if (!this.disableColumnEvents) {
                    this.fireColumnRemoved(new TableColumnModelEvent(this, columnIndex, 0));
                }
            }
        } else if (!this.tableColumns.contains(column) && (index = this.removeHiddenColumn(column, false)) >= 0) {
            int i = index;
            for (Integer pos : this.hiddenColumnsPosition) {
                if (pos >= index) continue;
                --i;
            }
            index = Math.min(i, this.tableColumns.size());
            this.addColumn(column, index);
        }
    }

    List<TableColumn> getAllColumns() {
        ArrayList<TableColumn> columns = Collections.list(this.getColumns());
        columns.addAll(this.hiddenColumns);
        columns.sort(Comparator.comparingInt(TableColumn::getModelIndex));
        return columns;
    }

    public boolean isColumnHidden(TableColumn tc) {
        return this.hiddenColumns.contains(tc);
    }

    public void setVisibleColumnsWithWidths(List<TmmTable.ColumnState> visibleColumnsWithWidths) {
        this.disableColumnEvents = true;
        HashMap<String, Integer> visibleColumnsMap = new HashMap<String, Integer>();
        for (TmmTable.ColumnState state : visibleColumnsWithWidths) {
            visibleColumnsMap.put(state.getIdentifier(), state.getWidth());
        }
        for (TableColumn col : this.getAllColumns()) {
            String identifier = (String)col.getIdentifier();
            if ("node".equalsIgnoreCase(identifier) || visibleColumnsMap.containsKey(identifier)) {
                this.setColumnHidden(col, false);
                int width = visibleColumnsMap.getOrDefault(identifier, 0);
                if (width <= 0) continue;
                col.setPreferredWidth(width);
                col.setWidth(width);
                continue;
            }
            this.setColumnHidden(col, true);
        }
        this.disableColumnEvents = false;
    }

    public void setHiddenColumns(List<String> columnIdentifiers) {
        this.disableColumnEvents = true;
        for (TableColumn col : this.getAllColumns()) {
            if (!columnIdentifiers.contains(col.getIdentifier())) continue;
            this.setColumnHidden(col, true);
        }
        this.disableColumnEvents = false;
    }

    public List<TableColumn> getHiddenColumns() {
        return this.hiddenColumns;
    }
}

