/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Shape;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import org.tinymediamanager.ui.IconManager;

public class StarRater
extends JPanel {
    private static final ImageIcon STAR_BACKGROUND_IMAGE = IconManager.STAR_EMPTY;
    private static final ImageIcon STAR_FOREGROUND_IMAGE = IconManager.STAR_FILLED;
    private final int stars;
    private final int factor;
    private float rating;
    private float paintRating;

    public StarRater() {
        this(5, 1);
    }

    public StarRater(int stars, int factor) {
        this(stars, factor, 0.0f);
    }

    public StarRater(int stars, int factor, float rating) {
        this.stars = stars;
        this.rating = rating;
        this.factor = factor > 0 ? factor : 1;
        this.paintRating = this.rating / (float)this.factor;
        this.setOpaque(false);
        this.setLayout(null);
    }

    public float getRating() {
        return this.rating;
    }

    public void setRating(float rating) {
        this.rating = rating;
        this.paintRating = this.rating / (float)this.factor;
        this.repaint();
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.stars * STAR_BACKGROUND_IMAGE.getIconWidth(), STAR_BACKGROUND_IMAGE.getIconHeight());
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.rating >= 0.0f) {
            int w = STAR_BACKGROUND_IMAGE.getIconWidth();
            int h = STAR_BACKGROUND_IMAGE.getIconHeight();
            int x = 0;
            for (int i = 0; i < this.stars; ++i) {
                STAR_BACKGROUND_IMAGE.paintIcon(this, g, x, 0);
                if (this.paintRating > (float)i) {
                    int dw = this.paintRating >= (float)(i + 1) ? w : Math.round((this.paintRating - (float)i) * (float)w);
                    Shape oldCLip = g.getClip();
                    g.setClip(x, 0, dw, h);
                    STAR_FOREGROUND_IMAGE.paintIcon(this, g, x, 0);
                    g.setClip(oldCLip);
                }
                x += w;
            }
        }
    }
}

