/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.yifysubtitles;

import java.io.InputStream;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.FeatureNotEnabledException;
import org.tinymediamanager.scraper.MediaProviderInfo;
import org.tinymediamanager.scraper.SubtitleSearchAndScrapeOptions;
import org.tinymediamanager.scraper.SubtitleSearchResult;
import org.tinymediamanager.scraper.entities.MediaLanguages;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.http.OnDiskCachedUrl;
import org.tinymediamanager.scraper.interfaces.IMovieSubtitleProvider;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.MediaIdUtil;
import org.tinymediamanager.scraper.util.MetadataUtil;

public class YifySubtitlesProvider
implements IMovieSubtitleProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(YifySubtitlesProvider.class);
    private static final String ID = "yify";

    @Override
    public MediaProviderInfo getProviderInfo() {
        return new MediaProviderInfo(ID, "movie_subtitle", "YifySubtitles.ch", "<html><h3>YifySubtitles.ch</h3><br />A subtitle scraper for YifySubtitles.ch</html>", YifySubtitlesProvider.class.getResource("/org/tinymediamanager/scraper/yifysubtitles-logo-small.png"));
    }

    @Override
    public boolean isActive() {
        return this.isFeatureEnabled();
    }

    private synchronized void initAPI() throws ScrapeException {
        if (!this.isActive()) {
            throw new ScrapeException(new FeatureNotEnabledException(this));
        }
    }

    @Override
    public List<SubtitleSearchResult> search(SubtitleSearchAndScrapeOptions options) throws ScrapeException, MissingIdException {
        this.initAPI();
        String imdbId = options.getImdbId();
        if (!MediaIdUtil.isValidImdbId(imdbId)) {
            throw new MissingIdException(new String[]{"imdb"});
        }
        ArrayList<SubtitleSearchResult> results = new ArrayList();
        results = this.parseDetailPage(imdbId, options.getLanguage());
        Collections.sort(results);
        Collections.reverse(results);
        return results;
    }

    private List<SubtitleSearchResult> parseDetailPage(String imdbId, MediaLanguages language) throws ScrapeException {
        OnDiskCachedUrl url;
        ArrayList<SubtitleSearchResult> results = new ArrayList<SubtitleSearchResult>();
        Document doc = null;
        try {
            url = new OnDiskCachedUrl(this.getApiKey() + "/movie-imdb/" + imdbId, 7, TimeUnit.DAYS);
        }
        catch (Exception e) {
            LOGGER.debug("tried to fetch subtitle detail page for imdb {} - {}", (Object)imdbId, (Object)e.getMessage());
            throw new ScrapeException(e);
        }
        try (InputStream is = url.getInputStream();){
            doc = Jsoup.parse((InputStream)is, (String)"UTF-8", (String)"");
        }
        catch (InterruptedIOException | InterruptedException e) {
            Thread.currentThread().interrupt();
            return results;
        }
        catch (Exception e) {
            LOGGER.debug("tried to parse subtitle detail page for imdb {} - {}", (Object)imdbId, (Object)e.getMessage());
            throw new ScrapeException(e);
        }
        Element table = doc.getElementsByClass("table other-subs").first();
        if (table != null) {
            for (Element tr : ListUtils.nullSafe(table.getElementsByTag("tr"))) {
                SubtitleSearchResult sr = new SubtitleSearchResult(ID);
                boolean langMatched = false;
                block23: for (Element td : tr.getElementsByTag("td")) {
                    switch (td.className()) {
                        case "rating-cell": {
                            int rating = MetadataUtil.parseInt(td.text(), 0);
                            if (rating <= 0) continue block23;
                            sr.setRating(rating);
                            break;
                        }
                        case "flag-cell": {
                            String langu;
                            MediaLanguages stLangu;
                            Element subLang = td.getElementsByClass("sub-lang").first();
                            if (subLang == null || (stLangu = MediaLanguages.get(langu = subLang.text())) != language) continue block23;
                            langMatched = true;
                            break;
                        }
                        case "uploader-cell": {
                            break;
                        }
                        case "other-cell": {
                            Element hi = td.getElementsByClass("hi-subtitle").first();
                            if (hi == null) continue block23;
                            sr.setHearingImpaired(true);
                            break;
                        }
                        default: {
                            Element a = td.getElementsByTag("a").first();
                            if (a == null) continue block23;
                            String downloadUrl = a.attr("href").replace("/subtitles/", this.getApiKey() + "subtitle/") + ".zip";
                            if (a.text().matches(".*[\\[\\(_.-][sS][dD][hH].*")) {
                                sr.setHearingImpaired(true);
                            }
                            sr.setUrl(() -> downloadUrl);
                            sr.setReleaseName(a.ownText().split(" ", 2)[0]);
                        }
                    }
                }
                if (!langMatched) continue;
                results.add(sr);
            }
        }
        return results;
    }
}

