/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.fanarttv;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.internal.bind.DateTypeAdapter;
import java.util.Date;
import okhttp3.Request;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.scraper.fanarttv.services.MovieService;
import org.tinymediamanager.scraper.fanarttv.services.TvShowService;
import org.tinymediamanager.scraper.http.TmmHttpClient;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class FanartTv {
    public static final String API_URL = "https://webservice.fanart.tv/v3/";
    public static final String PARAM_API_KEY = "api-key";
    public static final String PARAM_CLIENT_KEY = "client-key";
    private Retrofit restAdapter;
    private String apiKey = "";
    private String clientKey = "";

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setClientKey(String clientKey) {
        this.clientKey = clientKey;
    }

    public String getClientKey() {
        return this.clientKey;
    }

    protected Retrofit.Builder newRestAdapterBuilder() {
        return new Retrofit.Builder();
    }

    protected Retrofit getRestAdapter() {
        if (this.restAdapter == null) {
            Retrofit.Builder builder = this.newRestAdapterBuilder();
            builder.baseUrl(API_URL);
            builder.addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)this.getGsonBuilder().create()));
            builder.client(TmmHttpClient.newBuilder(true).addInterceptor(chain -> {
                Request original = chain.request();
                Request.Builder request = original.newBuilder().method(original.method(), original.body());
                request.addHeader(PARAM_API_KEY, this.apiKey);
                if (StringUtils.isNotBlank((CharSequence)this.clientKey)) {
                    request.addHeader(PARAM_CLIENT_KEY, this.clientKey);
                }
                return chain.proceed(request.build());
            }).build());
            this.restAdapter = builder.build();
        }
        return this.restAdapter;
    }

    protected GsonBuilder getGsonBuilder() {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(Integer.class, (json, typeOfT, context) -> {
            try {
                return json.getAsInt();
            }
            catch (NumberFormatException e) {
                return 0;
            }
        });
        builder.registerTypeAdapter(Date.class, (Object)new DateTypeAdapter());
        builder.setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES);
        return builder;
    }

    public MovieService getMovieService() {
        return (MovieService)this.getRestAdapter().create(MovieService.class);
    }

    public TvShowService getTvShowService() {
        return (TvShowService)this.getRestAdapter().create(TvShowService.class);
    }
}

