/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.library.bluray.playlist;

import jakarta.xml.bind.annotation.XmlElement;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.tinymediamanager.library.bluray.playlist.PlayItem;
import org.tinymediamanager.library.bluray.playlist.SubPath;

public class PlayList {
    private PlayItem[] playItems;
    private SubPath[] subPaths;

    public void readObject(DataInputStream dataInputStream) throws IOException {
        dataInputStream.skipBytes(6);
        int n = dataInputStream.readUnsignedShort();
        int n2 = dataInputStream.readUnsignedShort();
        PlayItem[] playItemArray = new PlayItem[n];
        for (int i = 0; i < n; ++i) {
            PlayItem playItem = new PlayItem(i);
            playItem.readObject(dataInputStream);
            playItemArray[i] = playItem;
        }
        this.setPlayItems(playItemArray);
        SubPath[] subPathArray = new SubPath[n2];
        for (int i = 0; i < n2; ++i) {
            SubPath subPath = new SubPath(i);
            subPath.readObject(dataInputStream);
            subPathArray[i] = subPath;
        }
        this.setSubPaths(subPathArray);
    }

    public void writeObject(DataOutputStream dataOutputStream) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream2 = new DataOutputStream(byteArrayOutputStream);
        int n2 = this.getPlayItems() == null ? 0 : this.getPlayItems().length;
        int n3 = this.getSubPaths() == null ? 0 : this.getSubPaths().length;
        dataOutputStream2.write(new byte[2]);
        dataOutputStream2.writeShort(n2);
        dataOutputStream2.writeShort(n3);
        for (n = 0; n < n2; ++n) {
            this.getPlayItems()[n].writeObject(dataOutputStream2);
        }
        for (n = 0; n < n3; ++n) {
            this.getSubPaths()[n].writeObject(dataOutputStream2);
        }
        dataOutputStream2.flush();
        dataOutputStream2.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        dataOutputStream.writeInt(byArray.length);
        dataOutputStream.write(byArray);
    }

    @XmlElement(name="PlayItem")
    public PlayItem[] getPlayItems() {
        return this.playItems;
    }

    public void setPlayItems(PlayItem[] playItemArray) {
        for (int i = 0; i < playItemArray.length; ++i) {
            if (i == playItemArray[i].getId()) continue;
            throw new IllegalArgumentException("PlayItem_id does not match the array order");
        }
        this.playItems = playItemArray;
    }

    public SubPath[] getSubPaths() {
        return this.subPaths;
    }

    public void setSubPaths(SubPath[] subPathArray) {
        for (int i = 0; i < subPathArray.length; ++i) {
            if (i == subPathArray[i].getId()) continue;
            throw new IllegalArgumentException("SubPath_id does not match the array order");
        }
        this.subPaths = subPathArray;
    }
}

