/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.library.bluray.clipinf;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.library.bluray.clipinf.AtcDelta;
import org.tinymediamanager.library.bluray.clipinf.HexStringByteAdapter;
import org.tinymediamanager.library.bluray.clipinf.StringIOHelper;

@XmlType(propOrder={"clipStreamType", "applicationType", "isAtcDelta", "tsRecordingRate", "numSourcePackets", "tsTypeLen", "tsTypeValidity", "tsTypeInfoFormatId", "tsTypeInfoNetwork", "tsTypeInfoStream", "atcDeltaNum", "atcDelta", "fontsNum", "fonts"})
public class ClipInfo {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClipInfo.class);
    private byte clipStreamType;
    private byte applicationType;
    private int isAtcDelta;
    private int tsRecordingRate;
    private int numSourcePackets;
    private short tsTypeLen;
    private Byte tsTypeValidity;
    private String tsTypeInfoFormatId;
    private byte[] tsTypeInfoNetwork = new byte[9];
    private byte[] tsTypeInfoStream = new byte[16];
    private byte atcDeltaNum;
    private AtcDelta[] atcDelta;
    private byte fontsNum;
    private byte[] fonts = null;

    public int size() {
        return 180 + (this.isAtcDelta == 1 ? 2 + this.atcDelta[0].size() * this.atcDeltaNum : 0) + (this.applicationType == 6 ? 2 + 6 * this.fontsNum : 0);
    }

    public byte getClipStreamType() {
        return this.clipStreamType;
    }

    public void setClipStreamType(byte by) {
        this.clipStreamType = by;
    }

    public byte getApplicationType() {
        return this.applicationType;
    }

    public void setApplicationType(byte by) {
        this.applicationType = by;
    }

    public int getIsAtcDelta() {
        return this.isAtcDelta;
    }

    public void setIsAtcDelta(int n) {
        this.isAtcDelta = n;
    }

    public int getTsRecordingRate() {
        return this.tsRecordingRate;
    }

    public void setTsRecordingRate(int n) {
        this.tsRecordingRate = n;
    }

    public int getNumSourcePackets() {
        return this.numSourcePackets;
    }

    public void setNumSourcePackets(int n) {
        this.numSourcePackets = n;
    }

    public short getTsTypeLen() {
        return this.tsTypeLen;
    }

    public void setTsTypeLen(short s) {
        this.tsTypeLen = s;
    }

    @XmlJavaTypeAdapter(value=HexStringByteAdapter.class)
    public Byte getTsTypeValidity() {
        return this.tsTypeValidity;
    }

    public void setTsTypeValidity(Byte by) {
        this.tsTypeValidity = by;
    }

    public byte[] getTsTypeInfoNetwork() {
        return this.tsTypeInfoNetwork;
    }

    public void setTsTypeInfoNetwork(byte[] byArray) {
        this.tsTypeInfoNetwork = byArray;
    }

    public byte[] getTsTypeInfoStream() {
        return this.tsTypeInfoStream;
    }

    public void setTsTypeInfoStream(byte[] byArray) {
        this.tsTypeInfoStream = byArray;
    }

    public String getTsTypeInfoFormatId() {
        return this.tsTypeInfoFormatId;
    }

    public void setTsTypeInfoFormatId(String string) {
        this.tsTypeInfoFormatId = string;
    }

    public byte getAtcDeltaNum() {
        return this.atcDeltaNum;
    }

    public void setAtcDeltaNum(byte by) {
        this.atcDeltaNum = by;
    }

    @XmlElement(name="AtcDelta")
    public AtcDelta[] getAtcDelta() {
        return this.atcDelta;
    }

    public void setAtcDelta(AtcDelta[] atcDeltaArray) {
        this.atcDelta = atcDeltaArray;
    }

    public byte getFontsNum() {
        return this.fontsNum;
    }

    public void setFontsNum(byte by) {
        this.fontsNum = by;
    }

    public byte[] getFonts() {
        return this.fonts;
    }

    public void setFonts(byte[] byArray) {
        this.fonts = byArray;
    }

    public void readObject(DataInputStream dataInputStream) throws IOException {
        int n;
        int n2 = dataInputStream.readInt();
        LOGGER.trace("ClipInfo length=" + n2);
        dataInputStream.skipBytes(2);
        this.clipStreamType = dataInputStream.readByte();
        LOGGER.trace("ClipInfo clipStreamType=" + this.clipStreamType);
        this.applicationType = dataInputStream.readByte();
        this.applicationType = (byte)(this.applicationType & 0xF);
        LOGGER.trace("ClipInfo applicationType=" + this.applicationType);
        this.isAtcDelta = dataInputStream.readInt();
        LOGGER.trace("ClipInfo isAtcDelta=" + this.isAtcDelta);
        this.isAtcDelta &= 1;
        this.tsRecordingRate = dataInputStream.readInt();
        LOGGER.trace("ClipInfo tsRecordingRate=" + this.tsRecordingRate / 10000 + "seconds");
        this.numSourcePackets = dataInputStream.readInt();
        LOGGER.trace("ClipInfo numSourcePackets=" + this.numSourcePackets);
        dataInputStream.skipBytes(128);
        this.tsTypeLen = dataInputStream.readShort();
        this.tsTypeValidity = dataInputStream.readByte();
        this.tsTypeInfoFormatId = StringIOHelper.readISO646String(dataInputStream, 4);
        LOGGER.trace("ClipInfo tsTypeInfoFormatId=" + this.tsTypeInfoFormatId);
        dataInputStream.read(this.tsTypeInfoNetwork, 0, 9);
        dataInputStream.read(this.tsTypeInfoStream, 0, 16);
        if (this.isAtcDelta == 1) {
            dataInputStream.skipBytes(1);
            this.atcDeltaNum = dataInputStream.readByte();
            this.atcDelta = new AtcDelta[this.atcDeltaNum];
            for (n = 0; n < this.atcDeltaNum; ++n) {
                this.atcDelta[n] = new AtcDelta();
                this.atcDelta[n].readObject(dataInputStream);
            }
        }
        if (this.applicationType == 6) {
            dataInputStream.skipBytes(1);
            this.fontsNum = dataInputStream.readByte();
            n = this.fontsNum * 6;
            this.fonts = new byte[n];
            dataInputStream.read(this.fonts, 0, n);
        }
    }

    public void writeObject(DataOutputStream dataOutputStream) throws IOException {
        int n;
        dataOutputStream.writeInt(this.size() - 4);
        for (n = 0; n < 2; ++n) {
            dataOutputStream.write(0);
        }
        dataOutputStream.write(this.getClipStreamType());
        dataOutputStream.write(this.getApplicationType());
        dataOutputStream.writeInt(this.getIsAtcDelta() & 1);
        dataOutputStream.writeInt(this.getTsRecordingRate());
        dataOutputStream.writeInt(this.getNumSourcePackets());
        for (n = 0; n < 128; ++n) {
            dataOutputStream.write(0);
        }
        dataOutputStream.writeShort(this.tsTypeLen);
        dataOutputStream.writeByte(this.tsTypeValidity.byteValue());
        dataOutputStream.write(StringIOHelper.getISO646Bytes(this.getTsTypeInfoFormatId()));
        dataOutputStream.write(this.tsTypeInfoNetwork, 0, 9);
        dataOutputStream.write(this.tsTypeInfoStream, 0, 16);
        if (this.isAtcDelta == 1) {
            dataOutputStream.write(0);
            dataOutputStream.write(this.atcDeltaNum);
            for (n = 0; n < this.atcDeltaNum; ++n) {
                this.atcDelta[n].writeObject(dataOutputStream);
            }
        }
        if (this.applicationType == 6) {
            dataOutputStream.write(0);
            dataOutputStream.write(this.fontsNum);
            dataOutputStream.write(this.fonts, 0, this.fontsNum * 6);
        }
    }
}

