/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow.tasks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.threading.TmmThreadPool;
import org.tinymediamanager.core.tvshow.TvShowRenamer;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;

public class TvShowRenameTask
extends TmmThreadPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowRenameTask.class);
    private final List<TvShow> tvShowsToRename = new ArrayList<TvShow>();
    private final List<TvShowEpisode> episodesToRename = new ArrayList<TvShowEpisode>();

    public TvShowRenameTask(TvShow tvShowToRename) {
        this(Collections.singletonList(tvShowToRename), null);
    }

    public TvShowRenameTask(Collection<TvShow> tvShowsToRename) {
        this(tvShowsToRename, null);
    }

    public TvShowRenameTask(Collection<TvShow> tvShowsToRename, Collection<TvShowEpisode> episodesToRename) {
        super(TmmResourceBundle.getString("tvshow.rename"));
        if (tvShowsToRename != null) {
            this.tvShowsToRename.addAll(tvShowsToRename);
        }
        if (episodesToRename != null) {
            this.episodesToRename.addAll(episodesToRename);
        }
    }

    @Override
    protected void doInBackground() {
        try {
            LOGGER.info("Renaming '{}' TV shows / '{}' episodes", (Object)this.tvShowsToRename.size(), (Object)this.episodesToRename.size());
            this.initThreadPool(1, "rename");
            for (TvShowEpisode tvEpisodesToRename : this.episodesToRename) {
                if (this.cancel) break;
                this.submitTask(new RenameEpisodeTask(tvEpisodesToRename));
            }
            this.waitForCompletionOrCancel();
            if (this.cancel) {
                return;
            }
            for (TvShow tvShow : this.tvShowsToRename) {
                TvShowRenamer.renameTvShow(tvShow);
            }
            LOGGER.info("Finished renaming TV shows/episodes - took {} ms", (Object)this.getRuntime());
        }
        catch (Exception e) {
            LOGGER.error("Could not rename TV shows - '{}'", (Object)e.getMessage());
            MessageManager.getInstance().pushMessage(new Message(Message.MessageLevel.ERROR, "Settings.renamer", "message.renamer.threadcrashed"));
        }
    }

    @Override
    public void callback(Object obj) {
        this.publishState((String)obj, this.progressDone);
    }

    private static class RenameEpisodeTask
    implements Callable<Object> {
        private final TvShowEpisode episode;

        public RenameEpisodeTask(TvShowEpisode episode) {
            this.episode = episode;
        }

        @Override
        public String call() {
            TvShowRenamer.renameEpisode(this.episode);
            return this.episode.getTitle();
        }
    }
}

